/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa;

import cdm.base.datetime.BusinessCenterTime;
import cdm.base.staticdata.party.CounterpartyRoleEnum;
import cdm.legaldocumentation.csa.meta.NotificationTimeElectionMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="NotificationTimeElection", builder=NotificationTimeElectionBuilderImpl.class, version="6.7.0")
@RuneDataType(value="NotificationTimeElection", model="cdm", builder=NotificationTimeElectionBuilderImpl.class, version="6.7.0")
public interface NotificationTimeElection
extends RosettaModelObject {
    public static final NotificationTimeElectionMeta metaData = new NotificationTimeElectionMeta();

    public CounterpartyRoleEnum getParty();

    public BusinessCenterTime getNotificationTime();

    public String getCustomNotification();

    public Boolean getLocalBusinessDay();

    public NotificationTimeElection build();

    public NotificationTimeElectionBuilder toBuilder();

    public static NotificationTimeElectionBuilder builder() {
        return new NotificationTimeElectionBuilderImpl();
    }

    default public RosettaMetaData<? extends NotificationTimeElection> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends NotificationTimeElection> getType() {
        return NotificationTimeElection.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("party"), CounterpartyRoleEnum.class, (Object)this.getParty(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notificationTime"), processor, BusinessCenterTime.class, this.getNotificationTime(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("customNotification"), String.class, (Object)this.getCustomNotification(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("localBusinessDay"), Boolean.class, (Object)this.getLocalBusinessDay(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class NotificationTimeElectionBuilderImpl
    implements NotificationTimeElectionBuilder {
        protected CounterpartyRoleEnum party;
        protected BusinessCenterTime.BusinessCenterTimeBuilder notificationTime;
        protected String customNotification;
        protected Boolean localBusinessDay;

        @Override
        @RosettaAttribute(value="party")
        @RuneAttribute(value="party")
        public CounterpartyRoleEnum getParty() {
            return this.party;
        }

        @Override
        @RosettaAttribute(value="notificationTime")
        @RuneAttribute(value="notificationTime")
        public BusinessCenterTime.BusinessCenterTimeBuilder getNotificationTime() {
            return this.notificationTime;
        }

        @Override
        public BusinessCenterTime.BusinessCenterTimeBuilder getOrCreateNotificationTime() {
            BusinessCenterTime.BusinessCenterTimeBuilder result = this.notificationTime != null ? this.notificationTime : (this.notificationTime = BusinessCenterTime.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="customNotification")
        @RuneAttribute(value="customNotification")
        public String getCustomNotification() {
            return this.customNotification;
        }

        @Override
        @RosettaAttribute(value="localBusinessDay")
        @RuneAttribute(value="localBusinessDay")
        public Boolean getLocalBusinessDay() {
            return this.localBusinessDay;
        }

        @Override
        @RosettaAttribute(value="party")
        @RuneAttribute(value="party")
        public NotificationTimeElectionBuilder setParty(CounterpartyRoleEnum _party) {
            this.party = _party == null ? null : _party;
            return this;
        }

        @Override
        @RosettaAttribute(value="notificationTime")
        @RuneAttribute(value="notificationTime")
        public NotificationTimeElectionBuilder setNotificationTime(BusinessCenterTime _notificationTime) {
            this.notificationTime = _notificationTime == null ? null : _notificationTime.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="customNotification")
        @RuneAttribute(value="customNotification")
        public NotificationTimeElectionBuilder setCustomNotification(String _customNotification) {
            this.customNotification = _customNotification == null ? null : _customNotification;
            return this;
        }

        @Override
        @RosettaAttribute(value="localBusinessDay")
        @RuneAttribute(value="localBusinessDay")
        public NotificationTimeElectionBuilder setLocalBusinessDay(Boolean _localBusinessDay) {
            this.localBusinessDay = _localBusinessDay == null ? null : _localBusinessDay;
            return this;
        }

        @Override
        public NotificationTimeElection build() {
            return new NotificationTimeElectionImpl(this);
        }

        @Override
        public NotificationTimeElectionBuilder toBuilder() {
            return this;
        }

        @Override
        public NotificationTimeElectionBuilder prune() {
            if (this.notificationTime != null && !this.notificationTime.prune().hasData()) {
                this.notificationTime = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getParty() != null) {
                return true;
            }
            if (this.getNotificationTime() != null && this.getNotificationTime().hasData()) {
                return true;
            }
            if (this.getCustomNotification() != null) {
                return true;
            }
            return this.getLocalBusinessDay() != null;
        }

        public NotificationTimeElectionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            NotificationTimeElectionBuilder o = (NotificationTimeElectionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNotificationTime(), (RosettaModelObjectBuilder)o.getNotificationTime(), this::setNotificationTime);
            merger.mergeBasic((Object)this.getParty(), (Object)o.getParty(), this::setParty, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCustomNotification(), (Object)o.getCustomNotification(), this::setCustomNotification, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getLocalBusinessDay(), (Object)o.getLocalBusinessDay(), this::setLocalBusinessDay, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            NotificationTimeElection _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.party, (Object)_that.getParty())) {
                return false;
            }
            if (!Objects.equals(this.notificationTime, _that.getNotificationTime())) {
                return false;
            }
            if (!Objects.equals(this.customNotification, _that.getCustomNotification())) {
                return false;
            }
            return Objects.equals(this.localBusinessDay, _that.getLocalBusinessDay());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.party != null ? ((Object)((Object)this.party)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.notificationTime != null ? this.notificationTime.hashCode() : 0);
            _result = 31 * _result + (this.customNotification != null ? this.customNotification.hashCode() : 0);
            _result = 31 * _result + (this.localBusinessDay != null ? this.localBusinessDay.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "NotificationTimeElectionBuilder {party=" + (Object)((Object)this.party) + ", notificationTime=" + this.notificationTime + ", customNotification=" + this.customNotification + ", localBusinessDay=" + this.localBusinessDay + '}';
        }
    }

    public static interface NotificationTimeElectionBuilder
    extends NotificationTimeElection,
    RosettaModelObjectBuilder {
        public BusinessCenterTime.BusinessCenterTimeBuilder getOrCreateNotificationTime();

        @Override
        public BusinessCenterTime.BusinessCenterTimeBuilder getNotificationTime();

        public NotificationTimeElectionBuilder setParty(CounterpartyRoleEnum var1);

        public NotificationTimeElectionBuilder setNotificationTime(BusinessCenterTime var1);

        public NotificationTimeElectionBuilder setCustomNotification(String var1);

        public NotificationTimeElectionBuilder setLocalBusinessDay(Boolean var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("party"), CounterpartyRoleEnum.class, (Object)this.getParty(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notificationTime"), processor, BusinessCenterTime.BusinessCenterTimeBuilder.class, this.getNotificationTime(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("customNotification"), String.class, (Object)this.getCustomNotification(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("localBusinessDay"), Boolean.class, (Object)this.getLocalBusinessDay(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public NotificationTimeElectionBuilder prune();
    }

    public static class NotificationTimeElectionImpl
    implements NotificationTimeElection {
        private final CounterpartyRoleEnum party;
        private final BusinessCenterTime notificationTime;
        private final String customNotification;
        private final Boolean localBusinessDay;

        protected NotificationTimeElectionImpl(NotificationTimeElectionBuilder builder) {
            this.party = builder.getParty();
            this.notificationTime = Optional.ofNullable(builder.getNotificationTime()).map(f -> f.build()).orElse(null);
            this.customNotification = builder.getCustomNotification();
            this.localBusinessDay = builder.getLocalBusinessDay();
        }

        @Override
        @RosettaAttribute(value="party")
        @RuneAttribute(value="party")
        public CounterpartyRoleEnum getParty() {
            return this.party;
        }

        @Override
        @RosettaAttribute(value="notificationTime")
        @RuneAttribute(value="notificationTime")
        public BusinessCenterTime getNotificationTime() {
            return this.notificationTime;
        }

        @Override
        @RosettaAttribute(value="customNotification")
        @RuneAttribute(value="customNotification")
        public String getCustomNotification() {
            return this.customNotification;
        }

        @Override
        @RosettaAttribute(value="localBusinessDay")
        @RuneAttribute(value="localBusinessDay")
        public Boolean getLocalBusinessDay() {
            return this.localBusinessDay;
        }

        @Override
        public NotificationTimeElection build() {
            return this;
        }

        @Override
        public NotificationTimeElectionBuilder toBuilder() {
            NotificationTimeElectionBuilder builder = NotificationTimeElection.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(NotificationTimeElectionBuilder builder) {
            Optional.ofNullable(this.getParty()).ifPresent(builder::setParty);
            Optional.ofNullable(this.getNotificationTime()).ifPresent(builder::setNotificationTime);
            Optional.ofNullable(this.getCustomNotification()).ifPresent(builder::setCustomNotification);
            Optional.ofNullable(this.getLocalBusinessDay()).ifPresent(builder::setLocalBusinessDay);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            NotificationTimeElection _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.party, (Object)_that.getParty())) {
                return false;
            }
            if (!Objects.equals(this.notificationTime, _that.getNotificationTime())) {
                return false;
            }
            if (!Objects.equals(this.customNotification, _that.getCustomNotification())) {
                return false;
            }
            return Objects.equals(this.localBusinessDay, _that.getLocalBusinessDay());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.party != null ? ((Object)((Object)this.party)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.notificationTime != null ? this.notificationTime.hashCode() : 0);
            _result = 31 * _result + (this.customNotification != null ? this.customNotification.hashCode() : 0);
            _result = 31 * _result + (this.localBusinessDay != null ? this.localBusinessDay.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "NotificationTimeElection {party=" + (Object)((Object)this.party) + ", notificationTime=" + this.notificationTime + ", customNotification=" + this.customNotification + ", localBusinessDay=" + this.localBusinessDay + '}';
        }
    }
}

