/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa;

import cdm.legaldocumentation.csa.ApplicableRegime;
import cdm.legaldocumentation.csa.meta.RegimeMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Regime", builder=RegimeBuilderImpl.class, version="6.7.0")
@RuneDataType(value="Regime", model="cdm", builder=RegimeBuilderImpl.class, version="6.7.0")
public interface Regime
extends RosettaModelObject {
    public static final RegimeMeta metaData = new RegimeMeta();

    public List<? extends ApplicableRegime> getApplicableRegime();

    public BigDecimal getFallbackToMandatoryMethodDays();

    public Regime build();

    public RegimeBuilder toBuilder();

    public static RegimeBuilder builder() {
        return new RegimeBuilderImpl();
    }

    default public RosettaMetaData<? extends Regime> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Regime> getType() {
        return Regime.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("applicableRegime"), processor, ApplicableRegime.class, this.getApplicableRegime(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fallbackToMandatoryMethodDays"), BigDecimal.class, (Object)this.getFallbackToMandatoryMethodDays(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class RegimeBuilderImpl
    implements RegimeBuilder {
        protected List<ApplicableRegime.ApplicableRegimeBuilder> applicableRegime = new ArrayList<ApplicableRegime.ApplicableRegimeBuilder>();
        protected BigDecimal fallbackToMandatoryMethodDays;

        @Override
        @RosettaAttribute(value="applicableRegime")
        @RuneAttribute(value="applicableRegime")
        public List<? extends ApplicableRegime.ApplicableRegimeBuilder> getApplicableRegime() {
            return this.applicableRegime;
        }

        @Override
        public ApplicableRegime.ApplicableRegimeBuilder getOrCreateApplicableRegime(int _index) {
            if (this.applicableRegime == null) {
                this.applicableRegime = new ArrayList<ApplicableRegime.ApplicableRegimeBuilder>();
            }
            return (ApplicableRegime.ApplicableRegimeBuilder)this.getIndex(this.applicableRegime, _index, () -> {
                ApplicableRegime.ApplicableRegimeBuilder newApplicableRegime = ApplicableRegime.builder();
                return newApplicableRegime;
            });
        }

        @Override
        @RosettaAttribute(value="fallbackToMandatoryMethodDays")
        @RuneAttribute(value="fallbackToMandatoryMethodDays")
        public BigDecimal getFallbackToMandatoryMethodDays() {
            return this.fallbackToMandatoryMethodDays;
        }

        @Override
        @RosettaAttribute(value="applicableRegime")
        @RuneAttribute(value="applicableRegime")
        public RegimeBuilder addApplicableRegime(ApplicableRegime _applicableRegime) {
            if (_applicableRegime != null) {
                this.applicableRegime.add(_applicableRegime.toBuilder());
            }
            return this;
        }

        @Override
        public RegimeBuilder addApplicableRegime(ApplicableRegime _applicableRegime, int _idx) {
            this.getIndex(this.applicableRegime, _idx, () -> _applicableRegime.toBuilder());
            return this;
        }

        @Override
        public RegimeBuilder addApplicableRegime(List<? extends ApplicableRegime> applicableRegimes) {
            if (applicableRegimes != null) {
                for (ApplicableRegime applicableRegime : applicableRegimes) {
                    this.applicableRegime.add(applicableRegime.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="applicableRegime")
        public RegimeBuilder setApplicableRegime(List<? extends ApplicableRegime> applicableRegimes) {
            this.applicableRegime = applicableRegimes == null ? new ArrayList<ApplicableRegime.ApplicableRegimeBuilder>() : (List)applicableRegimes.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="fallbackToMandatoryMethodDays")
        @RuneAttribute(value="fallbackToMandatoryMethodDays")
        public RegimeBuilder setFallbackToMandatoryMethodDays(BigDecimal _fallbackToMandatoryMethodDays) {
            this.fallbackToMandatoryMethodDays = _fallbackToMandatoryMethodDays == null ? null : _fallbackToMandatoryMethodDays;
            return this;
        }

        @Override
        public Regime build() {
            return new RegimeImpl(this);
        }

        @Override
        public RegimeBuilder toBuilder() {
            return this;
        }

        @Override
        public RegimeBuilder prune() {
            this.applicableRegime = this.applicableRegime.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getApplicableRegime() != null && this.getApplicableRegime().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getFallbackToMandatoryMethodDays() != null;
        }

        public RegimeBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            RegimeBuilder o = (RegimeBuilder)other;
            merger.mergeRosetta(this.getApplicableRegime(), o.getApplicableRegime(), this::getOrCreateApplicableRegime);
            merger.mergeBasic((Object)this.getFallbackToMandatoryMethodDays(), (Object)o.getFallbackToMandatoryMethodDays(), this::setFallbackToMandatoryMethodDays, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Regime _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.applicableRegime, _that.getApplicableRegime())) {
                return false;
            }
            return Objects.equals(this.fallbackToMandatoryMethodDays, _that.getFallbackToMandatoryMethodDays());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.applicableRegime != null ? this.applicableRegime.hashCode() : 0);
            _result = 31 * _result + (this.fallbackToMandatoryMethodDays != null ? this.fallbackToMandatoryMethodDays.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "RegimeBuilder {applicableRegime=" + this.applicableRegime + ", fallbackToMandatoryMethodDays=" + this.fallbackToMandatoryMethodDays + '}';
        }
    }

    public static interface RegimeBuilder
    extends Regime,
    RosettaModelObjectBuilder {
        public ApplicableRegime.ApplicableRegimeBuilder getOrCreateApplicableRegime(int var1);

        public List<? extends ApplicableRegime.ApplicableRegimeBuilder> getApplicableRegime();

        public RegimeBuilder addApplicableRegime(ApplicableRegime var1);

        public RegimeBuilder addApplicableRegime(ApplicableRegime var1, int var2);

        public RegimeBuilder addApplicableRegime(List<? extends ApplicableRegime> var1);

        public RegimeBuilder setApplicableRegime(List<? extends ApplicableRegime> var1);

        public RegimeBuilder setFallbackToMandatoryMethodDays(BigDecimal var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("applicableRegime"), processor, ApplicableRegime.ApplicableRegimeBuilder.class, this.getApplicableRegime(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fallbackToMandatoryMethodDays"), BigDecimal.class, (Object)this.getFallbackToMandatoryMethodDays(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public RegimeBuilder prune();
    }

    public static class RegimeImpl
    implements Regime {
        private final List<? extends ApplicableRegime> applicableRegime;
        private final BigDecimal fallbackToMandatoryMethodDays;

        protected RegimeImpl(RegimeBuilder builder) {
            this.applicableRegime = Optional.ofNullable(builder.getApplicableRegime()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.fallbackToMandatoryMethodDays = builder.getFallbackToMandatoryMethodDays();
        }

        @Override
        @RosettaAttribute(value="applicableRegime")
        @RuneAttribute(value="applicableRegime")
        public List<? extends ApplicableRegime> getApplicableRegime() {
            return this.applicableRegime;
        }

        @Override
        @RosettaAttribute(value="fallbackToMandatoryMethodDays")
        @RuneAttribute(value="fallbackToMandatoryMethodDays")
        public BigDecimal getFallbackToMandatoryMethodDays() {
            return this.fallbackToMandatoryMethodDays;
        }

        @Override
        public Regime build() {
            return this;
        }

        @Override
        public RegimeBuilder toBuilder() {
            RegimeBuilder builder = Regime.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(RegimeBuilder builder) {
            Optional.ofNullable(this.getApplicableRegime()).ifPresent(builder::setApplicableRegime);
            Optional.ofNullable(this.getFallbackToMandatoryMethodDays()).ifPresent(builder::setFallbackToMandatoryMethodDays);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Regime _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.applicableRegime, _that.getApplicableRegime())) {
                return false;
            }
            return Objects.equals(this.fallbackToMandatoryMethodDays, _that.getFallbackToMandatoryMethodDays());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.applicableRegime != null ? this.applicableRegime.hashCode() : 0);
            _result = 31 * _result + (this.fallbackToMandatoryMethodDays != null ? this.fallbackToMandatoryMethodDays.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Regime {applicableRegime=" + this.applicableRegime + ", fallbackToMandatoryMethodDays=" + this.fallbackToMandatoryMethodDays + '}';
        }
    }
}

