/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa.processor;

import cdm.legaldocumentation.csa.ExceptionEnum;
import cdm.legaldocumentation.csa.RegimeTerms;
import cdm.legaldocumentation.csa.RetrospectiveEffect;
import cdm.legaldocumentation.csa.SimmException;
import cdm.legaldocumentation.csa.SimmExceptionApplicableEnum;
import com.regnosys.rosetta.common.translation.Mapping;
import com.regnosys.rosetta.common.translation.MappingProcessorUtils;
import com.regnosys.rosetta.common.translation.Path;
import com.regnosys.rosetta.common.translation.SynonymToEnumMap;
import com.rosetta.model.lib.path.RosettaPath;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.isda.cdm.processor.CreateiQMappingProcessorUtils;

class RegimeMappingHelper {
    private static final List<String> SUFFIXES = Arrays.asList("_secured_party", "_security_taker", "_obligee");
    private final RosettaPath path;
    private final List<Mapping> mappings;
    private final SynonymToEnumMap synonymToEnumMap;

    RegimeMappingHelper(RosettaPath path, List<Mapping> mappings, SynonymToEnumMap synonymToEnumMap) {
        this.path = path;
        this.mappings = mappings;
        this.synonymToEnumMap = synonymToEnumMap;
    }

    Optional<RegimeTerms> getRegimeTerms(Path regimePath, String party, Integer index) {
        RegimeTerms.RegimeTermsBuilder regimeTermsBuilder = RegimeTerms.builder();
        SUFFIXES.forEach(suffix -> {
            MappingProcessorUtils.setValueAndUpdateMappings((Path)regimePath.addElement(party + suffix, index), value -> this.synonymToEnumMap.getEnumValueOptional(ExceptionEnum.class, value).ifPresent(enumValue -> regimeTermsBuilder.setParty(CreateiQMappingProcessorUtils.toCounterpartyRoleEnum(party)).setIsApplicable((ExceptionEnum)((Object)((Object)((Object)enumValue))))), this.mappings, (RosettaPath)this.path);
            MappingProcessorUtils.setValueAndUpdateMappings((Path)regimePath.addElement(party + suffix + "_specify", index), value -> regimeTermsBuilder.setAsSpecified(CreateiQMappingProcessorUtils.removeHtml(value)), this.mappings, (RosettaPath)this.path);
        });
        this.getSimmException(regimePath, party, index).ifPresent(regimeTermsBuilder::setSimmException);
        this.getRetrospectiveEffect(regimePath, party, index).ifPresent(regimeTermsBuilder::setRetrospectiveEffect);
        MappingProcessorUtils.setValueAndUpdateMappings((Path)regimePath.addElement("other", index), value -> regimeTermsBuilder.setAsSpecified(CreateiQMappingProcessorUtils.removeHtml(value)), this.mappings, (RosettaPath)this.path);
        return regimeTermsBuilder.hasData() ? Optional.of(regimeTermsBuilder.build()) : Optional.empty();
    }

    private Optional<SimmException> getSimmException(Path regimePath, String party, Integer index) {
        SimmException.SimmExceptionBuilder simmExceptionBuilder = SimmException.builder();
        MappingProcessorUtils.setValueAndUpdateMappings((Path)regimePath.addElement(party + "_SIMM", index), value -> this.synonymToEnumMap.getEnumValueOptional(ExceptionEnum.class, value).ifPresent(simmExceptionBuilder::setStandardisedException), this.mappings, (RosettaPath)this.path);
        MappingProcessorUtils.setValueAndUpdateMappings((Path)regimePath.addElement(party + "_fallback", index), value -> this.synonymToEnumMap.getEnumValueOptional(SimmExceptionApplicableEnum.class, value).ifPresent(simmExceptionBuilder::setSimmExceptionApplicable), this.mappings, (RosettaPath)this.path);
        MappingProcessorUtils.setValueAndUpdateMappings((Path)regimePath.addElement(party + "_SIMM_specify", index), value -> simmExceptionBuilder.setAsSpecified(CreateiQMappingProcessorUtils.removeHtml(value)), this.mappings, (RosettaPath)this.path);
        MappingProcessorUtils.setValueAndUpdateMappings((Path)regimePath.addElement(party + "_fallback_specify", index), value -> simmExceptionBuilder.setAsSpecified(CreateiQMappingProcessorUtils.removeHtml(value)), this.mappings, (RosettaPath)this.path);
        MappingProcessorUtils.setValueAndUpdateMappings((Path)regimePath.addElement(party + "_SIMM_applicable_specify", index), value -> simmExceptionBuilder.setAsSpecified(CreateiQMappingProcessorUtils.removeHtml(value)), this.mappings, (RosettaPath)this.path);
        return simmExceptionBuilder.hasData() ? Optional.of(simmExceptionBuilder.build()) : Optional.empty();
    }

    private Optional<RetrospectiveEffect> getRetrospectiveEffect(Path regimePath, String party, Integer index) {
        RetrospectiveEffect.RetrospectiveEffectBuilder retrospectiveEffectBuilder = RetrospectiveEffect.builder();
        MappingProcessorUtils.setValueAndUpdateMappings((Path)regimePath.addElement(party + "_retrospective", index), value -> this.synonymToEnumMap.getEnumValueOptional(ExceptionEnum.class, value).ifPresent(retrospectiveEffectBuilder::setStandardisedException), this.mappings, (RosettaPath)this.path);
        MappingProcessorUtils.setValueAndUpdateMappings((Path)regimePath.addElement(party + "_retrospective_specify", index), value -> retrospectiveEffectBuilder.setAsSpecified(CreateiQMappingProcessorUtils.removeHtml(value)), this.mappings, (RosettaPath)this.path);
        return Optional.of(retrospectiveEffectBuilder.build());
    }
}

