/*
 * Decompiled with CFR 0.152.
 */
package cdm.margin.schedule.functions;

import cdm.base.datetime.functions.DateDifference;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=DateDifferenceYearsDefault.class)
public abstract class DateDifferenceYears
implements RosettaFunction {
    @Inject
    protected DateDifference dateDifference;

    public BigDecimal evaluate(Date firstDate, Date secondDate) {
        BigDecimal difference = this.doEvaluate(firstDate, secondDate);
        return difference;
    }

    protected abstract BigDecimal doEvaluate(Date var1, Date var2);

    public static class DateDifferenceYearsDefault
    extends DateDifferenceYears {
        @Override
        protected BigDecimal doEvaluate(Date firstDate, Date secondDate) {
            BigDecimal difference = null;
            return this.assignOutput(difference, firstDate, secondDate);
        }

        protected BigDecimal assignOutput(BigDecimal difference, Date firstDate, Date secondDate) {
            Integer integer = this.dateDifference.evaluate(firstDate, secondDate);
            difference = (BigDecimal)MapperMaths.divide((Mapper)(integer == null ? MapperS.ofNull() : MapperS.of((Object)BigDecimal.valueOf(integer.intValue()))), (Mapper)MapperS.of((Object)new BigDecimal("365.0"))).get();
            return difference;
        }
    }
}

