/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset;

import cdm.base.staticdata.asset.common.AssetBase;
import cdm.base.staticdata.asset.common.AssetIdentifier;
import cdm.base.staticdata.asset.common.Taxonomy;
import cdm.base.staticdata.party.LegalEntity;
import cdm.observable.asset.BasketConstituent;
import cdm.observable.asset.meta.BasketMeta;
import cdm.observable.asset.metafields.FieldWithMetaBasketConstituent;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneScopedAttributeKey;
import com.rosetta.model.lib.meta.Key;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Basket", builder=BasketBuilderImpl.class, version="6.7.0")
@RuneDataType(value="Basket", model="cdm", builder=BasketBuilderImpl.class, version="6.7.0")
public interface Basket
extends AssetBase {
    public static final BasketMeta metaData = new BasketMeta();

    public List<? extends FieldWithMetaBasketConstituent> getBasketConstituent();

    @Override
    public Basket build();

    @Override
    public BasketBuilder toBuilder();

    public static BasketBuilder builder() {
        return new BasketBuilderImpl();
    }

    default public RosettaMetaData<? extends Basket> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Basket> getType() {
        return Basket.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("identifier"), processor, AssetIdentifier.class, this.getIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("taxonomy"), processor, Taxonomy.class, this.getTaxonomy(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("isExchangeListed"), Boolean.class, (Object)this.getIsExchangeListed(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchange"), processor, LegalEntity.class, this.getExchange(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("relatedExchange"), processor, LegalEntity.class, this.getRelatedExchange(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("basketConstituent"), processor, FieldWithMetaBasketConstituent.class, this.getBasketConstituent(), new AttributeMeta[0]);
    }

    public static class BasketBuilderImpl
    extends AssetBase.AssetBaseBuilderImpl
    implements BasketBuilder {
        protected List<FieldWithMetaBasketConstituent.FieldWithMetaBasketConstituentBuilder> basketConstituent = new ArrayList<FieldWithMetaBasketConstituent.FieldWithMetaBasketConstituentBuilder>();

        @Override
        @RosettaAttribute(value="basketConstituent")
        @RuneAttribute(value="basketConstituent")
        @RuneScopedAttributeKey
        public List<? extends FieldWithMetaBasketConstituent.FieldWithMetaBasketConstituentBuilder> getBasketConstituent() {
            return this.basketConstituent;
        }

        @Override
        public FieldWithMetaBasketConstituent.FieldWithMetaBasketConstituentBuilder getOrCreateBasketConstituent(int _index) {
            if (this.basketConstituent == null) {
                this.basketConstituent = new ArrayList<FieldWithMetaBasketConstituent.FieldWithMetaBasketConstituentBuilder>();
            }
            return (FieldWithMetaBasketConstituent.FieldWithMetaBasketConstituentBuilder)this.getIndex(this.basketConstituent, _index, () -> {
                FieldWithMetaBasketConstituent.FieldWithMetaBasketConstituentBuilder newBasketConstituent = FieldWithMetaBasketConstituent.builder();
                newBasketConstituent.getOrCreateMeta().addKey((Key)Key.builder().setScope("DOCUMENT"));
                return newBasketConstituent;
            });
        }

        @Override
        @RosettaAttribute(value="identifier")
        @RuneAttribute(value="identifier")
        public BasketBuilder addIdentifier(AssetIdentifier _identifier) {
            if (_identifier != null) {
                this.identifier.add(_identifier.toBuilder());
            }
            return this;
        }

        @Override
        public BasketBuilder addIdentifier(AssetIdentifier _identifier, int _idx) {
            this.getIndex(this.identifier, _idx, () -> _identifier.toBuilder());
            return this;
        }

        @Override
        public BasketBuilder addIdentifier(List<? extends AssetIdentifier> identifiers) {
            if (identifiers != null) {
                for (AssetIdentifier assetIdentifier : identifiers) {
                    this.identifier.add(assetIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="identifier")
        public BasketBuilder setIdentifier(List<? extends AssetIdentifier> identifiers) {
            this.identifier = identifiers == null ? new ArrayList() : (List)identifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="taxonomy")
        @RuneAttribute(value="taxonomy")
        public BasketBuilder addTaxonomy(Taxonomy _taxonomy) {
            if (_taxonomy != null) {
                this.taxonomy.add(_taxonomy.toBuilder());
            }
            return this;
        }

        @Override
        public BasketBuilder addTaxonomy(Taxonomy _taxonomy, int _idx) {
            this.getIndex(this.taxonomy, _idx, () -> _taxonomy.toBuilder());
            return this;
        }

        @Override
        public BasketBuilder addTaxonomy(List<? extends Taxonomy> taxonomys) {
            if (taxonomys != null) {
                for (Taxonomy taxonomy : taxonomys) {
                    this.taxonomy.add(taxonomy.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="taxonomy")
        public BasketBuilder setTaxonomy(List<? extends Taxonomy> taxonomys) {
            this.taxonomy = taxonomys == null ? new ArrayList() : (List)taxonomys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="isExchangeListed")
        @RuneAttribute(value="isExchangeListed")
        public BasketBuilder setIsExchangeListed(Boolean _isExchangeListed) {
            this.isExchangeListed = _isExchangeListed == null ? null : _isExchangeListed;
            return this;
        }

        @Override
        @RosettaAttribute(value="exchange")
        @RuneAttribute(value="exchange")
        public BasketBuilder setExchange(LegalEntity _exchange) {
            this.exchange = _exchange == null ? null : _exchange.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="relatedExchange")
        @RuneAttribute(value="relatedExchange")
        public BasketBuilder addRelatedExchange(LegalEntity _relatedExchange) {
            if (_relatedExchange != null) {
                this.relatedExchange.add(_relatedExchange.toBuilder());
            }
            return this;
        }

        @Override
        public BasketBuilder addRelatedExchange(LegalEntity _relatedExchange, int _idx) {
            this.getIndex(this.relatedExchange, _idx, () -> _relatedExchange.toBuilder());
            return this;
        }

        @Override
        public BasketBuilder addRelatedExchange(List<? extends LegalEntity> relatedExchanges) {
            if (relatedExchanges != null) {
                for (LegalEntity legalEntity : relatedExchanges) {
                    this.relatedExchange.add(legalEntity.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="relatedExchange")
        public BasketBuilder setRelatedExchange(List<? extends LegalEntity> relatedExchanges) {
            this.relatedExchange = relatedExchanges == null ? new ArrayList() : (List)relatedExchanges.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="basketConstituent")
        @RuneAttribute(value="basketConstituent")
        @RuneScopedAttributeKey
        public BasketBuilder addBasketConstituent(FieldWithMetaBasketConstituent _basketConstituent) {
            if (_basketConstituent != null) {
                this.basketConstituent.add(_basketConstituent.toBuilder());
            }
            return this;
        }

        @Override
        public BasketBuilder addBasketConstituent(FieldWithMetaBasketConstituent _basketConstituent, int _idx) {
            this.getIndex(this.basketConstituent, _idx, () -> _basketConstituent.toBuilder());
            return this;
        }

        @Override
        public BasketBuilder addBasketConstituentValue(BasketConstituent _basketConstituent) {
            this.getOrCreateBasketConstituent(-1).setValue(_basketConstituent.toBuilder());
            return this;
        }

        @Override
        public BasketBuilder addBasketConstituentValue(BasketConstituent _basketConstituent, int _idx) {
            this.getOrCreateBasketConstituent(_idx).setValue(_basketConstituent.toBuilder());
            return this;
        }

        @Override
        public BasketBuilder addBasketConstituent(List<? extends FieldWithMetaBasketConstituent> basketConstituents) {
            if (basketConstituents != null) {
                for (FieldWithMetaBasketConstituent fieldWithMetaBasketConstituent : basketConstituents) {
                    this.basketConstituent.add(fieldWithMetaBasketConstituent.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="basketConstituent")
        @RuneScopedAttributeKey
        public BasketBuilder setBasketConstituent(List<? extends FieldWithMetaBasketConstituent> basketConstituents) {
            this.basketConstituent = basketConstituents == null ? new ArrayList<FieldWithMetaBasketConstituent.FieldWithMetaBasketConstituentBuilder>() : (List)basketConstituents.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public BasketBuilder addBasketConstituentValue(List<? extends BasketConstituent> basketConstituents) {
            if (basketConstituents != null) {
                for (BasketConstituent basketConstituent : basketConstituents) {
                    this.addBasketConstituentValue(basketConstituent);
                }
            }
            return this;
        }

        @Override
        public BasketBuilder setBasketConstituentValue(List<? extends BasketConstituent> basketConstituents) {
            this.basketConstituent.clear();
            if (basketConstituents != null) {
                basketConstituents.forEach(this::addBasketConstituentValue);
            }
            return this;
        }

        @Override
        public Basket build() {
            return new BasketImpl(this);
        }

        @Override
        public BasketBuilder toBuilder() {
            return this;
        }

        @Override
        public BasketBuilder prune() {
            super.prune();
            this.basketConstituent = this.basketConstituent.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getBasketConstituent() != null && this.getBasketConstituent().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public BasketBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            BasketBuilder o = (BasketBuilder)other;
            merger.mergeRosetta(this.getBasketConstituent(), o.getBasketConstituent(), this::getOrCreateBasketConstituent);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Basket _that = (Basket)this.getType().cast(o);
            return ListEquals.listEquals(this.basketConstituent, _that.getBasketConstituent());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.basketConstituent != null ? this.basketConstituent.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "BasketBuilder {basketConstituent=" + this.basketConstituent + '}' + " " + super.toString();
        }
    }

    public static interface BasketBuilder
    extends Basket,
    AssetBase.AssetBaseBuilder {
        public FieldWithMetaBasketConstituent.FieldWithMetaBasketConstituentBuilder getOrCreateBasketConstituent(int var1);

        public List<? extends FieldWithMetaBasketConstituent.FieldWithMetaBasketConstituentBuilder> getBasketConstituent();

        @Override
        public BasketBuilder addIdentifier(AssetIdentifier var1);

        @Override
        public BasketBuilder addIdentifier(AssetIdentifier var1, int var2);

        @Override
        public BasketBuilder addIdentifier(List<? extends AssetIdentifier> var1);

        @Override
        public BasketBuilder setIdentifier(List<? extends AssetIdentifier> var1);

        @Override
        public BasketBuilder addTaxonomy(Taxonomy var1);

        @Override
        public BasketBuilder addTaxonomy(Taxonomy var1, int var2);

        @Override
        public BasketBuilder addTaxonomy(List<? extends Taxonomy> var1);

        @Override
        public BasketBuilder setTaxonomy(List<? extends Taxonomy> var1);

        @Override
        public BasketBuilder setIsExchangeListed(Boolean var1);

        @Override
        public BasketBuilder setExchange(LegalEntity var1);

        @Override
        public BasketBuilder addRelatedExchange(LegalEntity var1);

        @Override
        public BasketBuilder addRelatedExchange(LegalEntity var1, int var2);

        @Override
        public BasketBuilder addRelatedExchange(List<? extends LegalEntity> var1);

        @Override
        public BasketBuilder setRelatedExchange(List<? extends LegalEntity> var1);

        public BasketBuilder addBasketConstituent(FieldWithMetaBasketConstituent var1);

        public BasketBuilder addBasketConstituent(FieldWithMetaBasketConstituent var1, int var2);

        public BasketBuilder addBasketConstituentValue(BasketConstituent var1);

        public BasketBuilder addBasketConstituentValue(BasketConstituent var1, int var2);

        public BasketBuilder addBasketConstituent(List<? extends FieldWithMetaBasketConstituent> var1);

        public BasketBuilder setBasketConstituent(List<? extends FieldWithMetaBasketConstituent> var1);

        public BasketBuilder addBasketConstituentValue(List<? extends BasketConstituent> var1);

        public BasketBuilder setBasketConstituentValue(List<? extends BasketConstituent> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("identifier"), processor, AssetIdentifier.AssetIdentifierBuilder.class, this.getIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("taxonomy"), processor, Taxonomy.TaxonomyBuilder.class, this.getTaxonomy(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("isExchangeListed"), Boolean.class, (Object)this.getIsExchangeListed(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchange"), processor, LegalEntity.LegalEntityBuilder.class, (RosettaModelObjectBuilder)this.getExchange(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("relatedExchange"), processor, LegalEntity.LegalEntityBuilder.class, this.getRelatedExchange(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("basketConstituent"), processor, FieldWithMetaBasketConstituent.FieldWithMetaBasketConstituentBuilder.class, this.getBasketConstituent(), new AttributeMeta[0]);
        }

        @Override
        public BasketBuilder prune();
    }

    public static class BasketImpl
    extends AssetBase.AssetBaseImpl
    implements Basket {
        private final List<? extends FieldWithMetaBasketConstituent> basketConstituent;

        protected BasketImpl(BasketBuilder builder) {
            super(builder);
            this.basketConstituent = Optional.ofNullable(builder.getBasketConstituent()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="basketConstituent")
        @RuneAttribute(value="basketConstituent")
        @RuneScopedAttributeKey
        public List<? extends FieldWithMetaBasketConstituent> getBasketConstituent() {
            return this.basketConstituent;
        }

        @Override
        public Basket build() {
            return this;
        }

        @Override
        public BasketBuilder toBuilder() {
            BasketBuilder builder = Basket.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(BasketBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getBasketConstituent()).ifPresent(builder::setBasketConstituent);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Basket _that = (Basket)this.getType().cast(o);
            return ListEquals.listEquals(this.basketConstituent, _that.getBasketConstituent());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.basketConstituent != null ? this.basketConstituent.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "Basket {basketConstituent=" + this.basketConstituent + '}' + " " + super.toString();
        }
    }
}

