/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset;

import cdm.base.datetime.Period;
import cdm.base.staticdata.asset.common.AssetClassEnum;
import cdm.base.staticdata.asset.common.AssetIdentifier;
import cdm.base.staticdata.asset.common.Taxonomy;
import cdm.base.staticdata.asset.rates.FloatingRateIndexEnum;
import cdm.base.staticdata.asset.rates.metafields.FieldWithMetaFloatingRateIndexEnum;
import cdm.base.staticdata.party.LegalEntity;
import cdm.observable.asset.IndexBase;
import cdm.observable.asset.meta.FloatingRateIndexMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.FieldWithMetaString;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="FloatingRateIndex", builder=FloatingRateIndexBuilderImpl.class, version="6.7.0")
@RuneDataType(value="FloatingRateIndex", model="cdm", builder=FloatingRateIndexBuilderImpl.class, version="6.7.0")
public interface FloatingRateIndex
extends IndexBase {
    public static final FloatingRateIndexMeta metaData = new FloatingRateIndexMeta();

    public FieldWithMetaFloatingRateIndexEnum getFloatingRateIndex();

    public Period getIndexTenor();

    @Override
    public FloatingRateIndex build();

    @Override
    public FloatingRateIndexBuilder toBuilder();

    public static FloatingRateIndexBuilder builder() {
        return new FloatingRateIndexBuilderImpl();
    }

    default public RosettaMetaData<? extends FloatingRateIndex> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FloatingRateIndex> getType() {
        return FloatingRateIndex.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("identifier"), processor, AssetIdentifier.class, this.getIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("taxonomy"), processor, Taxonomy.class, this.getTaxonomy(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("isExchangeListed"), Boolean.class, (Object)this.getIsExchangeListed(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchange"), processor, LegalEntity.class, this.getExchange(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("relatedExchange"), processor, LegalEntity.class, this.getRelatedExchange(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("name"), processor, FieldWithMetaString.class, this.getName(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("provider"), processor, LegalEntity.class, this.getProvider(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("assetClass"), AssetClassEnum.class, (Object)this.getAssetClass(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("floatingRateIndex"), processor, FieldWithMetaFloatingRateIndexEnum.class, this.getFloatingRateIndex(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("indexTenor"), processor, Period.class, this.getIndexTenor(), new AttributeMeta[0]);
    }

    public static class FloatingRateIndexBuilderImpl
    extends IndexBase.IndexBaseBuilderImpl
    implements FloatingRateIndexBuilder {
        protected FieldWithMetaFloatingRateIndexEnum.FieldWithMetaFloatingRateIndexEnumBuilder floatingRateIndex;
        protected Period.PeriodBuilder indexTenor;

        @Override
        @RosettaAttribute(value="floatingRateIndex")
        @RuneAttribute(value="floatingRateIndex")
        public FieldWithMetaFloatingRateIndexEnum.FieldWithMetaFloatingRateIndexEnumBuilder getFloatingRateIndex() {
            return this.floatingRateIndex;
        }

        @Override
        public FieldWithMetaFloatingRateIndexEnum.FieldWithMetaFloatingRateIndexEnumBuilder getOrCreateFloatingRateIndex() {
            FieldWithMetaFloatingRateIndexEnum.FieldWithMetaFloatingRateIndexEnumBuilder result = this.floatingRateIndex != null ? this.floatingRateIndex : (this.floatingRateIndex = FieldWithMetaFloatingRateIndexEnum.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="indexTenor")
        @RuneAttribute(value="indexTenor")
        public Period.PeriodBuilder getIndexTenor() {
            return this.indexTenor;
        }

        @Override
        public Period.PeriodBuilder getOrCreateIndexTenor() {
            Period.PeriodBuilder result = this.indexTenor != null ? this.indexTenor : (this.indexTenor = Period.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="identifier")
        @RuneAttribute(value="identifier")
        public FloatingRateIndexBuilder addIdentifier(AssetIdentifier _identifier) {
            if (_identifier != null) {
                this.identifier.add(_identifier.toBuilder());
            }
            return this;
        }

        @Override
        public FloatingRateIndexBuilder addIdentifier(AssetIdentifier _identifier, int _idx) {
            this.getIndex(this.identifier, _idx, () -> _identifier.toBuilder());
            return this;
        }

        @Override
        public FloatingRateIndexBuilder addIdentifier(List<? extends AssetIdentifier> identifiers) {
            if (identifiers != null) {
                for (AssetIdentifier assetIdentifier : identifiers) {
                    this.identifier.add(assetIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="identifier")
        public FloatingRateIndexBuilder setIdentifier(List<? extends AssetIdentifier> identifiers) {
            this.identifier = identifiers == null ? new ArrayList() : (List)identifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="taxonomy")
        @RuneAttribute(value="taxonomy")
        public FloatingRateIndexBuilder addTaxonomy(Taxonomy _taxonomy) {
            if (_taxonomy != null) {
                this.taxonomy.add(_taxonomy.toBuilder());
            }
            return this;
        }

        @Override
        public FloatingRateIndexBuilder addTaxonomy(Taxonomy _taxonomy, int _idx) {
            this.getIndex(this.taxonomy, _idx, () -> _taxonomy.toBuilder());
            return this;
        }

        @Override
        public FloatingRateIndexBuilder addTaxonomy(List<? extends Taxonomy> taxonomys) {
            if (taxonomys != null) {
                for (Taxonomy taxonomy : taxonomys) {
                    this.taxonomy.add(taxonomy.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="taxonomy")
        public FloatingRateIndexBuilder setTaxonomy(List<? extends Taxonomy> taxonomys) {
            this.taxonomy = taxonomys == null ? new ArrayList() : (List)taxonomys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="isExchangeListed")
        @RuneAttribute(value="isExchangeListed")
        public FloatingRateIndexBuilder setIsExchangeListed(Boolean _isExchangeListed) {
            this.isExchangeListed = _isExchangeListed == null ? null : _isExchangeListed;
            return this;
        }

        @Override
        @RosettaAttribute(value="exchange")
        @RuneAttribute(value="exchange")
        public FloatingRateIndexBuilder setExchange(LegalEntity _exchange) {
            this.exchange = _exchange == null ? null : _exchange.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="relatedExchange")
        @RuneAttribute(value="relatedExchange")
        public FloatingRateIndexBuilder addRelatedExchange(LegalEntity _relatedExchange) {
            if (_relatedExchange != null) {
                this.relatedExchange.add(_relatedExchange.toBuilder());
            }
            return this;
        }

        @Override
        public FloatingRateIndexBuilder addRelatedExchange(LegalEntity _relatedExchange, int _idx) {
            this.getIndex(this.relatedExchange, _idx, () -> _relatedExchange.toBuilder());
            return this;
        }

        @Override
        public FloatingRateIndexBuilder addRelatedExchange(List<? extends LegalEntity> relatedExchanges) {
            if (relatedExchanges != null) {
                for (LegalEntity legalEntity : relatedExchanges) {
                    this.relatedExchange.add(legalEntity.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="relatedExchange")
        public FloatingRateIndexBuilder setRelatedExchange(List<? extends LegalEntity> relatedExchanges) {
            this.relatedExchange = relatedExchanges == null ? new ArrayList() : (List)relatedExchanges.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public FloatingRateIndexBuilder setName(FieldWithMetaString _name) {
            this.name = _name == null ? null : _name.toBuilder();
            return this;
        }

        @Override
        public FloatingRateIndexBuilder setNameValue(String _name) {
            this.getOrCreateName().setValue(_name);
            return this;
        }

        @Override
        @RosettaAttribute(value="provider")
        @RuneAttribute(value="provider")
        public FloatingRateIndexBuilder setProvider(LegalEntity _provider) {
            this.provider = _provider == null ? null : _provider.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="assetClass")
        @RuneAttribute(value="assetClass")
        public FloatingRateIndexBuilder setAssetClass(AssetClassEnum _assetClass) {
            this.assetClass = _assetClass == null ? null : _assetClass;
            return this;
        }

        @Override
        @RosettaAttribute(value="floatingRateIndex")
        @RuneAttribute(value="floatingRateIndex")
        public FloatingRateIndexBuilder setFloatingRateIndex(FieldWithMetaFloatingRateIndexEnum _floatingRateIndex) {
            this.floatingRateIndex = _floatingRateIndex == null ? null : _floatingRateIndex.toBuilder();
            return this;
        }

        @Override
        public FloatingRateIndexBuilder setFloatingRateIndexValue(FloatingRateIndexEnum _floatingRateIndex) {
            this.getOrCreateFloatingRateIndex().setValue(_floatingRateIndex);
            return this;
        }

        @Override
        @RosettaAttribute(value="indexTenor")
        @RuneAttribute(value="indexTenor")
        public FloatingRateIndexBuilder setIndexTenor(Period _indexTenor) {
            this.indexTenor = _indexTenor == null ? null : _indexTenor.toBuilder();
            return this;
        }

        @Override
        public FloatingRateIndex build() {
            return new FloatingRateIndexImpl(this);
        }

        @Override
        public FloatingRateIndexBuilder toBuilder() {
            return this;
        }

        @Override
        public FloatingRateIndexBuilder prune() {
            super.prune();
            if (this.floatingRateIndex != null && !this.floatingRateIndex.prune().hasData()) {
                this.floatingRateIndex = null;
            }
            if (this.indexTenor != null && !this.indexTenor.prune().hasData()) {
                this.indexTenor = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getFloatingRateIndex() != null) {
                return true;
            }
            return this.getIndexTenor() != null && this.getIndexTenor().hasData();
        }

        @Override
        public FloatingRateIndexBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            FloatingRateIndexBuilder o = (FloatingRateIndexBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFloatingRateIndex(), (RosettaModelObjectBuilder)o.getFloatingRateIndex(), this::setFloatingRateIndex);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getIndexTenor(), (RosettaModelObjectBuilder)o.getIndexTenor(), this::setIndexTenor);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FloatingRateIndex _that = (FloatingRateIndex)this.getType().cast(o);
            if (!Objects.equals(this.floatingRateIndex, _that.getFloatingRateIndex())) {
                return false;
            }
            return Objects.equals(this.indexTenor, _that.getIndexTenor());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.floatingRateIndex != null ? this.floatingRateIndex.hashCode() : 0);
            _result = 31 * _result + (this.indexTenor != null ? this.indexTenor.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FloatingRateIndexBuilder {floatingRateIndex=" + this.floatingRateIndex + ", indexTenor=" + this.indexTenor + '}' + " " + super.toString();
        }
    }

    public static interface FloatingRateIndexBuilder
    extends FloatingRateIndex,
    IndexBase.IndexBaseBuilder {
        public FieldWithMetaFloatingRateIndexEnum.FieldWithMetaFloatingRateIndexEnumBuilder getOrCreateFloatingRateIndex();

        @Override
        public FieldWithMetaFloatingRateIndexEnum.FieldWithMetaFloatingRateIndexEnumBuilder getFloatingRateIndex();

        public Period.PeriodBuilder getOrCreateIndexTenor();

        @Override
        public Period.PeriodBuilder getIndexTenor();

        @Override
        public FloatingRateIndexBuilder addIdentifier(AssetIdentifier var1);

        @Override
        public FloatingRateIndexBuilder addIdentifier(AssetIdentifier var1, int var2);

        @Override
        public FloatingRateIndexBuilder addIdentifier(List<? extends AssetIdentifier> var1);

        @Override
        public FloatingRateIndexBuilder setIdentifier(List<? extends AssetIdentifier> var1);

        @Override
        public FloatingRateIndexBuilder addTaxonomy(Taxonomy var1);

        @Override
        public FloatingRateIndexBuilder addTaxonomy(Taxonomy var1, int var2);

        @Override
        public FloatingRateIndexBuilder addTaxonomy(List<? extends Taxonomy> var1);

        @Override
        public FloatingRateIndexBuilder setTaxonomy(List<? extends Taxonomy> var1);

        @Override
        public FloatingRateIndexBuilder setIsExchangeListed(Boolean var1);

        @Override
        public FloatingRateIndexBuilder setExchange(LegalEntity var1);

        @Override
        public FloatingRateIndexBuilder addRelatedExchange(LegalEntity var1);

        @Override
        public FloatingRateIndexBuilder addRelatedExchange(LegalEntity var1, int var2);

        @Override
        public FloatingRateIndexBuilder addRelatedExchange(List<? extends LegalEntity> var1);

        @Override
        public FloatingRateIndexBuilder setRelatedExchange(List<? extends LegalEntity> var1);

        @Override
        public FloatingRateIndexBuilder setName(FieldWithMetaString var1);

        @Override
        public FloatingRateIndexBuilder setNameValue(String var1);

        @Override
        public FloatingRateIndexBuilder setProvider(LegalEntity var1);

        @Override
        public FloatingRateIndexBuilder setAssetClass(AssetClassEnum var1);

        public FloatingRateIndexBuilder setFloatingRateIndex(FieldWithMetaFloatingRateIndexEnum var1);

        public FloatingRateIndexBuilder setFloatingRateIndexValue(FloatingRateIndexEnum var1);

        public FloatingRateIndexBuilder setIndexTenor(Period var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("identifier"), processor, AssetIdentifier.AssetIdentifierBuilder.class, this.getIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("taxonomy"), processor, Taxonomy.TaxonomyBuilder.class, this.getTaxonomy(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("isExchangeListed"), Boolean.class, (Object)this.getIsExchangeListed(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchange"), processor, LegalEntity.LegalEntityBuilder.class, (RosettaModelObjectBuilder)this.getExchange(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("relatedExchange"), processor, LegalEntity.LegalEntityBuilder.class, this.getRelatedExchange(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("name"), processor, FieldWithMetaString.FieldWithMetaStringBuilder.class, (RosettaModelObjectBuilder)this.getName(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("provider"), processor, LegalEntity.LegalEntityBuilder.class, (RosettaModelObjectBuilder)this.getProvider(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("assetClass"), AssetClassEnum.class, (Object)this.getAssetClass(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("floatingRateIndex"), processor, FieldWithMetaFloatingRateIndexEnum.FieldWithMetaFloatingRateIndexEnumBuilder.class, this.getFloatingRateIndex(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("indexTenor"), processor, Period.PeriodBuilder.class, this.getIndexTenor(), new AttributeMeta[0]);
        }

        @Override
        public FloatingRateIndexBuilder prune();
    }

    public static class FloatingRateIndexImpl
    extends IndexBase.IndexBaseImpl
    implements FloatingRateIndex {
        private final FieldWithMetaFloatingRateIndexEnum floatingRateIndex;
        private final Period indexTenor;

        protected FloatingRateIndexImpl(FloatingRateIndexBuilder builder) {
            super(builder);
            this.floatingRateIndex = Optional.ofNullable(builder.getFloatingRateIndex()).map(f -> f.build()).orElse(null);
            this.indexTenor = Optional.ofNullable(builder.getIndexTenor()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="floatingRateIndex")
        @RuneAttribute(value="floatingRateIndex")
        public FieldWithMetaFloatingRateIndexEnum getFloatingRateIndex() {
            return this.floatingRateIndex;
        }

        @Override
        @RosettaAttribute(value="indexTenor")
        @RuneAttribute(value="indexTenor")
        public Period getIndexTenor() {
            return this.indexTenor;
        }

        @Override
        public FloatingRateIndex build() {
            return this;
        }

        @Override
        public FloatingRateIndexBuilder toBuilder() {
            FloatingRateIndexBuilder builder = FloatingRateIndex.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FloatingRateIndexBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getFloatingRateIndex()).ifPresent(builder::setFloatingRateIndex);
            Optional.ofNullable(this.getIndexTenor()).ifPresent(builder::setIndexTenor);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FloatingRateIndex _that = (FloatingRateIndex)this.getType().cast(o);
            if (!Objects.equals(this.floatingRateIndex, _that.getFloatingRateIndex())) {
                return false;
            }
            return Objects.equals(this.indexTenor, _that.getIndexTenor());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.floatingRateIndex != null ? this.floatingRateIndex.hashCode() : 0);
            _result = 31 * _result + (this.indexTenor != null ? this.indexTenor.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FloatingRateIndex {floatingRateIndex=" + this.floatingRateIndex + ", indexTenor=" + this.indexTenor + '}' + " " + super.toString();
        }
    }
}

