/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.floatingrate;

import cdm.product.asset.floatingrate.FloatingRateProcessingParameters;
import cdm.product.asset.floatingrate.meta.FloatingRateProcessingDetailsMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="FloatingRateProcessingDetails", builder=FloatingRateProcessingDetailsBuilderImpl.class, version="6.7.0")
@RuneDataType(value="FloatingRateProcessingDetails", model="cdm", builder=FloatingRateProcessingDetailsBuilderImpl.class, version="6.7.0")
public interface FloatingRateProcessingDetails
extends RosettaModelObject {
    public static final FloatingRateProcessingDetailsMeta metaData = new FloatingRateProcessingDetailsMeta();

    public BigDecimal getRawRate();

    public FloatingRateProcessingParameters getProcessingParameters();

    public BigDecimal getProcessedRate();

    public BigDecimal getSpreadExclusiveRate();

    public FloatingRateProcessingDetails build();

    public FloatingRateProcessingDetailsBuilder toBuilder();

    public static FloatingRateProcessingDetailsBuilder builder() {
        return new FloatingRateProcessingDetailsBuilderImpl();
    }

    default public RosettaMetaData<? extends FloatingRateProcessingDetails> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FloatingRateProcessingDetails> getType() {
        return FloatingRateProcessingDetails.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("rawRate"), BigDecimal.class, (Object)this.getRawRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("processingParameters"), processor, FloatingRateProcessingParameters.class, this.getProcessingParameters(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("processedRate"), BigDecimal.class, (Object)this.getProcessedRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("spreadExclusiveRate"), BigDecimal.class, (Object)this.getSpreadExclusiveRate(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class FloatingRateProcessingDetailsBuilderImpl
    implements FloatingRateProcessingDetailsBuilder {
        protected BigDecimal rawRate;
        protected FloatingRateProcessingParameters.FloatingRateProcessingParametersBuilder processingParameters;
        protected BigDecimal processedRate;
        protected BigDecimal spreadExclusiveRate;

        @Override
        @RosettaAttribute(value="rawRate")
        @RuneAttribute(value="rawRate")
        public BigDecimal getRawRate() {
            return this.rawRate;
        }

        @Override
        @RosettaAttribute(value="processingParameters")
        @RuneAttribute(value="processingParameters")
        public FloatingRateProcessingParameters.FloatingRateProcessingParametersBuilder getProcessingParameters() {
            return this.processingParameters;
        }

        @Override
        public FloatingRateProcessingParameters.FloatingRateProcessingParametersBuilder getOrCreateProcessingParameters() {
            FloatingRateProcessingParameters.FloatingRateProcessingParametersBuilder result = this.processingParameters != null ? this.processingParameters : (this.processingParameters = FloatingRateProcessingParameters.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="processedRate")
        @RuneAttribute(value="processedRate")
        public BigDecimal getProcessedRate() {
            return this.processedRate;
        }

        @Override
        @RosettaAttribute(value="spreadExclusiveRate")
        @RuneAttribute(value="spreadExclusiveRate")
        public BigDecimal getSpreadExclusiveRate() {
            return this.spreadExclusiveRate;
        }

        @Override
        @RosettaAttribute(value="rawRate")
        @RuneAttribute(value="rawRate")
        public FloatingRateProcessingDetailsBuilder setRawRate(BigDecimal _rawRate) {
            this.rawRate = _rawRate == null ? null : _rawRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="processingParameters")
        @RuneAttribute(value="processingParameters")
        public FloatingRateProcessingDetailsBuilder setProcessingParameters(FloatingRateProcessingParameters _processingParameters) {
            this.processingParameters = _processingParameters == null ? null : _processingParameters.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="processedRate")
        @RuneAttribute(value="processedRate")
        public FloatingRateProcessingDetailsBuilder setProcessedRate(BigDecimal _processedRate) {
            this.processedRate = _processedRate == null ? null : _processedRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="spreadExclusiveRate")
        @RuneAttribute(value="spreadExclusiveRate")
        public FloatingRateProcessingDetailsBuilder setSpreadExclusiveRate(BigDecimal _spreadExclusiveRate) {
            this.spreadExclusiveRate = _spreadExclusiveRate == null ? null : _spreadExclusiveRate;
            return this;
        }

        @Override
        public FloatingRateProcessingDetails build() {
            return new FloatingRateProcessingDetailsImpl(this);
        }

        @Override
        public FloatingRateProcessingDetailsBuilder toBuilder() {
            return this;
        }

        @Override
        public FloatingRateProcessingDetailsBuilder prune() {
            if (this.processingParameters != null && !this.processingParameters.prune().hasData()) {
                this.processingParameters = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getRawRate() != null) {
                return true;
            }
            if (this.getProcessingParameters() != null && this.getProcessingParameters().hasData()) {
                return true;
            }
            if (this.getProcessedRate() != null) {
                return true;
            }
            return this.getSpreadExclusiveRate() != null;
        }

        public FloatingRateProcessingDetailsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            FloatingRateProcessingDetailsBuilder o = (FloatingRateProcessingDetailsBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getProcessingParameters(), (RosettaModelObjectBuilder)o.getProcessingParameters(), this::setProcessingParameters);
            merger.mergeBasic((Object)this.getRawRate(), (Object)o.getRawRate(), this::setRawRate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getProcessedRate(), (Object)o.getProcessedRate(), this::setProcessedRate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSpreadExclusiveRate(), (Object)o.getSpreadExclusiveRate(), this::setSpreadExclusiveRate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FloatingRateProcessingDetails _that = this.getType().cast(o);
            if (!Objects.equals(this.rawRate, _that.getRawRate())) {
                return false;
            }
            if (!Objects.equals(this.processingParameters, _that.getProcessingParameters())) {
                return false;
            }
            if (!Objects.equals(this.processedRate, _that.getProcessedRate())) {
                return false;
            }
            return Objects.equals(this.spreadExclusiveRate, _that.getSpreadExclusiveRate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.rawRate != null ? this.rawRate.hashCode() : 0);
            _result = 31 * _result + (this.processingParameters != null ? this.processingParameters.hashCode() : 0);
            _result = 31 * _result + (this.processedRate != null ? this.processedRate.hashCode() : 0);
            _result = 31 * _result + (this.spreadExclusiveRate != null ? this.spreadExclusiveRate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FloatingRateProcessingDetailsBuilder {rawRate=" + this.rawRate + ", processingParameters=" + this.processingParameters + ", processedRate=" + this.processedRate + ", spreadExclusiveRate=" + this.spreadExclusiveRate + '}';
        }
    }

    public static interface FloatingRateProcessingDetailsBuilder
    extends FloatingRateProcessingDetails,
    RosettaModelObjectBuilder {
        public FloatingRateProcessingParameters.FloatingRateProcessingParametersBuilder getOrCreateProcessingParameters();

        @Override
        public FloatingRateProcessingParameters.FloatingRateProcessingParametersBuilder getProcessingParameters();

        public FloatingRateProcessingDetailsBuilder setRawRate(BigDecimal var1);

        public FloatingRateProcessingDetailsBuilder setProcessingParameters(FloatingRateProcessingParameters var1);

        public FloatingRateProcessingDetailsBuilder setProcessedRate(BigDecimal var1);

        public FloatingRateProcessingDetailsBuilder setSpreadExclusiveRate(BigDecimal var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("rawRate"), BigDecimal.class, (Object)this.getRawRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("processingParameters"), processor, FloatingRateProcessingParameters.FloatingRateProcessingParametersBuilder.class, this.getProcessingParameters(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("processedRate"), BigDecimal.class, (Object)this.getProcessedRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("spreadExclusiveRate"), BigDecimal.class, (Object)this.getSpreadExclusiveRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public FloatingRateProcessingDetailsBuilder prune();
    }

    public static class FloatingRateProcessingDetailsImpl
    implements FloatingRateProcessingDetails {
        private final BigDecimal rawRate;
        private final FloatingRateProcessingParameters processingParameters;
        private final BigDecimal processedRate;
        private final BigDecimal spreadExclusiveRate;

        protected FloatingRateProcessingDetailsImpl(FloatingRateProcessingDetailsBuilder builder) {
            this.rawRate = builder.getRawRate();
            this.processingParameters = Optional.ofNullable(builder.getProcessingParameters()).map(f -> f.build()).orElse(null);
            this.processedRate = builder.getProcessedRate();
            this.spreadExclusiveRate = builder.getSpreadExclusiveRate();
        }

        @Override
        @RosettaAttribute(value="rawRate")
        @RuneAttribute(value="rawRate")
        public BigDecimal getRawRate() {
            return this.rawRate;
        }

        @Override
        @RosettaAttribute(value="processingParameters")
        @RuneAttribute(value="processingParameters")
        public FloatingRateProcessingParameters getProcessingParameters() {
            return this.processingParameters;
        }

        @Override
        @RosettaAttribute(value="processedRate")
        @RuneAttribute(value="processedRate")
        public BigDecimal getProcessedRate() {
            return this.processedRate;
        }

        @Override
        @RosettaAttribute(value="spreadExclusiveRate")
        @RuneAttribute(value="spreadExclusiveRate")
        public BigDecimal getSpreadExclusiveRate() {
            return this.spreadExclusiveRate;
        }

        @Override
        public FloatingRateProcessingDetails build() {
            return this;
        }

        @Override
        public FloatingRateProcessingDetailsBuilder toBuilder() {
            FloatingRateProcessingDetailsBuilder builder = FloatingRateProcessingDetails.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FloatingRateProcessingDetailsBuilder builder) {
            Optional.ofNullable(this.getRawRate()).ifPresent(builder::setRawRate);
            Optional.ofNullable(this.getProcessingParameters()).ifPresent(builder::setProcessingParameters);
            Optional.ofNullable(this.getProcessedRate()).ifPresent(builder::setProcessedRate);
            Optional.ofNullable(this.getSpreadExclusiveRate()).ifPresent(builder::setSpreadExclusiveRate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FloatingRateProcessingDetails _that = this.getType().cast(o);
            if (!Objects.equals(this.rawRate, _that.getRawRate())) {
                return false;
            }
            if (!Objects.equals(this.processingParameters, _that.getProcessingParameters())) {
                return false;
            }
            if (!Objects.equals(this.processedRate, _that.getProcessedRate())) {
                return false;
            }
            return Objects.equals(this.spreadExclusiveRate, _that.getSpreadExclusiveRate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.rawRate != null ? this.rawRate.hashCode() : 0);
            _result = 31 * _result + (this.processingParameters != null ? this.processingParameters.hashCode() : 0);
            _result = 31 * _result + (this.processedRate != null ? this.processedRate.hashCode() : 0);
            _result = 31 * _result + (this.spreadExclusiveRate != null ? this.spreadExclusiveRate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FloatingRateProcessingDetails {rawRate=" + this.rawRate + ", processingParameters=" + this.processingParameters + ", processedRate=" + this.processedRate + ", spreadExclusiveRate=" + this.spreadExclusiveRate + '}';
        }
    }
}

