/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.collateral.functions;

import cdm.base.staticdata.asset.common.AssetType;
import cdm.base.staticdata.asset.common.CollateralIssuerType;
import cdm.base.staticdata.asset.common.CurrencyCodeEnum;
import cdm.base.staticdata.asset.common.ISOCountryCodeEnum;
import cdm.product.collateral.AgencyRatingCriteria;
import cdm.product.collateral.AssetMaturity;
import cdm.product.collateral.CollateralCriteria;
import cdm.product.collateral.EligibilityQuery;
import cdm.product.collateral.IssuerName;
import cdm.product.collateral.functions.CheckAgencyRating;
import cdm.product.collateral.functions.CheckAssetType;
import cdm.product.collateral.functions.CheckCountryOfOrigin;
import cdm.product.collateral.functions.CheckDenominatedCurrency;
import cdm.product.collateral.functions.CheckIssuerName;
import cdm.product.collateral.functions.CheckIssuerType;
import cdm.product.collateral.functions.CheckMaturity;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import javax.inject.Inject;

@ImplementedBy(value=CheckCriteriaDefault.class)
public abstract class CheckCriteria
implements RosettaFunction {
    @Inject
    protected CheckAgencyRating checkAgencyRating;
    @Inject
    protected CheckAssetType checkAssetType;
    @Inject
    protected CheckCountryOfOrigin checkCountryOfOrigin;
    @Inject
    protected CheckCriteria checkCriteria;
    @Inject
    protected CheckDenominatedCurrency checkDenominatedCurrency;
    @Inject
    protected CheckIssuerName checkIssuerName;
    @Inject
    protected CheckIssuerType checkIssuerType;
    @Inject
    protected CheckMaturity checkMaturity;

    public Boolean evaluate(CollateralCriteria inputCriteria, EligibilityQuery query) {
        Boolean isEligible = this.doEvaluate(inputCriteria, query);
        return isEligible;
    }

    protected abstract Boolean doEvaluate(CollateralCriteria var1, EligibilityQuery var2);

    public static class CheckCriteriaDefault
    extends CheckCriteria {
        @Override
        protected Boolean doEvaluate(CollateralCriteria inputCriteria, EligibilityQuery query) {
            Boolean isEligible = null;
            return this.assignOutput(isEligible, inputCriteria, query);
        }

        protected Boolean assignOutput(Boolean isEligible, CollateralCriteria inputCriteria, EligibilityQuery query) {
            isEligible = false;
            MapperS switchArgument = MapperS.of((Object)inputCriteria);
            if (switchArgument.get() == null) {
                isEligible = null;
            } else if (switchArgument.map("getAllCriteria", collateralCriteria -> collateralCriteria.getAllCriteria()).get() != null) {
                MapperS allCriteria = switchArgument.map("getAllCriteria", collateralCriteria -> collateralCriteria.getAllCriteria());
                MapperC thenArg1 = allCriteria.mapC("getAllCriteria", _allCriteria -> _allCriteria.getAllCriteria()).mapItem(item -> MapperS.of((Object)this.checkCriteria.evaluate((CollateralCriteria)item.get(), query)));
                isEligible = (Boolean)ExpressionOperators.areEqual((Mapper)thenArg1, (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).asMapper().get();
            } else if (switchArgument.map("getAnyCriteria", collateralCriteria -> collateralCriteria.getAnyCriteria()).get() != null) {
                MapperS anyCriteria = switchArgument.map("getAnyCriteria", collateralCriteria -> collateralCriteria.getAnyCriteria());
                MapperC thenArg0 = anyCriteria.mapC("getAnyCriteria", _anyCriteria -> _anyCriteria.getAnyCriteria()).mapItem(item -> MapperS.of((Object)this.checkCriteria.evaluate((CollateralCriteria)item.get(), query)));
                isEligible = (Boolean)ExpressionOperators.areEqual((Mapper)thenArg0, (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.Any).asMapper().get();
            } else if (switchArgument.map("getNegativeCriteria", collateralCriteria -> collateralCriteria.getNegativeCriteria()).get() != null) {
                MapperS negativeCriteria = switchArgument.map("getNegativeCriteria", collateralCriteria -> collateralCriteria.getNegativeCriteria());
                isEligible = ExpressionOperators.areEqual((Mapper)MapperS.of((Object)this.checkCriteria.evaluate((CollateralCriteria)negativeCriteria.map("getNegativeCriteria", _negativeCriteria -> _negativeCriteria.getNegativeCriteria()).get(), query)), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All).get();
            } else if (switchArgument.map("getCollateralIssuerType", collateralCriteria -> collateralCriteria.getCollateralIssuerType()).get() != null) {
                MapperS collateralIssuerType = switchArgument.map("getCollateralIssuerType", collateralCriteria -> collateralCriteria.getCollateralIssuerType());
                isEligible = this.checkIssuerType.evaluate((CollateralIssuerType)collateralIssuerType.get(), query);
            } else if (switchArgument.map("getAssetType", collateralCriteria -> collateralCriteria.getAssetType()).get() != null) {
                MapperS assetType = switchArgument.map("getAssetType", collateralCriteria -> collateralCriteria.getAssetType());
                isEligible = this.checkAssetType.evaluate((AssetType)assetType.get(), query);
            } else if (switchArgument.map("getIssuerCountryOfOrigin", collateralCriteria -> collateralCriteria.getIssuerCountryOfOrigin()).get() != null) {
                MapperS issuerCountryOfOrigin = switchArgument.map("getIssuerCountryOfOrigin", collateralCriteria -> collateralCriteria.getIssuerCountryOfOrigin());
                isEligible = this.checkCountryOfOrigin.evaluate((ISOCountryCodeEnum)((Object)issuerCountryOfOrigin.map("getIssuerCountryOfOrigin", _issuerCountryOfOrigin -> _issuerCountryOfOrigin.getIssuerCountryOfOrigin()).get()), query);
            } else if (switchArgument.map("getAssetCountryOfOrigin", collateralCriteria -> collateralCriteria.getAssetCountryOfOrigin()).get() != null) {
                MapperS assetCountryOfOrigin = switchArgument.map("getAssetCountryOfOrigin", collateralCriteria -> collateralCriteria.getAssetCountryOfOrigin());
                isEligible = this.checkCountryOfOrigin.evaluate((ISOCountryCodeEnum)((Object)assetCountryOfOrigin.map("getAssetCountryOfOrigin", _assetCountryOfOrigin -> _assetCountryOfOrigin.getAssetCountryOfOrigin()).get()), query);
            } else if (switchArgument.map("getCurrencyCodeEnum", collateralCriteria -> collateralCriteria.getCurrencyCodeEnum()).get() != null) {
                MapperS currencyCodeEnum = switchArgument.map("getCurrencyCodeEnum", collateralCriteria -> collateralCriteria.getCurrencyCodeEnum());
                isEligible = this.checkDenominatedCurrency.evaluate((CurrencyCodeEnum)((Object)currencyCodeEnum.get()), query);
            } else if (switchArgument.map("getIssuerName", collateralCriteria -> collateralCriteria.getIssuerName()).get() != null) {
                MapperS issuerName = switchArgument.map("getIssuerName", collateralCriteria -> collateralCriteria.getIssuerName());
                isEligible = this.checkIssuerName.evaluate((IssuerName)issuerName.get(), query);
            } else if (switchArgument.map("getIssuerAgencyRating", collateralCriteria -> collateralCriteria.getIssuerAgencyRating()).get() != null) {
                MapperS issuerAgencyRating = switchArgument.map("getIssuerAgencyRating", collateralCriteria -> collateralCriteria.getIssuerAgencyRating());
                isEligible = this.checkAgencyRating.evaluate((AgencyRatingCriteria)issuerAgencyRating.map("getIssuerAgencyRating", _issuerAgencyRating -> _issuerAgencyRating.getIssuerAgencyRating()).get(), query);
            } else if (switchArgument.map("getSovereignAgencyRating", collateralCriteria -> collateralCriteria.getSovereignAgencyRating()).get() != null) {
                MapperS sovereignAgencyRating = switchArgument.map("getSovereignAgencyRating", collateralCriteria -> collateralCriteria.getSovereignAgencyRating());
                isEligible = this.checkAgencyRating.evaluate((AgencyRatingCriteria)sovereignAgencyRating.map("getSovereignAgencyRating", _sovereignAgencyRating -> _sovereignAgencyRating.getSovereignAgencyRating()).get(), query);
            } else if (switchArgument.map("getAssetAgencyRating", collateralCriteria -> collateralCriteria.getAssetAgencyRating()).get() != null) {
                MapperS assetAgencyRating = switchArgument.map("getAssetAgencyRating", collateralCriteria -> collateralCriteria.getAssetAgencyRating());
                isEligible = this.checkAgencyRating.evaluate((AgencyRatingCriteria)assetAgencyRating.map("getAssetAgencyRating", _assetAgencyRating -> _assetAgencyRating.getAssetAgencyRating()).get(), query);
            } else if (switchArgument.map("getAssetMaturity", collateralCriteria -> collateralCriteria.getAssetMaturity()).get() != null) {
                MapperS assetMaturity = switchArgument.map("getAssetMaturity", collateralCriteria -> collateralCriteria.getAssetMaturity());
                isEligible = this.checkMaturity.evaluate((AssetMaturity)assetMaturity.get(), query);
            } else {
                isEligible = false;
            }
            return isEligible;
        }
    }
}

