/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.schedule;

import cdm.base.datetime.BusinessCenterTime;
import cdm.base.math.Rounding;
import cdm.observable.asset.FxSpotRateSource;
import cdm.observable.common.TimeTypeEnum;
import cdm.product.common.schedule.CalculationPeriodDates;
import cdm.product.common.schedule.ObservationDates;
import cdm.product.common.schedule.meta.ObservationTermsMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="ObservationTerms", builder=ObservationTermsBuilderImpl.class, version="6.7.0")
@RuneDataType(value="ObservationTerms", model="cdm", builder=ObservationTermsBuilderImpl.class, version="6.7.0")
public interface ObservationTerms
extends RosettaModelObject {
    public static final ObservationTermsMeta metaData = new ObservationTermsMeta();

    public BusinessCenterTime getObservationTime();

    public TimeTypeEnum getObservationTimeType();

    public FxSpotRateSource getInformationSource();

    public Rounding getPrecision();

    public CalculationPeriodDates getCalculationPeriodDates();

    public ObservationDates getObservationDates();

    public Integer getNumberOfObservationDates();

    public ObservationTerms build();

    public ObservationTermsBuilder toBuilder();

    public static ObservationTermsBuilder builder() {
        return new ObservationTermsBuilderImpl();
    }

    default public RosettaMetaData<? extends ObservationTerms> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ObservationTerms> getType() {
        return ObservationTerms.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("observationTime"), processor, BusinessCenterTime.class, this.getObservationTime(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("observationTimeType"), TimeTypeEnum.class, (Object)this.getObservationTimeType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("informationSource"), processor, FxSpotRateSource.class, this.getInformationSource(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("precision"), processor, Rounding.class, this.getPrecision(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("calculationPeriodDates"), processor, CalculationPeriodDates.class, this.getCalculationPeriodDates(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("observationDates"), processor, ObservationDates.class, this.getObservationDates(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("numberOfObservationDates"), Integer.class, (Object)this.getNumberOfObservationDates(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class ObservationTermsBuilderImpl
    implements ObservationTermsBuilder {
        protected BusinessCenterTime.BusinessCenterTimeBuilder observationTime;
        protected TimeTypeEnum observationTimeType;
        protected FxSpotRateSource.FxSpotRateSourceBuilder informationSource;
        protected Rounding.RoundingBuilder precision;
        protected CalculationPeriodDates.CalculationPeriodDatesBuilder calculationPeriodDates;
        protected ObservationDates.ObservationDatesBuilder observationDates;
        protected Integer numberOfObservationDates;

        @Override
        @RosettaAttribute(value="observationTime")
        @RuneAttribute(value="observationTime")
        public BusinessCenterTime.BusinessCenterTimeBuilder getObservationTime() {
            return this.observationTime;
        }

        @Override
        public BusinessCenterTime.BusinessCenterTimeBuilder getOrCreateObservationTime() {
            BusinessCenterTime.BusinessCenterTimeBuilder result = this.observationTime != null ? this.observationTime : (this.observationTime = BusinessCenterTime.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="observationTimeType")
        @RuneAttribute(value="observationTimeType")
        public TimeTypeEnum getObservationTimeType() {
            return this.observationTimeType;
        }

        @Override
        @RosettaAttribute(value="informationSource")
        @RuneAttribute(value="informationSource")
        public FxSpotRateSource.FxSpotRateSourceBuilder getInformationSource() {
            return this.informationSource;
        }

        @Override
        public FxSpotRateSource.FxSpotRateSourceBuilder getOrCreateInformationSource() {
            FxSpotRateSource.FxSpotRateSourceBuilder result = this.informationSource != null ? this.informationSource : (this.informationSource = FxSpotRateSource.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="precision")
        @RuneAttribute(value="precision")
        public Rounding.RoundingBuilder getPrecision() {
            return this.precision;
        }

        @Override
        public Rounding.RoundingBuilder getOrCreatePrecision() {
            Rounding.RoundingBuilder result = this.precision != null ? this.precision : (this.precision = Rounding.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="calculationPeriodDates")
        @RuneAttribute(value="calculationPeriodDates")
        public CalculationPeriodDates.CalculationPeriodDatesBuilder getCalculationPeriodDates() {
            return this.calculationPeriodDates;
        }

        @Override
        public CalculationPeriodDates.CalculationPeriodDatesBuilder getOrCreateCalculationPeriodDates() {
            CalculationPeriodDates.CalculationPeriodDatesBuilder result = this.calculationPeriodDates != null ? this.calculationPeriodDates : (this.calculationPeriodDates = CalculationPeriodDates.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="observationDates")
        @RuneAttribute(value="observationDates")
        public ObservationDates.ObservationDatesBuilder getObservationDates() {
            return this.observationDates;
        }

        @Override
        public ObservationDates.ObservationDatesBuilder getOrCreateObservationDates() {
            ObservationDates.ObservationDatesBuilder result = this.observationDates != null ? this.observationDates : (this.observationDates = ObservationDates.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="numberOfObservationDates")
        @RuneAttribute(value="numberOfObservationDates")
        public Integer getNumberOfObservationDates() {
            return this.numberOfObservationDates;
        }

        @Override
        @RosettaAttribute(value="observationTime")
        @RuneAttribute(value="observationTime")
        public ObservationTermsBuilder setObservationTime(BusinessCenterTime _observationTime) {
            this.observationTime = _observationTime == null ? null : _observationTime.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="observationTimeType")
        @RuneAttribute(value="observationTimeType")
        public ObservationTermsBuilder setObservationTimeType(TimeTypeEnum _observationTimeType) {
            this.observationTimeType = _observationTimeType == null ? null : _observationTimeType;
            return this;
        }

        @Override
        @RosettaAttribute(value="informationSource")
        @RuneAttribute(value="informationSource")
        public ObservationTermsBuilder setInformationSource(FxSpotRateSource _informationSource) {
            this.informationSource = _informationSource == null ? null : _informationSource.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="precision")
        @RuneAttribute(value="precision")
        public ObservationTermsBuilder setPrecision(Rounding _precision) {
            this.precision = _precision == null ? null : _precision.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="calculationPeriodDates")
        @RuneAttribute(value="calculationPeriodDates")
        public ObservationTermsBuilder setCalculationPeriodDates(CalculationPeriodDates _calculationPeriodDates) {
            this.calculationPeriodDates = _calculationPeriodDates == null ? null : _calculationPeriodDates.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="observationDates")
        @RuneAttribute(value="observationDates")
        public ObservationTermsBuilder setObservationDates(ObservationDates _observationDates) {
            this.observationDates = _observationDates == null ? null : _observationDates.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="numberOfObservationDates")
        @RuneAttribute(value="numberOfObservationDates")
        public ObservationTermsBuilder setNumberOfObservationDates(Integer _numberOfObservationDates) {
            this.numberOfObservationDates = _numberOfObservationDates == null ? null : _numberOfObservationDates;
            return this;
        }

        @Override
        public ObservationTerms build() {
            return new ObservationTermsImpl(this);
        }

        @Override
        public ObservationTermsBuilder toBuilder() {
            return this;
        }

        @Override
        public ObservationTermsBuilder prune() {
            if (this.observationTime != null && !this.observationTime.prune().hasData()) {
                this.observationTime = null;
            }
            if (this.informationSource != null && !this.informationSource.prune().hasData()) {
                this.informationSource = null;
            }
            if (this.precision != null && !this.precision.prune().hasData()) {
                this.precision = null;
            }
            if (this.calculationPeriodDates != null && !this.calculationPeriodDates.prune().hasData()) {
                this.calculationPeriodDates = null;
            }
            if (this.observationDates != null && !this.observationDates.prune().hasData()) {
                this.observationDates = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getObservationTime() != null && this.getObservationTime().hasData()) {
                return true;
            }
            if (this.getObservationTimeType() != null) {
                return true;
            }
            if (this.getInformationSource() != null && this.getInformationSource().hasData()) {
                return true;
            }
            if (this.getPrecision() != null && this.getPrecision().hasData()) {
                return true;
            }
            if (this.getCalculationPeriodDates() != null && this.getCalculationPeriodDates().hasData()) {
                return true;
            }
            if (this.getObservationDates() != null && this.getObservationDates().hasData()) {
                return true;
            }
            return this.getNumberOfObservationDates() != null;
        }

        public ObservationTermsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ObservationTermsBuilder o = (ObservationTermsBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getObservationTime(), (RosettaModelObjectBuilder)o.getObservationTime(), this::setObservationTime);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getInformationSource(), (RosettaModelObjectBuilder)o.getInformationSource(), this::setInformationSource);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPrecision(), (RosettaModelObjectBuilder)o.getPrecision(), this::setPrecision);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCalculationPeriodDates(), (RosettaModelObjectBuilder)o.getCalculationPeriodDates(), this::setCalculationPeriodDates);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getObservationDates(), (RosettaModelObjectBuilder)o.getObservationDates(), this::setObservationDates);
            merger.mergeBasic((Object)this.getObservationTimeType(), (Object)o.getObservationTimeType(), this::setObservationTimeType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNumberOfObservationDates(), (Object)o.getNumberOfObservationDates(), this::setNumberOfObservationDates, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ObservationTerms _that = this.getType().cast(o);
            if (!Objects.equals(this.observationTime, _that.getObservationTime())) {
                return false;
            }
            if (!Objects.equals((Object)this.observationTimeType, (Object)_that.getObservationTimeType())) {
                return false;
            }
            if (!Objects.equals(this.informationSource, _that.getInformationSource())) {
                return false;
            }
            if (!Objects.equals(this.precision, _that.getPrecision())) {
                return false;
            }
            if (!Objects.equals(this.calculationPeriodDates, _that.getCalculationPeriodDates())) {
                return false;
            }
            if (!Objects.equals(this.observationDates, _that.getObservationDates())) {
                return false;
            }
            return Objects.equals(this.numberOfObservationDates, _that.getNumberOfObservationDates());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.observationTime != null ? this.observationTime.hashCode() : 0);
            _result = 31 * _result + (this.observationTimeType != null ? ((Object)((Object)this.observationTimeType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.informationSource != null ? this.informationSource.hashCode() : 0);
            _result = 31 * _result + (this.precision != null ? this.precision.hashCode() : 0);
            _result = 31 * _result + (this.calculationPeriodDates != null ? this.calculationPeriodDates.hashCode() : 0);
            _result = 31 * _result + (this.observationDates != null ? this.observationDates.hashCode() : 0);
            _result = 31 * _result + (this.numberOfObservationDates != null ? this.numberOfObservationDates.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ObservationTermsBuilder {observationTime=" + this.observationTime + ", observationTimeType=" + (Object)((Object)this.observationTimeType) + ", informationSource=" + this.informationSource + ", precision=" + this.precision + ", calculationPeriodDates=" + this.calculationPeriodDates + ", observationDates=" + this.observationDates + ", numberOfObservationDates=" + this.numberOfObservationDates + '}';
        }
    }

    public static interface ObservationTermsBuilder
    extends ObservationTerms,
    RosettaModelObjectBuilder {
        public BusinessCenterTime.BusinessCenterTimeBuilder getOrCreateObservationTime();

        @Override
        public BusinessCenterTime.BusinessCenterTimeBuilder getObservationTime();

        public FxSpotRateSource.FxSpotRateSourceBuilder getOrCreateInformationSource();

        @Override
        public FxSpotRateSource.FxSpotRateSourceBuilder getInformationSource();

        public Rounding.RoundingBuilder getOrCreatePrecision();

        @Override
        public Rounding.RoundingBuilder getPrecision();

        public CalculationPeriodDates.CalculationPeriodDatesBuilder getOrCreateCalculationPeriodDates();

        @Override
        public CalculationPeriodDates.CalculationPeriodDatesBuilder getCalculationPeriodDates();

        public ObservationDates.ObservationDatesBuilder getOrCreateObservationDates();

        @Override
        public ObservationDates.ObservationDatesBuilder getObservationDates();

        public ObservationTermsBuilder setObservationTime(BusinessCenterTime var1);

        public ObservationTermsBuilder setObservationTimeType(TimeTypeEnum var1);

        public ObservationTermsBuilder setInformationSource(FxSpotRateSource var1);

        public ObservationTermsBuilder setPrecision(Rounding var1);

        public ObservationTermsBuilder setCalculationPeriodDates(CalculationPeriodDates var1);

        public ObservationTermsBuilder setObservationDates(ObservationDates var1);

        public ObservationTermsBuilder setNumberOfObservationDates(Integer var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("observationTime"), processor, BusinessCenterTime.BusinessCenterTimeBuilder.class, this.getObservationTime(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("observationTimeType"), TimeTypeEnum.class, (Object)this.getObservationTimeType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("informationSource"), processor, FxSpotRateSource.FxSpotRateSourceBuilder.class, this.getInformationSource(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("precision"), processor, Rounding.RoundingBuilder.class, this.getPrecision(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("calculationPeriodDates"), processor, CalculationPeriodDates.CalculationPeriodDatesBuilder.class, this.getCalculationPeriodDates(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("observationDates"), processor, ObservationDates.ObservationDatesBuilder.class, this.getObservationDates(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("numberOfObservationDates"), Integer.class, (Object)this.getNumberOfObservationDates(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public ObservationTermsBuilder prune();
    }

    public static class ObservationTermsImpl
    implements ObservationTerms {
        private final BusinessCenterTime observationTime;
        private final TimeTypeEnum observationTimeType;
        private final FxSpotRateSource informationSource;
        private final Rounding precision;
        private final CalculationPeriodDates calculationPeriodDates;
        private final ObservationDates observationDates;
        private final Integer numberOfObservationDates;

        protected ObservationTermsImpl(ObservationTermsBuilder builder) {
            this.observationTime = Optional.ofNullable(builder.getObservationTime()).map(f -> f.build()).orElse(null);
            this.observationTimeType = builder.getObservationTimeType();
            this.informationSource = Optional.ofNullable(builder.getInformationSource()).map(f -> f.build()).orElse(null);
            this.precision = Optional.ofNullable(builder.getPrecision()).map(f -> f.build()).orElse(null);
            this.calculationPeriodDates = Optional.ofNullable(builder.getCalculationPeriodDates()).map(f -> f.build()).orElse(null);
            this.observationDates = Optional.ofNullable(builder.getObservationDates()).map(f -> f.build()).orElse(null);
            this.numberOfObservationDates = builder.getNumberOfObservationDates();
        }

        @Override
        @RosettaAttribute(value="observationTime")
        @RuneAttribute(value="observationTime")
        public BusinessCenterTime getObservationTime() {
            return this.observationTime;
        }

        @Override
        @RosettaAttribute(value="observationTimeType")
        @RuneAttribute(value="observationTimeType")
        public TimeTypeEnum getObservationTimeType() {
            return this.observationTimeType;
        }

        @Override
        @RosettaAttribute(value="informationSource")
        @RuneAttribute(value="informationSource")
        public FxSpotRateSource getInformationSource() {
            return this.informationSource;
        }

        @Override
        @RosettaAttribute(value="precision")
        @RuneAttribute(value="precision")
        public Rounding getPrecision() {
            return this.precision;
        }

        @Override
        @RosettaAttribute(value="calculationPeriodDates")
        @RuneAttribute(value="calculationPeriodDates")
        public CalculationPeriodDates getCalculationPeriodDates() {
            return this.calculationPeriodDates;
        }

        @Override
        @RosettaAttribute(value="observationDates")
        @RuneAttribute(value="observationDates")
        public ObservationDates getObservationDates() {
            return this.observationDates;
        }

        @Override
        @RosettaAttribute(value="numberOfObservationDates")
        @RuneAttribute(value="numberOfObservationDates")
        public Integer getNumberOfObservationDates() {
            return this.numberOfObservationDates;
        }

        @Override
        public ObservationTerms build() {
            return this;
        }

        @Override
        public ObservationTermsBuilder toBuilder() {
            ObservationTermsBuilder builder = ObservationTerms.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ObservationTermsBuilder builder) {
            Optional.ofNullable(this.getObservationTime()).ifPresent(builder::setObservationTime);
            Optional.ofNullable(this.getObservationTimeType()).ifPresent(builder::setObservationTimeType);
            Optional.ofNullable(this.getInformationSource()).ifPresent(builder::setInformationSource);
            Optional.ofNullable(this.getPrecision()).ifPresent(builder::setPrecision);
            Optional.ofNullable(this.getCalculationPeriodDates()).ifPresent(builder::setCalculationPeriodDates);
            Optional.ofNullable(this.getObservationDates()).ifPresent(builder::setObservationDates);
            Optional.ofNullable(this.getNumberOfObservationDates()).ifPresent(builder::setNumberOfObservationDates);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ObservationTerms _that = this.getType().cast(o);
            if (!Objects.equals(this.observationTime, _that.getObservationTime())) {
                return false;
            }
            if (!Objects.equals((Object)this.observationTimeType, (Object)_that.getObservationTimeType())) {
                return false;
            }
            if (!Objects.equals(this.informationSource, _that.getInformationSource())) {
                return false;
            }
            if (!Objects.equals(this.precision, _that.getPrecision())) {
                return false;
            }
            if (!Objects.equals(this.calculationPeriodDates, _that.getCalculationPeriodDates())) {
                return false;
            }
            if (!Objects.equals(this.observationDates, _that.getObservationDates())) {
                return false;
            }
            return Objects.equals(this.numberOfObservationDates, _that.getNumberOfObservationDates());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.observationTime != null ? this.observationTime.hashCode() : 0);
            _result = 31 * _result + (this.observationTimeType != null ? ((Object)((Object)this.observationTimeType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.informationSource != null ? this.informationSource.hashCode() : 0);
            _result = 31 * _result + (this.precision != null ? this.precision.hashCode() : 0);
            _result = 31 * _result + (this.calculationPeriodDates != null ? this.calculationPeriodDates.hashCode() : 0);
            _result = 31 * _result + (this.observationDates != null ? this.observationDates.hashCode() : 0);
            _result = 31 * _result + (this.numberOfObservationDates != null ? this.numberOfObservationDates.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ObservationTerms {observationTime=" + this.observationTime + ", observationTimeType=" + (Object)((Object)this.observationTimeType) + ", informationSource=" + this.informationSource + ", precision=" + this.precision + ", calculationPeriodDates=" + this.calculationPeriodDates + ", observationDates=" + this.observationDates + ", numberOfObservationDates=" + this.numberOfObservationDates + '}';
        }
    }
}

