/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement;

import cdm.base.datetime.AdjustableOrAdjustedOrRelativeDate;
import cdm.base.math.NonNegativeQuantity;
import cdm.base.staticdata.asset.common.Asset;
import cdm.product.common.settlement.meta.AssetFlowBaseMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="AssetFlowBase", builder=AssetFlowBaseBuilderImpl.class, version="6.7.0")
@RuneDataType(value="AssetFlowBase", model="cdm", builder=AssetFlowBaseBuilderImpl.class, version="6.7.0")
public interface AssetFlowBase
extends RosettaModelObject {
    public static final AssetFlowBaseMeta metaData = new AssetFlowBaseMeta();

    public NonNegativeQuantity getQuantity();

    public Asset getAsset();

    public AdjustableOrAdjustedOrRelativeDate getSettlementDate();

    public AssetFlowBase build();

    public AssetFlowBaseBuilder toBuilder();

    public static AssetFlowBaseBuilder builder() {
        return new AssetFlowBaseBuilderImpl();
    }

    default public RosettaMetaData<? extends AssetFlowBase> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AssetFlowBase> getType() {
        return AssetFlowBase.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("quantity"), processor, NonNegativeQuantity.class, this.getQuantity(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("asset"), processor, Asset.class, this.getAsset(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementDate"), processor, AdjustableOrAdjustedOrRelativeDate.class, this.getSettlementDate(), new AttributeMeta[0]);
    }

    public static class AssetFlowBaseBuilderImpl
    implements AssetFlowBaseBuilder {
        protected NonNegativeQuantity.NonNegativeQuantityBuilder quantity;
        protected Asset.AssetBuilder asset;
        protected AdjustableOrAdjustedOrRelativeDate.AdjustableOrAdjustedOrRelativeDateBuilder settlementDate;

        @Override
        @RosettaAttribute(value="quantity")
        @RuneAttribute(value="quantity")
        public NonNegativeQuantity.NonNegativeQuantityBuilder getQuantity() {
            return this.quantity;
        }

        @Override
        public NonNegativeQuantity.NonNegativeQuantityBuilder getOrCreateQuantity() {
            NonNegativeQuantity.NonNegativeQuantityBuilder result = this.quantity != null ? this.quantity : (this.quantity = NonNegativeQuantity.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="asset")
        @RuneAttribute(value="asset")
        public Asset.AssetBuilder getAsset() {
            return this.asset;
        }

        @Override
        public Asset.AssetBuilder getOrCreateAsset() {
            Asset.AssetBuilder result = this.asset != null ? this.asset : (this.asset = Asset.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="settlementDate")
        @RuneAttribute(value="settlementDate")
        public AdjustableOrAdjustedOrRelativeDate.AdjustableOrAdjustedOrRelativeDateBuilder getSettlementDate() {
            return this.settlementDate;
        }

        @Override
        public AdjustableOrAdjustedOrRelativeDate.AdjustableOrAdjustedOrRelativeDateBuilder getOrCreateSettlementDate() {
            AdjustableOrAdjustedOrRelativeDate.AdjustableOrAdjustedOrRelativeDateBuilder result = this.settlementDate != null ? this.settlementDate : (this.settlementDate = AdjustableOrAdjustedOrRelativeDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="quantity")
        @RuneAttribute(value="quantity")
        public AssetFlowBaseBuilder setQuantity(NonNegativeQuantity _quantity) {
            this.quantity = _quantity == null ? null : _quantity.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="asset")
        @RuneAttribute(value="asset")
        public AssetFlowBaseBuilder setAsset(Asset _asset) {
            this.asset = _asset == null ? null : _asset.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementDate")
        @RuneAttribute(value="settlementDate")
        public AssetFlowBaseBuilder setSettlementDate(AdjustableOrAdjustedOrRelativeDate _settlementDate) {
            this.settlementDate = _settlementDate == null ? null : _settlementDate.toBuilder();
            return this;
        }

        @Override
        public AssetFlowBase build() {
            return new AssetFlowBaseImpl(this);
        }

        @Override
        public AssetFlowBaseBuilder toBuilder() {
            return this;
        }

        @Override
        public AssetFlowBaseBuilder prune() {
            if (this.quantity != null && !this.quantity.prune().hasData()) {
                this.quantity = null;
            }
            if (this.asset != null && !this.asset.prune().hasData()) {
                this.asset = null;
            }
            if (this.settlementDate != null && !this.settlementDate.prune().hasData()) {
                this.settlementDate = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getQuantity() != null && this.getQuantity().hasData()) {
                return true;
            }
            if (this.getAsset() != null && this.getAsset().hasData()) {
                return true;
            }
            return this.getSettlementDate() != null && this.getSettlementDate().hasData();
        }

        public AssetFlowBaseBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            AssetFlowBaseBuilder o = (AssetFlowBaseBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getQuantity(), (RosettaModelObjectBuilder)o.getQuantity(), this::setQuantity);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAsset(), (RosettaModelObjectBuilder)o.getAsset(), this::setAsset);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSettlementDate(), (RosettaModelObjectBuilder)o.getSettlementDate(), this::setSettlementDate);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AssetFlowBase _that = this.getType().cast(o);
            if (!Objects.equals(this.quantity, _that.getQuantity())) {
                return false;
            }
            if (!Objects.equals(this.asset, _that.getAsset())) {
                return false;
            }
            return Objects.equals(this.settlementDate, _that.getSettlementDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.quantity != null ? this.quantity.hashCode() : 0);
            _result = 31 * _result + (this.asset != null ? this.asset.hashCode() : 0);
            _result = 31 * _result + (this.settlementDate != null ? this.settlementDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AssetFlowBaseBuilder {quantity=" + this.quantity + ", asset=" + this.asset + ", settlementDate=" + this.settlementDate + '}';
        }
    }

    public static interface AssetFlowBaseBuilder
    extends AssetFlowBase,
    RosettaModelObjectBuilder {
        public NonNegativeQuantity.NonNegativeQuantityBuilder getOrCreateQuantity();

        @Override
        public NonNegativeQuantity.NonNegativeQuantityBuilder getQuantity();

        public Asset.AssetBuilder getOrCreateAsset();

        @Override
        public Asset.AssetBuilder getAsset();

        public AdjustableOrAdjustedOrRelativeDate.AdjustableOrAdjustedOrRelativeDateBuilder getOrCreateSettlementDate();

        @Override
        public AdjustableOrAdjustedOrRelativeDate.AdjustableOrAdjustedOrRelativeDateBuilder getSettlementDate();

        public AssetFlowBaseBuilder setQuantity(NonNegativeQuantity var1);

        public AssetFlowBaseBuilder setAsset(Asset var1);

        public AssetFlowBaseBuilder setSettlementDate(AdjustableOrAdjustedOrRelativeDate var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("quantity"), processor, NonNegativeQuantity.NonNegativeQuantityBuilder.class, this.getQuantity(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("asset"), processor, Asset.AssetBuilder.class, this.getAsset(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementDate"), processor, AdjustableOrAdjustedOrRelativeDate.AdjustableOrAdjustedOrRelativeDateBuilder.class, this.getSettlementDate(), new AttributeMeta[0]);
        }

        public AssetFlowBaseBuilder prune();
    }

    public static class AssetFlowBaseImpl
    implements AssetFlowBase {
        private final NonNegativeQuantity quantity;
        private final Asset asset;
        private final AdjustableOrAdjustedOrRelativeDate settlementDate;

        protected AssetFlowBaseImpl(AssetFlowBaseBuilder builder) {
            this.quantity = Optional.ofNullable(builder.getQuantity()).map(f -> f.build()).orElse(null);
            this.asset = Optional.ofNullable(builder.getAsset()).map(f -> f.build()).orElse(null);
            this.settlementDate = Optional.ofNullable(builder.getSettlementDate()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="quantity")
        @RuneAttribute(value="quantity")
        public NonNegativeQuantity getQuantity() {
            return this.quantity;
        }

        @Override
        @RosettaAttribute(value="asset")
        @RuneAttribute(value="asset")
        public Asset getAsset() {
            return this.asset;
        }

        @Override
        @RosettaAttribute(value="settlementDate")
        @RuneAttribute(value="settlementDate")
        public AdjustableOrAdjustedOrRelativeDate getSettlementDate() {
            return this.settlementDate;
        }

        @Override
        public AssetFlowBase build() {
            return this;
        }

        @Override
        public AssetFlowBaseBuilder toBuilder() {
            AssetFlowBaseBuilder builder = AssetFlowBase.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AssetFlowBaseBuilder builder) {
            Optional.ofNullable(this.getQuantity()).ifPresent(builder::setQuantity);
            Optional.ofNullable(this.getAsset()).ifPresent(builder::setAsset);
            Optional.ofNullable(this.getSettlementDate()).ifPresent(builder::setSettlementDate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AssetFlowBase _that = this.getType().cast(o);
            if (!Objects.equals(this.quantity, _that.getQuantity())) {
                return false;
            }
            if (!Objects.equals(this.asset, _that.getAsset())) {
                return false;
            }
            return Objects.equals(this.settlementDate, _that.getSettlementDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.quantity != null ? this.quantity.hashCode() : 0);
            _result = 31 * _result + (this.asset != null ? this.asset.hashCode() : 0);
            _result = 31 * _result + (this.settlementDate != null ? this.settlementDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AssetFlowBase {quantity=" + this.quantity + ", asset=" + this.asset + ", settlementDate=" + this.settlementDate + '}';
        }
    }
}

