/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement;

import cdm.base.datetime.AdjustableOrAdjustedOrRelativeDate;
import cdm.base.math.NonNegativeQuantity;
import cdm.base.staticdata.asset.common.Asset;
import cdm.base.staticdata.party.PayerReceiver;
import cdm.product.common.settlement.AssetFlowBase;
import cdm.product.common.settlement.CashflowType;
import cdm.product.common.settlement.PaymentDiscounting;
import cdm.product.common.settlement.meta.CashflowMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="Cashflow", builder=CashflowBuilderImpl.class, version="6.7.0")
@RuneDataType(value="Cashflow", model="cdm", builder=CashflowBuilderImpl.class, version="6.7.0")
public interface Cashflow
extends AssetFlowBase {
    public static final CashflowMeta metaData = new CashflowMeta();

    public PayerReceiver getPayerReceiver();

    public CashflowType getCashflowType();

    public PaymentDiscounting getPaymentDiscounting();

    @Override
    public Cashflow build();

    @Override
    public CashflowBuilder toBuilder();

    public static CashflowBuilder builder() {
        return new CashflowBuilderImpl();
    }

    default public RosettaMetaData<? extends Cashflow> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Cashflow> getType() {
        return Cashflow.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("quantity"), processor, NonNegativeQuantity.class, this.getQuantity(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("asset"), processor, Asset.class, this.getAsset(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementDate"), processor, AdjustableOrAdjustedOrRelativeDate.class, this.getSettlementDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("payerReceiver"), processor, PayerReceiver.class, this.getPayerReceiver(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("cashflowType"), processor, CashflowType.class, this.getCashflowType(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentDiscounting"), processor, PaymentDiscounting.class, this.getPaymentDiscounting(), new AttributeMeta[0]);
    }

    public static class CashflowBuilderImpl
    extends AssetFlowBase.AssetFlowBaseBuilderImpl
    implements CashflowBuilder {
        protected PayerReceiver.PayerReceiverBuilder payerReceiver;
        protected CashflowType.CashflowTypeBuilder cashflowType;
        protected PaymentDiscounting.PaymentDiscountingBuilder paymentDiscounting;

        @Override
        @RosettaAttribute(value="payerReceiver")
        @RuneAttribute(value="payerReceiver")
        public PayerReceiver.PayerReceiverBuilder getPayerReceiver() {
            return this.payerReceiver;
        }

        @Override
        public PayerReceiver.PayerReceiverBuilder getOrCreatePayerReceiver() {
            PayerReceiver.PayerReceiverBuilder result = this.payerReceiver != null ? this.payerReceiver : (this.payerReceiver = PayerReceiver.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="cashflowType")
        @RuneAttribute(value="cashflowType")
        public CashflowType.CashflowTypeBuilder getCashflowType() {
            return this.cashflowType;
        }

        @Override
        public CashflowType.CashflowTypeBuilder getOrCreateCashflowType() {
            CashflowType.CashflowTypeBuilder result = this.cashflowType != null ? this.cashflowType : (this.cashflowType = CashflowType.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="paymentDiscounting")
        @RuneAttribute(value="paymentDiscounting")
        public PaymentDiscounting.PaymentDiscountingBuilder getPaymentDiscounting() {
            return this.paymentDiscounting;
        }

        @Override
        public PaymentDiscounting.PaymentDiscountingBuilder getOrCreatePaymentDiscounting() {
            PaymentDiscounting.PaymentDiscountingBuilder result = this.paymentDiscounting != null ? this.paymentDiscounting : (this.paymentDiscounting = PaymentDiscounting.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="quantity")
        @RuneAttribute(value="quantity")
        public CashflowBuilder setQuantity(NonNegativeQuantity _quantity) {
            this.quantity = _quantity == null ? null : _quantity.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="asset")
        @RuneAttribute(value="asset")
        public CashflowBuilder setAsset(Asset _asset) {
            this.asset = _asset == null ? null : _asset.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementDate")
        @RuneAttribute(value="settlementDate")
        public CashflowBuilder setSettlementDate(AdjustableOrAdjustedOrRelativeDate _settlementDate) {
            this.settlementDate = _settlementDate == null ? null : _settlementDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="payerReceiver")
        @RuneAttribute(value="payerReceiver")
        public CashflowBuilder setPayerReceiver(PayerReceiver _payerReceiver) {
            this.payerReceiver = _payerReceiver == null ? null : _payerReceiver.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="cashflowType")
        @RuneAttribute(value="cashflowType")
        public CashflowBuilder setCashflowType(CashflowType _cashflowType) {
            this.cashflowType = _cashflowType == null ? null : _cashflowType.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentDiscounting")
        @RuneAttribute(value="paymentDiscounting")
        public CashflowBuilder setPaymentDiscounting(PaymentDiscounting _paymentDiscounting) {
            this.paymentDiscounting = _paymentDiscounting == null ? null : _paymentDiscounting.toBuilder();
            return this;
        }

        @Override
        public Cashflow build() {
            return new CashflowImpl(this);
        }

        @Override
        public CashflowBuilder toBuilder() {
            return this;
        }

        @Override
        public CashflowBuilder prune() {
            super.prune();
            if (this.payerReceiver != null && !this.payerReceiver.prune().hasData()) {
                this.payerReceiver = null;
            }
            if (this.cashflowType != null && !this.cashflowType.prune().hasData()) {
                this.cashflowType = null;
            }
            if (this.paymentDiscounting != null && !this.paymentDiscounting.prune().hasData()) {
                this.paymentDiscounting = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getPayerReceiver() != null && this.getPayerReceiver().hasData()) {
                return true;
            }
            if (this.getCashflowType() != null && this.getCashflowType().hasData()) {
                return true;
            }
            return this.getPaymentDiscounting() != null && this.getPaymentDiscounting().hasData();
        }

        @Override
        public CashflowBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            CashflowBuilder o = (CashflowBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPayerReceiver(), (RosettaModelObjectBuilder)o.getPayerReceiver(), this::setPayerReceiver);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCashflowType(), (RosettaModelObjectBuilder)o.getCashflowType(), this::setCashflowType);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPaymentDiscounting(), (RosettaModelObjectBuilder)o.getPaymentDiscounting(), this::setPaymentDiscounting);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Cashflow _that = (Cashflow)this.getType().cast(o);
            if (!Objects.equals(this.payerReceiver, _that.getPayerReceiver())) {
                return false;
            }
            if (!Objects.equals(this.cashflowType, _that.getCashflowType())) {
                return false;
            }
            return Objects.equals(this.paymentDiscounting, _that.getPaymentDiscounting());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.payerReceiver != null ? this.payerReceiver.hashCode() : 0);
            _result = 31 * _result + (this.cashflowType != null ? this.cashflowType.hashCode() : 0);
            _result = 31 * _result + (this.paymentDiscounting != null ? this.paymentDiscounting.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CashflowBuilder {payerReceiver=" + this.payerReceiver + ", cashflowType=" + this.cashflowType + ", paymentDiscounting=" + this.paymentDiscounting + '}' + " " + super.toString();
        }
    }

    public static interface CashflowBuilder
    extends Cashflow,
    AssetFlowBase.AssetFlowBaseBuilder {
        public PayerReceiver.PayerReceiverBuilder getOrCreatePayerReceiver();

        @Override
        public PayerReceiver.PayerReceiverBuilder getPayerReceiver();

        public CashflowType.CashflowTypeBuilder getOrCreateCashflowType();

        @Override
        public CashflowType.CashflowTypeBuilder getCashflowType();

        public PaymentDiscounting.PaymentDiscountingBuilder getOrCreatePaymentDiscounting();

        @Override
        public PaymentDiscounting.PaymentDiscountingBuilder getPaymentDiscounting();

        @Override
        public CashflowBuilder setQuantity(NonNegativeQuantity var1);

        @Override
        public CashflowBuilder setAsset(Asset var1);

        @Override
        public CashflowBuilder setSettlementDate(AdjustableOrAdjustedOrRelativeDate var1);

        public CashflowBuilder setPayerReceiver(PayerReceiver var1);

        public CashflowBuilder setCashflowType(CashflowType var1);

        public CashflowBuilder setPaymentDiscounting(PaymentDiscounting var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("quantity"), processor, NonNegativeQuantity.NonNegativeQuantityBuilder.class, (RosettaModelObjectBuilder)this.getQuantity(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("asset"), processor, Asset.AssetBuilder.class, (RosettaModelObjectBuilder)this.getAsset(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementDate"), processor, AdjustableOrAdjustedOrRelativeDate.AdjustableOrAdjustedOrRelativeDateBuilder.class, (RosettaModelObjectBuilder)this.getSettlementDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("payerReceiver"), processor, PayerReceiver.PayerReceiverBuilder.class, this.getPayerReceiver(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("cashflowType"), processor, CashflowType.CashflowTypeBuilder.class, this.getCashflowType(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentDiscounting"), processor, PaymentDiscounting.PaymentDiscountingBuilder.class, this.getPaymentDiscounting(), new AttributeMeta[0]);
        }

        @Override
        public CashflowBuilder prune();
    }

    public static class CashflowImpl
    extends AssetFlowBase.AssetFlowBaseImpl
    implements Cashflow {
        private final PayerReceiver payerReceiver;
        private final CashflowType cashflowType;
        private final PaymentDiscounting paymentDiscounting;

        protected CashflowImpl(CashflowBuilder builder) {
            super(builder);
            this.payerReceiver = Optional.ofNullable(builder.getPayerReceiver()).map(f -> f.build()).orElse(null);
            this.cashflowType = Optional.ofNullable(builder.getCashflowType()).map(f -> f.build()).orElse(null);
            this.paymentDiscounting = Optional.ofNullable(builder.getPaymentDiscounting()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="payerReceiver")
        @RuneAttribute(value="payerReceiver")
        public PayerReceiver getPayerReceiver() {
            return this.payerReceiver;
        }

        @Override
        @RosettaAttribute(value="cashflowType")
        @RuneAttribute(value="cashflowType")
        public CashflowType getCashflowType() {
            return this.cashflowType;
        }

        @Override
        @RosettaAttribute(value="paymentDiscounting")
        @RuneAttribute(value="paymentDiscounting")
        public PaymentDiscounting getPaymentDiscounting() {
            return this.paymentDiscounting;
        }

        @Override
        public Cashflow build() {
            return this;
        }

        @Override
        public CashflowBuilder toBuilder() {
            CashflowBuilder builder = Cashflow.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CashflowBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getPayerReceiver()).ifPresent(builder::setPayerReceiver);
            Optional.ofNullable(this.getCashflowType()).ifPresent(builder::setCashflowType);
            Optional.ofNullable(this.getPaymentDiscounting()).ifPresent(builder::setPaymentDiscounting);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Cashflow _that = (Cashflow)this.getType().cast(o);
            if (!Objects.equals(this.payerReceiver, _that.getPayerReceiver())) {
                return false;
            }
            if (!Objects.equals(this.cashflowType, _that.getCashflowType())) {
                return false;
            }
            return Objects.equals(this.paymentDiscounting, _that.getPaymentDiscounting());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.payerReceiver != null ? this.payerReceiver.hashCode() : 0);
            _result = 31 * _result + (this.cashflowType != null ? this.cashflowType.hashCode() : 0);
            _result = 31 * _result + (this.paymentDiscounting != null ? this.paymentDiscounting.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "Cashflow {payerReceiver=" + this.payerReceiver + ", cashflowType=" + this.cashflowType + ", paymentDiscounting=" + this.paymentDiscounting + '}' + " " + super.toString();
        }
    }
}

