/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement;

import cdm.observable.asset.Money;
import cdm.product.common.settlement.meta.PaymentDiscountingMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="PaymentDiscounting", builder=PaymentDiscountingBuilderImpl.class, version="6.7.0")
@RuneDataType(value="PaymentDiscounting", model="cdm", builder=PaymentDiscountingBuilderImpl.class, version="6.7.0")
public interface PaymentDiscounting
extends RosettaModelObject {
    public static final PaymentDiscountingMeta metaData = new PaymentDiscountingMeta();

    public BigDecimal getDiscountFactor();

    public Money getPresentValueAmount();

    public PaymentDiscounting build();

    public PaymentDiscountingBuilder toBuilder();

    public static PaymentDiscountingBuilder builder() {
        return new PaymentDiscountingBuilderImpl();
    }

    default public RosettaMetaData<? extends PaymentDiscounting> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends PaymentDiscounting> getType() {
        return PaymentDiscounting.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("discountFactor"), BigDecimal.class, (Object)this.getDiscountFactor(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("presentValueAmount"), processor, Money.class, this.getPresentValueAmount(), new AttributeMeta[0]);
    }

    public static class PaymentDiscountingBuilderImpl
    implements PaymentDiscountingBuilder {
        protected BigDecimal discountFactor;
        protected Money.MoneyBuilder presentValueAmount;

        @Override
        @RosettaAttribute(value="discountFactor")
        @RuneAttribute(value="discountFactor")
        public BigDecimal getDiscountFactor() {
            return this.discountFactor;
        }

        @Override
        @RosettaAttribute(value="presentValueAmount")
        @RuneAttribute(value="presentValueAmount")
        public Money.MoneyBuilder getPresentValueAmount() {
            return this.presentValueAmount;
        }

        @Override
        public Money.MoneyBuilder getOrCreatePresentValueAmount() {
            Money.MoneyBuilder result = this.presentValueAmount != null ? this.presentValueAmount : (this.presentValueAmount = Money.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="discountFactor")
        @RuneAttribute(value="discountFactor")
        public PaymentDiscountingBuilder setDiscountFactor(BigDecimal _discountFactor) {
            this.discountFactor = _discountFactor == null ? null : _discountFactor;
            return this;
        }

        @Override
        @RosettaAttribute(value="presentValueAmount")
        @RuneAttribute(value="presentValueAmount")
        public PaymentDiscountingBuilder setPresentValueAmount(Money _presentValueAmount) {
            this.presentValueAmount = _presentValueAmount == null ? null : _presentValueAmount.toBuilder();
            return this;
        }

        @Override
        public PaymentDiscounting build() {
            return new PaymentDiscountingImpl(this);
        }

        @Override
        public PaymentDiscountingBuilder toBuilder() {
            return this;
        }

        @Override
        public PaymentDiscountingBuilder prune() {
            if (this.presentValueAmount != null && !this.presentValueAmount.prune().hasData()) {
                this.presentValueAmount = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getDiscountFactor() != null) {
                return true;
            }
            return this.getPresentValueAmount() != null && this.getPresentValueAmount().hasData();
        }

        public PaymentDiscountingBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PaymentDiscountingBuilder o = (PaymentDiscountingBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPresentValueAmount(), (RosettaModelObjectBuilder)o.getPresentValueAmount(), this::setPresentValueAmount);
            merger.mergeBasic((Object)this.getDiscountFactor(), (Object)o.getDiscountFactor(), this::setDiscountFactor, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PaymentDiscounting _that = this.getType().cast(o);
            if (!Objects.equals(this.discountFactor, _that.getDiscountFactor())) {
                return false;
            }
            return Objects.equals(this.presentValueAmount, _that.getPresentValueAmount());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.discountFactor != null ? this.discountFactor.hashCode() : 0);
            _result = 31 * _result + (this.presentValueAmount != null ? this.presentValueAmount.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PaymentDiscountingBuilder {discountFactor=" + this.discountFactor + ", presentValueAmount=" + this.presentValueAmount + '}';
        }
    }

    public static interface PaymentDiscountingBuilder
    extends PaymentDiscounting,
    RosettaModelObjectBuilder {
        public Money.MoneyBuilder getOrCreatePresentValueAmount();

        @Override
        public Money.MoneyBuilder getPresentValueAmount();

        public PaymentDiscountingBuilder setDiscountFactor(BigDecimal var1);

        public PaymentDiscountingBuilder setPresentValueAmount(Money var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("discountFactor"), BigDecimal.class, (Object)this.getDiscountFactor(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("presentValueAmount"), processor, Money.MoneyBuilder.class, this.getPresentValueAmount(), new AttributeMeta[0]);
        }

        public PaymentDiscountingBuilder prune();
    }

    public static class PaymentDiscountingImpl
    implements PaymentDiscounting {
        private final BigDecimal discountFactor;
        private final Money presentValueAmount;

        protected PaymentDiscountingImpl(PaymentDiscountingBuilder builder) {
            this.discountFactor = builder.getDiscountFactor();
            this.presentValueAmount = Optional.ofNullable(builder.getPresentValueAmount()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="discountFactor")
        @RuneAttribute(value="discountFactor")
        public BigDecimal getDiscountFactor() {
            return this.discountFactor;
        }

        @Override
        @RosettaAttribute(value="presentValueAmount")
        @RuneAttribute(value="presentValueAmount")
        public Money getPresentValueAmount() {
            return this.presentValueAmount;
        }

        @Override
        public PaymentDiscounting build() {
            return this;
        }

        @Override
        public PaymentDiscountingBuilder toBuilder() {
            PaymentDiscountingBuilder builder = PaymentDiscounting.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PaymentDiscountingBuilder builder) {
            Optional.ofNullable(this.getDiscountFactor()).ifPresent(builder::setDiscountFactor);
            Optional.ofNullable(this.getPresentValueAmount()).ifPresent(builder::setPresentValueAmount);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PaymentDiscounting _that = this.getType().cast(o);
            if (!Objects.equals(this.discountFactor, _that.getDiscountFactor())) {
                return false;
            }
            return Objects.equals(this.presentValueAmount, _that.getPresentValueAmount());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.discountFactor != null ? this.discountFactor.hashCode() : 0);
            _result = 31 * _result + (this.presentValueAmount != null ? this.presentValueAmount.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PaymentDiscounting {discountFactor=" + this.discountFactor + ", presentValueAmount=" + this.presentValueAmount + '}';
        }
    }
}

