/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement.functions;

import cdm.base.math.MeasureBase;
import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.QuantityChangeDirectionEnum;
import cdm.base.math.UnitType;
import cdm.base.math.metafields.FieldWithMetaNonNegativeQuantitySchedule;
import cdm.observable.asset.PriceComposite;
import cdm.observable.asset.PriceQuantity;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.PriceTypeEnum;
import cdm.observable.asset.metafields.FieldWithMetaPriceSchedule;
import cdm.product.common.settlement.functions.UpdateAmountForEachMatchingQuantity;
import com.rosetta.model.metafields.FieldWithMetaString;
import com.rosetta.util.CollectionUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class UpdateAmountForEachMatchingQuantityImpl
extends UpdateAmountForEachMatchingQuantity {
    @Override
    protected List<PriceQuantity.PriceQuantityBuilder> doEvaluate(List<? extends PriceQuantity> priceQuantity, List<? extends PriceQuantity> change, QuantityChangeDirectionEnum direction) {
        List<PriceQuantity.PriceQuantityBuilder> priceQuantityBuilders = CollectionUtils.emptyIfNull(priceQuantity).stream().map(pq -> pq.build().toBuilder()).collect(Collectors.toList());
        return this.update(priceQuantityBuilders, change, direction);
    }

    private List<PriceQuantity.PriceQuantityBuilder> update(List<PriceQuantity.PriceQuantityBuilder> priceQuantityBuilders, List<? extends PriceQuantity> change, QuantityChangeDirectionEnum direction) {
        Set newQuantities = CollectionUtils.emptyIfNull(change).stream().map(PriceQuantity::getQuantity).filter(Objects::nonNull).flatMap(Collection::stream).map(FieldWithMetaNonNegativeQuantitySchedule::getValue).filter(Objects::nonNull).collect(Collectors.toSet());
        Set newPrices = CollectionUtils.emptyIfNull(change).stream().map(PriceQuantity::getPrice).filter(Objects::nonNull).flatMap(Collection::stream).map(FieldWithMetaPriceSchedule::getValue).filter(Objects::nonNull).collect(Collectors.toSet());
        CollectionUtils.emptyIfNull(priceQuantityBuilders).forEach(pq -> {
            this.updateAmountForEachMatchingQuantity(pq.getQuantity(), newQuantities, direction);
            this.updateAmountForEachMatchingPrice(pq.getPrice(), newPrices, direction);
        });
        return priceQuantityBuilders;
    }

    private void updateAmountForEachMatchingQuantity(List<? extends FieldWithMetaNonNegativeQuantitySchedule.FieldWithMetaNonNegativeQuantityScheduleBuilder> quantitiesToUpdate, Set<? extends NonNegativeQuantitySchedule> newQuantities, QuantityChangeDirectionEnum direction) {
        CollectionUtils.emptyIfNull(quantitiesToUpdate).stream().filter(Objects::nonNull).map(FieldWithMetaNonNegativeQuantitySchedule.FieldWithMetaNonNegativeQuantityScheduleBuilder::getValue).filter(Objects::nonNull).forEach(quantityToUpdate -> this.findQuantityByUnitOfAmount(newQuantities, quantityToUpdate.getUnit()).ifPresent(newQuantity -> this.updateAmount((MeasureBase.MeasureBaseBuilder)quantityToUpdate, newQuantity.getValue(), direction)));
    }

    private Optional<? extends NonNegativeQuantitySchedule> findQuantityByUnitOfAmount(Set<? extends NonNegativeQuantitySchedule> quantities, UnitType unitOfAmount) {
        return Optional.ofNullable(quantities).orElseGet(HashSet::new).stream().filter(quantity -> Objects.nonNull(quantity.getUnit())).filter(quantity -> this.unitTypeEquals(quantity.getUnit(), unitOfAmount)).findFirst();
    }

    private void updateAmountForEachMatchingPrice(List<? extends FieldWithMetaPriceSchedule.FieldWithMetaPriceScheduleBuilder> pricesToUpdate, Set<? extends PriceSchedule> newPrices, QuantityChangeDirectionEnum direction) {
        CollectionUtils.emptyIfNull(pricesToUpdate).stream().filter(Objects::nonNull).map(FieldWithMetaPriceSchedule.FieldWithMetaPriceScheduleBuilder::getValue).forEach(priceToUpdate -> this.findPrice(newPrices, priceToUpdate.getUnit(), priceToUpdate.getPerUnitOf(), priceToUpdate.getPriceType(), priceToUpdate.getComposite()).ifPresent(matchingPrice -> this.updateAmount((MeasureBase.MeasureBaseBuilder)priceToUpdate, matchingPrice.getValue(), direction)));
    }

    private Optional<? extends PriceSchedule> findPrice(Set<? extends PriceSchedule> prices, UnitType unitOfAmount, UnitType perUnitOfAmount, PriceTypeEnum priceTypeEnum, PriceComposite composite) {
        return Optional.ofNullable(prices).orElseGet(HashSet::new).stream().filter(price -> Objects.nonNull(price.getUnit())).filter(price -> this.unitTypeEquals(price.getUnit(), unitOfAmount)).filter(price -> this.unitTypeEquals(price.getPerUnitOf(), perUnitOfAmount)).filter(price -> Objects.equals((Object)price.getPriceType(), (Object)priceTypeEnum)).filter(price -> {
            if (price.getComposite() == null && composite == null) {
                return true;
            }
            if (price.getComposite() == null || composite == null) {
                return false;
            }
            return Objects.equals(price.getComposite().toBuilder().prune(), composite.toBuilder().prune());
        }).findFirst();
    }

    private void updateAmount(MeasureBase.MeasureBaseBuilder measureBaseToUpdate, BigDecimal newAmount, QuantityChangeDirectionEnum direction) {
        if (measureBaseToUpdate.getValue() == null) {
            return;
        }
        switch (direction) {
            case INCREASE: {
                measureBaseToUpdate.setValue(measureBaseToUpdate.getValue().add(newAmount));
                break;
            }
            case DECREASE: {
                measureBaseToUpdate.setValue(measureBaseToUpdate.getValue().subtract(newAmount));
                break;
            }
            case REPLACE: {
                measureBaseToUpdate.setValue(newAmount);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected QuantityChangeDirectionEnum " + (Object)((Object)direction));
            }
        }
    }

    private boolean unitTypeEquals(UnitType o1, UnitType o2) {
        UnitType.UnitTypeBuilder b1 = o1.toBuilder().prune();
        UnitType.UnitTypeBuilder b2 = o2.toBuilder().prune();
        if (!Objects.equals((Object)b1.getCapacityUnit(), (Object)b2.getCapacityUnit())) {
            return false;
        }
        if (!Objects.equals((Object)b1.getFinancialUnit(), (Object)b2.getFinancialUnit())) {
            return false;
        }
        if (!Objects.equals((Object)b1.getWeatherUnit(), (Object)b2.getWeatherUnit())) {
            return false;
        }
        return Objects.equals(Optional.ofNullable(b1.getCurrency()).map(FieldWithMetaString::getValue), Optional.ofNullable(b2.getCurrency()).map(FieldWithMetaString::getValue));
    }
}

