/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.qualification.functions;

import cdm.base.staticdata.asset.common.AssetClassEnum;
import cdm.base.staticdata.asset.common.InstrumentTypeEnum;
import cdm.observable.asset.metafields.ReferenceWithMetaObservable;
import cdm.product.qualification.functions.ObservableQualification;
import cdm.product.template.Underlier;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import javax.inject.Inject;

@ImplementedBy(value=UnderlierQualificationDefault.class)
public abstract class UnderlierQualification
implements RosettaFunction {
    @Inject
    protected ObservableQualification observableQualification;

    public Boolean evaluate(Underlier underlier, InstrumentTypeEnum securityType, AssetClassEnum assetClass) {
        Boolean qualifies = this.doEvaluate(underlier, securityType, assetClass);
        return qualifies;
    }

    protected abstract Boolean doEvaluate(Underlier var1, InstrumentTypeEnum var2, AssetClassEnum var3);

    public static class UnderlierQualificationDefault
    extends UnderlierQualification {
        @Override
        protected Boolean doEvaluate(Underlier underlier, InstrumentTypeEnum securityType, AssetClassEnum assetClass) {
            Boolean qualifies = null;
            return this.assignOutput(qualifies, underlier, securityType, assetClass);
        }

        protected Boolean assignOutput(Boolean qualifies, Underlier underlier, InstrumentTypeEnum securityType, AssetClassEnum assetClass) {
            ReferenceWithMetaObservable referenceWithMetaObservable = (ReferenceWithMetaObservable)MapperS.of((Object)underlier).map("getObservable", _underlier -> _underlier.getObservable()).get();
            qualifies = ComparisonResult.of((Mapper)MapperS.of((Object)this.observableQualification.evaluate(referenceWithMetaObservable == null ? null : referenceWithMetaObservable.getValue(), securityType, assetClass))).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)underlier).map("getProduct", _underlier -> _underlier.getProduct()).map("getTransferableProduct", product -> product.getTransferableProduct()).map("getInstrument", transferableProduct -> transferableProduct.getInstrument()).map("getSecurity", instrument -> instrument.getSecurity()).map("getInstrumentType", security -> security.getInstrumentType()), (Mapper)MapperS.of((Object)((Object)securityType)), (CardinalityOperator)CardinalityOperator.All)).get();
            return qualifies;
        }
    }
}

