/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template;

import cdm.base.datetime.BusinessCenterTime;
import cdm.base.datetime.RelativeDateOffset;
import cdm.observable.asset.FxSpotRateSource;
import cdm.observable.common.DeterminationMethodEnum;
import cdm.product.template.meta.CompositeMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="Composite", builder=CompositeBuilderImpl.class, version="6.7.0")
@RuneDataType(value="Composite", model="cdm", builder=CompositeBuilderImpl.class, version="6.7.0")
public interface Composite
extends RosettaModelObject {
    public static final CompositeMeta metaData = new CompositeMeta();

    public DeterminationMethodEnum getDeterminationMethod();

    public RelativeDateOffset getRelativeDate();

    public FxSpotRateSource getFxSpotRateSource();

    public BusinessCenterTime getFixingTime();

    public Composite build();

    public CompositeBuilder toBuilder();

    public static CompositeBuilder builder() {
        return new CompositeBuilderImpl();
    }

    default public RosettaMetaData<? extends Composite> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Composite> getType() {
        return Composite.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("determinationMethod"), DeterminationMethodEnum.class, (Object)this.getDeterminationMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("relativeDate"), processor, RelativeDateOffset.class, this.getRelativeDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fxSpotRateSource"), processor, FxSpotRateSource.class, this.getFxSpotRateSource(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fixingTime"), processor, BusinessCenterTime.class, this.getFixingTime(), new AttributeMeta[0]);
    }

    public static class CompositeBuilderImpl
    implements CompositeBuilder {
        protected DeterminationMethodEnum determinationMethod;
        protected RelativeDateOffset.RelativeDateOffsetBuilder relativeDate;
        protected FxSpotRateSource.FxSpotRateSourceBuilder fxSpotRateSource;
        protected BusinessCenterTime.BusinessCenterTimeBuilder fixingTime;

        @Override
        @RosettaAttribute(value="determinationMethod")
        @RuneAttribute(value="determinationMethod")
        public DeterminationMethodEnum getDeterminationMethod() {
            return this.determinationMethod;
        }

        @Override
        @RosettaAttribute(value="relativeDate")
        @RuneAttribute(value="relativeDate")
        public RelativeDateOffset.RelativeDateOffsetBuilder getRelativeDate() {
            return this.relativeDate;
        }

        @Override
        public RelativeDateOffset.RelativeDateOffsetBuilder getOrCreateRelativeDate() {
            RelativeDateOffset.RelativeDateOffsetBuilder result = this.relativeDate != null ? this.relativeDate : (this.relativeDate = RelativeDateOffset.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fxSpotRateSource")
        @RuneAttribute(value="fxSpotRateSource")
        public FxSpotRateSource.FxSpotRateSourceBuilder getFxSpotRateSource() {
            return this.fxSpotRateSource;
        }

        @Override
        public FxSpotRateSource.FxSpotRateSourceBuilder getOrCreateFxSpotRateSource() {
            FxSpotRateSource.FxSpotRateSourceBuilder result = this.fxSpotRateSource != null ? this.fxSpotRateSource : (this.fxSpotRateSource = FxSpotRateSource.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fixingTime")
        @RuneAttribute(value="fixingTime")
        public BusinessCenterTime.BusinessCenterTimeBuilder getFixingTime() {
            return this.fixingTime;
        }

        @Override
        public BusinessCenterTime.BusinessCenterTimeBuilder getOrCreateFixingTime() {
            BusinessCenterTime.BusinessCenterTimeBuilder result = this.fixingTime != null ? this.fixingTime : (this.fixingTime = BusinessCenterTime.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="determinationMethod")
        @RuneAttribute(value="determinationMethod")
        public CompositeBuilder setDeterminationMethod(DeterminationMethodEnum _determinationMethod) {
            this.determinationMethod = _determinationMethod == null ? null : _determinationMethod;
            return this;
        }

        @Override
        @RosettaAttribute(value="relativeDate")
        @RuneAttribute(value="relativeDate")
        public CompositeBuilder setRelativeDate(RelativeDateOffset _relativeDate) {
            this.relativeDate = _relativeDate == null ? null : _relativeDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fxSpotRateSource")
        @RuneAttribute(value="fxSpotRateSource")
        public CompositeBuilder setFxSpotRateSource(FxSpotRateSource _fxSpotRateSource) {
            this.fxSpotRateSource = _fxSpotRateSource == null ? null : _fxSpotRateSource.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fixingTime")
        @RuneAttribute(value="fixingTime")
        public CompositeBuilder setFixingTime(BusinessCenterTime _fixingTime) {
            this.fixingTime = _fixingTime == null ? null : _fixingTime.toBuilder();
            return this;
        }

        @Override
        public Composite build() {
            return new CompositeImpl(this);
        }

        @Override
        public CompositeBuilder toBuilder() {
            return this;
        }

        @Override
        public CompositeBuilder prune() {
            if (this.relativeDate != null && !this.relativeDate.prune().hasData()) {
                this.relativeDate = null;
            }
            if (this.fxSpotRateSource != null && !this.fxSpotRateSource.prune().hasData()) {
                this.fxSpotRateSource = null;
            }
            if (this.fixingTime != null && !this.fixingTime.prune().hasData()) {
                this.fixingTime = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getDeterminationMethod() != null) {
                return true;
            }
            if (this.getRelativeDate() != null && this.getRelativeDate().hasData()) {
                return true;
            }
            if (this.getFxSpotRateSource() != null && this.getFxSpotRateSource().hasData()) {
                return true;
            }
            return this.getFixingTime() != null && this.getFixingTime().hasData();
        }

        public CompositeBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CompositeBuilder o = (CompositeBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRelativeDate(), (RosettaModelObjectBuilder)o.getRelativeDate(), this::setRelativeDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFxSpotRateSource(), (RosettaModelObjectBuilder)o.getFxSpotRateSource(), this::setFxSpotRateSource);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFixingTime(), (RosettaModelObjectBuilder)o.getFixingTime(), this::setFixingTime);
            merger.mergeBasic((Object)this.getDeterminationMethod(), (Object)o.getDeterminationMethod(), this::setDeterminationMethod, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Composite _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.determinationMethod, (Object)_that.getDeterminationMethod())) {
                return false;
            }
            if (!Objects.equals(this.relativeDate, _that.getRelativeDate())) {
                return false;
            }
            if (!Objects.equals(this.fxSpotRateSource, _that.getFxSpotRateSource())) {
                return false;
            }
            return Objects.equals(this.fixingTime, _that.getFixingTime());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.determinationMethod != null ? ((Object)((Object)this.determinationMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.relativeDate != null ? this.relativeDate.hashCode() : 0);
            _result = 31 * _result + (this.fxSpotRateSource != null ? this.fxSpotRateSource.hashCode() : 0);
            _result = 31 * _result + (this.fixingTime != null ? this.fixingTime.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CompositeBuilder {determinationMethod=" + (Object)((Object)this.determinationMethod) + ", relativeDate=" + this.relativeDate + ", fxSpotRateSource=" + this.fxSpotRateSource + ", fixingTime=" + this.fixingTime + '}';
        }
    }

    public static interface CompositeBuilder
    extends Composite,
    RosettaModelObjectBuilder {
        public RelativeDateOffset.RelativeDateOffsetBuilder getOrCreateRelativeDate();

        @Override
        public RelativeDateOffset.RelativeDateOffsetBuilder getRelativeDate();

        public FxSpotRateSource.FxSpotRateSourceBuilder getOrCreateFxSpotRateSource();

        @Override
        public FxSpotRateSource.FxSpotRateSourceBuilder getFxSpotRateSource();

        public BusinessCenterTime.BusinessCenterTimeBuilder getOrCreateFixingTime();

        @Override
        public BusinessCenterTime.BusinessCenterTimeBuilder getFixingTime();

        public CompositeBuilder setDeterminationMethod(DeterminationMethodEnum var1);

        public CompositeBuilder setRelativeDate(RelativeDateOffset var1);

        public CompositeBuilder setFxSpotRateSource(FxSpotRateSource var1);

        public CompositeBuilder setFixingTime(BusinessCenterTime var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("determinationMethod"), DeterminationMethodEnum.class, (Object)this.getDeterminationMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("relativeDate"), processor, RelativeDateOffset.RelativeDateOffsetBuilder.class, this.getRelativeDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fxSpotRateSource"), processor, FxSpotRateSource.FxSpotRateSourceBuilder.class, this.getFxSpotRateSource(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fixingTime"), processor, BusinessCenterTime.BusinessCenterTimeBuilder.class, this.getFixingTime(), new AttributeMeta[0]);
        }

        public CompositeBuilder prune();
    }

    public static class CompositeImpl
    implements Composite {
        private final DeterminationMethodEnum determinationMethod;
        private final RelativeDateOffset relativeDate;
        private final FxSpotRateSource fxSpotRateSource;
        private final BusinessCenterTime fixingTime;

        protected CompositeImpl(CompositeBuilder builder) {
            this.determinationMethod = builder.getDeterminationMethod();
            this.relativeDate = Optional.ofNullable(builder.getRelativeDate()).map(f -> f.build()).orElse(null);
            this.fxSpotRateSource = Optional.ofNullable(builder.getFxSpotRateSource()).map(f -> f.build()).orElse(null);
            this.fixingTime = Optional.ofNullable(builder.getFixingTime()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="determinationMethod")
        @RuneAttribute(value="determinationMethod")
        public DeterminationMethodEnum getDeterminationMethod() {
            return this.determinationMethod;
        }

        @Override
        @RosettaAttribute(value="relativeDate")
        @RuneAttribute(value="relativeDate")
        public RelativeDateOffset getRelativeDate() {
            return this.relativeDate;
        }

        @Override
        @RosettaAttribute(value="fxSpotRateSource")
        @RuneAttribute(value="fxSpotRateSource")
        public FxSpotRateSource getFxSpotRateSource() {
            return this.fxSpotRateSource;
        }

        @Override
        @RosettaAttribute(value="fixingTime")
        @RuneAttribute(value="fixingTime")
        public BusinessCenterTime getFixingTime() {
            return this.fixingTime;
        }

        @Override
        public Composite build() {
            return this;
        }

        @Override
        public CompositeBuilder toBuilder() {
            CompositeBuilder builder = Composite.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CompositeBuilder builder) {
            Optional.ofNullable(this.getDeterminationMethod()).ifPresent(builder::setDeterminationMethod);
            Optional.ofNullable(this.getRelativeDate()).ifPresent(builder::setRelativeDate);
            Optional.ofNullable(this.getFxSpotRateSource()).ifPresent(builder::setFxSpotRateSource);
            Optional.ofNullable(this.getFixingTime()).ifPresent(builder::setFixingTime);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Composite _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.determinationMethod, (Object)_that.getDeterminationMethod())) {
                return false;
            }
            if (!Objects.equals(this.relativeDate, _that.getRelativeDate())) {
                return false;
            }
            if (!Objects.equals(this.fxSpotRateSource, _that.getFxSpotRateSource())) {
                return false;
            }
            return Objects.equals(this.fixingTime, _that.getFixingTime());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.determinationMethod != null ? ((Object)((Object)this.determinationMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.relativeDate != null ? this.relativeDate.hashCode() : 0);
            _result = 31 * _result + (this.fxSpotRateSource != null ? this.fxSpotRateSource.hashCode() : 0);
            _result = 31 * _result + (this.fixingTime != null ? this.fixingTime.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Composite {determinationMethod=" + (Object)((Object)this.determinationMethod) + ", relativeDate=" + this.relativeDate + ", fxSpotRateSource=" + this.fxSpotRateSource + ", fixingTime=" + this.fixingTime + '}';
        }
    }
}

