/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.processor;

import cdm.product.template.EconomicTerms;
import cdm.product.template.NonTransferableProduct;
import cdm.product.template.Payout;
import com.regnosys.rosetta.common.translation.MappingContext;
import com.regnosys.rosetta.common.translation.MappingProcessor;
import com.regnosys.rosetta.common.translation.Path;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.path.RosettaPath;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class CdsFeeLegPayoutMappingProcessor
extends MappingProcessor {
    public CdsFeeLegPayoutMappingProcessor(RosettaPath modelPath, List<Path> synonymPaths, MappingContext context) {
        super(modelPath, synonymPaths, context);
    }

    public void map(Path creditDefaultSwapSynonymPath, RosettaModelObjectBuilder builder, RosettaModelObjectBuilder parent) {
        Path feeLegSynonymPath = creditDefaultSwapSynonymPath.addElement("feeLeg").addElement("periodicPayment");
        if (this.getMappings().stream().noneMatch(m -> feeLegSynonymPath.nameStartMatches(m.getXmlPath()))) {
            NonTransferableProduct.NonTransferableProductBuilder productBuilder = (NonTransferableProduct.NonTransferableProductBuilder)builder;
            this.removeInterestRatePayout(this.getPayoutBuilders(productBuilder));
        }
    }

    private List<? extends Payout.PayoutBuilder> getPayoutBuilders(NonTransferableProduct.NonTransferableProductBuilder productBuilder) {
        return Optional.ofNullable(productBuilder).map(NonTransferableProduct.NonTransferableProductBuilder::getEconomicTerms).map(EconomicTerms.EconomicTermsBuilder::getPayout).orElse(Collections.emptyList());
    }

    private void removeInterestRatePayout(List<? extends Payout.PayoutBuilder> payoutBuilders) {
        payoutBuilders.forEach(payoutBuilder -> {
            if (payoutBuilder.getInterestRatePayout() != null) {
                payoutBuilder.setInterestRatePayout(null);
            }
        });
    }
}

