/*
 * Decompiled with CFR 0.152.
 */
package cdm.security.lending.functions;

import cdm.base.datetime.AdjustableDate;
import cdm.base.datetime.AdjustableOrRelativeDate;
import cdm.base.math.FinancialUnitEnum;
import cdm.base.math.MeasureBase;
import cdm.base.math.Quantity;
import cdm.base.math.UnitType;
import cdm.base.staticdata.party.PayerReceiver;
import cdm.event.common.BusinessEvent;
import cdm.event.common.CalculateTransferInstruction;
import cdm.event.common.ExecutionInstruction;
import cdm.event.common.Instruction;
import cdm.event.common.PrimitiveInstruction;
import cdm.event.common.ReturnInstruction;
import cdm.event.common.TradeState;
import cdm.event.common.Transfer;
import cdm.event.common.TransferInstruction;
import cdm.event.common.TransferState;
import cdm.event.common.functions.CalculateTransfer;
import cdm.event.common.functions.Create_BusinessEvent;
import cdm.event.common.functions.Create_Return;
import cdm.event.workflow.EventInstruction;
import cdm.product.common.settlement.PayoutBase;
import cdm.product.template.AssetLeg;
import cdm.product.template.AssetPayout;
import cdm.product.template.EconomicTerms;
import cdm.product.template.NonTransferableProduct;
import cdm.product.template.Payout;
import cdm.product.template.TradableProduct;
import com.google.common.collect.Iterables;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.process.PostProcessor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.metafields.FieldWithMetaDate;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class SettlementFunctionHelper {
    @Inject
    Create_Return create_Return;
    @Inject
    CalculateTransfer calculateTransfer;
    @Inject
    PostProcessor postProcessor;
    @Inject
    Create_BusinessEvent create_businessEvent;

    public BusinessEvent createExecution(ExecutionInstruction executionInstruction, Date eventDate) {
        ExecutionInstruction executionInstructionWithRefs = this.postProcess(ExecutionInstruction.class, executionInstruction);
        List<Instruction> instructions = Arrays.asList(Instruction.builder().setPrimitiveInstruction(PrimitiveInstruction.builder().setExecution(executionInstructionWithRefs)).build());
        BusinessEvent businessEvent = this.create_businessEvent.evaluate(instructions, null, eventDate, null);
        return this.postProcess(BusinessEvent.class, businessEvent);
    }

    public BusinessEvent createReturn(TradeState tradeState, ReturnInstruction returnInstruction, Date returnDate) {
        return this.create_Return.evaluate(tradeState, returnInstruction, returnDate);
    }

    public BusinessEvent createTransferBusinessEvent(EventInstruction transferInstruction) {
        BusinessEvent transferBusinessEvent = this.create_businessEvent.evaluate(transferInstruction.getInstruction(), transferInstruction.getIntent(), transferInstruction.getEventDate(), transferInstruction.getEffectiveDate());
        return this.postProcess(BusinessEvent.class, transferBusinessEvent);
    }

    public LocalDate nearSettlementDate(BusinessEvent businessEvent) {
        return this.settlementDate(businessEvent, x -> (AssetLeg)x.get(0));
    }

    public LocalDate farSettlementDate(BusinessEvent businessEvent) {
        return this.settlementDate(businessEvent, Iterables::getLast);
    }

    private LocalDate settlementDate(BusinessEvent businessEvent, Function<List<? extends AssetLeg>, AssetLeg> assetLegSelector) {
        return Optional.ofNullable((Payout)Iterables.getLast(this.getAssetPayouts(businessEvent))).map(Payout::getAssetPayout).map(AssetPayout::getAssetLeg).map(assetLegSelector).map(AssetLeg::getSettlementDate).map(AdjustableOrRelativeDate::getAdjustableDate).map(AdjustableDate::getAdjustedDate).map(FieldWithMetaDate::getValue).map(Date::toLocalDate).orElse(LocalDate.now());
    }

    public EventInstruction createTransferInstruction(BusinessEvent executionBusinessEvent, LocalDate transferDate) {
        Payout payout = (Payout)Iterables.getLast(this.getAssetPayouts(executionBusinessEvent));
        TradeState before = this.getAfterState(executionBusinessEvent).orElse(null);
        CalculateTransferInstruction calculateTransferInstruction = CalculateTransferInstruction.builder().setTradeState(before).setPayoutValue(payout).setPayerReceiver(this.getPayerReceiver(payout).orElse(null)).setDate(Date.of((LocalDate)transferDate)).build();
        List<? extends Transfer> transfers = this.calculateTransfer.evaluate(calculateTransferInstruction);
        return this.createTransferInstruction(transfers, transferDate, before);
    }

    public EventInstruction createReturnTransferInstruction(BusinessEvent executionBusinessEvent, List<? extends Quantity> quantities, LocalDate transferDate) {
        Payout payout = (Payout)Iterables.getLast(this.getAssetPayouts(executionBusinessEvent));
        Quantity shareQuantity = this.getShareQuantity(quantities);
        TradeState before = this.getAfterState(executionBusinessEvent).orElse(null);
        CalculateTransferInstruction calculateTransferInstruction = CalculateTransferInstruction.builder().setTradeState(before).setPayoutValue(payout).setPayerReceiver(this.getReturnPayerReceiver(payout).orElse(null)).setQuantity(shareQuantity).setDate(Date.of((LocalDate)transferDate)).build();
        List<? extends Transfer> transfers = this.calculateTransfer.evaluate(calculateTransferInstruction);
        return this.createTransferInstruction(transfers, transferDate, before);
    }

    private EventInstruction createTransferInstruction(List<? extends Transfer> transfers, LocalDate transferDate, TradeState before) {
        List transferStates = transfers.stream().map(t -> TransferState.builder().setTransfer((Transfer)t).build()).collect(Collectors.toList());
        return EventInstruction.builder().addInstruction(Instruction.builder().setBeforeValue(before).setPrimitiveInstruction(PrimitiveInstruction.builder().setTransfer(TransferInstruction.builder().setTransferState(transferStates)))).setEventDate(Date.of((LocalDate)transferDate));
    }

    private Quantity getShareQuantity(List<? extends Quantity> quantities) {
        List quantitiesO = quantities.stream().filter(q -> Optional.ofNullable(q).map(MeasureBase::getUnit).map(UnitType::getFinancialUnit).filter(u -> u == FinancialUnitEnum.SHARE).isPresent()).collect(Collectors.toList());
        return (Quantity)Iterables.getLast(quantitiesO);
    }

    private Optional<PayerReceiver> getPayerReceiver(Payout payout) {
        return Optional.ofNullable(payout).map(Payout::getAssetPayout).map(PayoutBase::getPayerReceiver);
    }

    private Optional<PayerReceiver> getReturnPayerReceiver(Payout payout) {
        return this.getPayerReceiver(payout).map(this::invert);
    }

    private PayerReceiver invert(PayerReceiver payerReceiver) {
        return payerReceiver.toBuilder().setPayer(payerReceiver.getReceiver()).setReceiver(payerReceiver.getPayer()).build();
    }

    private List<? extends Payout> getPayouts(BusinessEvent executionBusinessEvent) {
        return this.getAfterState(executionBusinessEvent).map(TradeState::getTrade).map(TradableProduct::getProduct).map(NonTransferableProduct::getEconomicTerms).map(EconomicTerms::getPayout).orElse(Collections.emptyList());
    }

    private List<? extends Payout> getAssetPayouts(BusinessEvent executionBusinessEvent) {
        return this.getPayouts(executionBusinessEvent).stream().filter(p -> p.getAssetPayout() != null).collect(Collectors.toList());
    }

    private Optional<TradeState> getAfterState(BusinessEvent executionBusinessEvent) {
        return Optional.of(executionBusinessEvent).map(BusinessEvent::getAfter).map(Iterables::getLast);
    }

    private <T extends RosettaModelObject> T postProcess(Class<T> modelType, T modelObject) {
        return (T)((RosettaModelObject)modelType.cast(this.postProcessor.postProcess(modelType, modelObject.toBuilder().prune()).build()));
    }
}

