# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
import sys
import datetime
import inspect
from decimal import Decimal
from rosetta.runtime.utils import *
from rosetta.runtime.func_proxy import replaceable, create_module_attr_guardian
from cdm.base.datetime.functions.ResolveAdjustableDate import ResolveAdjustableDate
from cdm.base.datetime.functions.ResolveAdjustableDates import ResolveAdjustableDates
from cdm.observable.asset.ValuationDates import ValuationDates

__all__ = ['AdjustedValuationDates']


@replaceable
def AdjustedValuationDates(valuationDates: ValuationDates) -> datetime.date:
    """
    
    Parameters 
    ----------
    valuationDates : ValuationDates
    
    Returns
    -------
    adjustedValuationDates : date
    
    """
    self = inspect.currentframe()
    
    
    adjustedValuationDates =  sorted([ResolveAdjustableDates(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "valuationDates"), "interimValuationDate"), "valuationDates")), ResolveAdjustableDate(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "valuationDates"), "finalValuationDate"), "valuationDate"))])
    
    
    return adjustedValuationDates

sys.modules[__name__].__class__ = create_module_attr_guardian(sys.modules[__name__].__class__)
