# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
import sys
import datetime
import inspect
from decimal import Decimal
from rosetta.runtime.utils import *
from rosetta.runtime.func_proxy import replaceable, create_module_attr_guardian
from cdm.base.staticdata.party.PartyReferencePayerReceiver import PartyReferencePayerReceiver
from cdm.base.math.NonNegativeQuantity import NonNegativeQuantity
from cdm.base.staticdata.party.functions.ExtractCounterpartyByRole import ExtractCounterpartyByRole
from cdm.base.staticdata.asset.common.Cash import Cash
from cdm.event.common.TransferState import TransferState
from cdm.observable.asset.Money import Money
from cdm.base.staticdata.asset.common.Asset import Asset
from cdm.event.common.PrimitiveInstruction import PrimitiveInstruction
from cdm.event.common.TransferExpression import TransferExpression
from cdm.event.common.TransferInstruction import TransferInstruction
from cdm.event.common.TradeState import TradeState
from cdm.product.common.settlement.SettlementDate import SettlementDate
from cdm.event.common.Transfer import Transfer
from cdm.base.staticdata.asset.common.AssetIdentifier import AssetIdentifier
from cdm.event.common.ScheduledTransfer import ScheduledTransfer

__all__ = ['Create_OnDemandInterestPaymentPrimitiveInstruction']


@replaceable
def Create_OnDemandInterestPaymentPrimitiveInstruction(tradeState: TradeState, interestAmount: Money, settlementDate: SettlementDate) -> PrimitiveInstruction:
    """
    An instruction to make a interium interest payment by adding a payout leg to the deal.
    
    Parameters 
    ----------
    tradeState : TradeState
    The original trade to be modified.
    
    interestAmount : Money
    
    settlementDate : SettlementDate
    
    Returns
    -------
    instruction : PrimitiveInstruction
    
    """
    _pre_registry = {}
    self = inspect.currentframe()
    
    # conditions
    
    @rosetta_local_condition(_pre_registry)
    def condition_0_InterestRatePayoutExists(self):
        """
        Only a contractual product with a single interest rate payout can have an on-demand interest payment.
        """
        return rosetta_attr_exists(rosetta_resolve_attr(self, "interestRatePayout"))
    
    @rosetta_local_condition(_pre_registry)
    def condition_1_Currency(self):
        """
        The currency of the interest amount must match the currency of the original interest rate payout.
        """
        return all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "interestAmount"), "unit"), "currency"), "=", rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "interestRatePayout"), "priceQuantity"), "quantitySchedule"), "unit"), "currency"))
    
    @rosetta_local_condition(_pre_registry)
    def condition_2_SettlementDate(self):
        """
        The settlement date must be specified as an adjustable or relative date.
        """
        return rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "settlementDate"), "adjustableOrRelativeDate"))
    # Execute all registered conditions
    execute_local_conditions(_pre_registry, 'Pre-condition')
    
    interestRatePayout = get_only_element(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "tradeState"), "trade"), "product"), "economicTerms"), "payout"), "InterestRatePayout"))
    payerReceiver = PartyReferencePayerReceiver(payerPartyReference=rosetta_resolve_attr(ExtractCounterpartyByRole(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "tradeState"), "trade"), "counterparty"), rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "interestRatePayout"), "payerReceiver"), "payer")), "partyReference"), receiverPartyReference=rosetta_resolve_attr(ExtractCounterpartyByRole(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "tradeState"), "trade"), "counterparty"), rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "interestRatePayout"), "payerReceiver"), "receiver")), "partyReference"))
    transfer = Transfer(quantity=NonNegativeQuantity(value=rosetta_resolve_attr(rosetta_resolve_attr(self, "interestAmount"), "value"), unit=rosetta_resolve_attr(rosetta_resolve_attr(self, "interestAmount"), "unit")), asset=Asset(Cash=Cash(identifier=AssetIdentifier(identifier=rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "interestAmount"), "unit"), "currency"), identifierType=CurrencyCode))), settlementDate=rosetta_resolve_attr(rosetta_resolve_attr(self, "settlementDate"), "adjustableOrRelativeDate"), payerReceiver=rosetta_resolve_attr(self, "payerReceiver"), transferExpression=TransferExpression(scheduledTransfer=ScheduledTransfer(transferType=NetInterest)))
    instruction =  PrimitiveInstruction(transfer=TransferInstruction(transferState=TransferState(transfer=rosetta_resolve_attr(self, "transfer"))))
    
    
    return instruction

sys.modules[__name__].__class__ = create_module_attr_guardian(sys.modules[__name__].__class__)
