# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
import sys
import datetime
import inspect
from decimal import Decimal
from rosetta.runtime.utils import *
from rosetta.runtime.func_proxy import replaceable, create_module_attr_guardian
from cdm.base.math.FinancialUnitEnum import FinancialUnitEnum
from cdm.event.common.Reset import Reset
from cdm.base.staticdata.party.functions.ExtractCounterpartyByRole import ExtractCounterpartyByRole
from cdm.product.asset.functions.FloatingAmount import FloatingAmount
from cdm.event.common.TradeState import TradeState
from cdm.base.math.functions.FilterQuantityByFinancialUnit import FilterQuantityByFinancialUnit
from cdm.event.common.Transfer import Transfer
from cdm.product.asset.functions.FixedAmount import FixedAmount
from cdm.product.common.schedule.functions.CalculationPeriodRange import CalculationPeriodRange

__all__ = ['ResolveSecurityFinanceBillingAmount']


@replaceable
def ResolveSecurityFinanceBillingAmount(tradeState: TradeState, reset: Reset, recordStartDate: datetime.date, recordEndDate: datetime.date, transferDate: datetime.date) -> Transfer:
    """
    Calculates the billing amount for a Security Finance transaction.
    
    Parameters 
    ----------
    tradeState : TradeState
    
    reset : Reset
    
    recordStartDate : date
    
    recordEndDate : date
    
    transferDate : date
    
    Returns
    -------
    transfer : Transfer
    
    """
    self = inspect.currentframe()
    
    
    def _then_fn1():
        return rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(get_only_element(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "collateral"), "collateralProvisions"), "eligibleCollateral")), "treatment"), "valuationTreatment"), "marginPercentage")
    
    def _else_fn1():
        return 1.0
    
    def _then_fn0():
        return rosetta_resolve_attr(self, "valuationPercentage")
    
    def _else_fn0():
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(get_only_element(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "collateral"), "collateralProvisions"), "eligibleCollateral")), "treatment"), "valuationTreatment"), "marginPercentage")), _then_fn1, _else_fn1)
    
    def _then_fn2():
        return FloatingAmount(rosetta_resolve_attr(self, "interestRatePayout"), rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "reset"), "resetValue"), "value"), rosetta_resolve_attr(self, "billingQuantity"), rosetta_resolve_attr(self, "recordEndDate"), rosetta_resolve_attr(self, "calculationPeriodRange"))
    
    def _else_fn2():
        return True
    
    def _then_fn1():
        return FixedAmount(rosetta_resolve_attr(self, "interestRatePayout"), rosetta_resolve_attr(self, "billingQuantity"), rosetta_resolve_attr(self, "recordEndDate"), rosetta_resolve_attr(self, "calculationPeriodRange"))
    
    def _else_fn1():
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "interestRatePayout"), "rateSpecification"), "FloatingRateSpecification")), _then_fn2, _else_fn2)
    
    def _then_fn2():
        return rosetta_resolve_attr(self, "payerPartyReference")
    
    def _else_fn2():
        return rosetta_resolve_attr(self, "receiverPartyReference")
    
    def _then_fn3():
        return rosetta_resolve_attr(self, "receiverPartyReference")
    
    def _else_fn3():
        return rosetta_resolve_attr(self, "payerPartyReference")
    
    securityQuantity = get_only_element(FilterQuantityByFinancialUnit(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "tradeState"), "trade"), "tradeLot"), "priceQuantity"), "quantity"), rosetta_resolve_attr(FinancialUnitEnum, "SHARE")))
    interestRatePayout = get_only_element(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "tradeState"), "trade"), "product"), "economicTerms"), "payout"), "InterestRatePayout"))
    assetPayout = get_only_element(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_deep_attr(self, "economicTerms"), "payout"), "AssetPayout"))
    collateral = rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "tradeState"), "trade"), "product"), "economicTerms"), "collateral")
    haircutPercentage = (1.0 - rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(get_only_element(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "collateral"), "collateralProvisions"), "eligibleCollateral")), "treatment"), "valuationTreatment"), "haircutPercentage"))
    valuationPercentage = (1 / rosetta_resolve_attr(self, "haircutPercentage"))
    marginRatio = if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(get_only_element(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "collateral"), "collateralProvisions"), "eligibleCollateral")), "treatment"), "valuationTreatment"), "haircutPercentage")), _then_fn0, _else_fn0)
    billingQuantity = ((rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "reset"), "resetValue"), "value") * rosetta_resolve_attr(rosetta_resolve_attr(self, "securityQuantity"), "value")) * rosetta_resolve_attr(self, "marginRatio"))
    calculationPeriodRange = CalculationPeriodRange(rosetta_resolve_attr(self, "recordStartDate"), rosetta_resolve_attr(self, "recordEndDate"), [])
    performance = if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "interestRatePayout"), "rateSpecification"), "FixedRateSpecification")), _then_fn1, _else_fn1)
    payerPartyReference = rosetta_resolve_attr(ExtractCounterpartyByRole(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "tradeState"), "trade"), "counterparty"), rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "interestRatePayout"), "payerReceiver"), "payer")), "partyReference")
    receiverPartyReference = rosetta_resolve_attr(ExtractCounterpartyByRole(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "tradeState"), "trade"), "counterparty"), rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "interestRatePayout"), "payerReceiver"), "receiver")), "partyReference")
    transfer = _get_rosetta_object('Transfer', 'quantity', _get_rosetta_object('NonNegativeQuantity', 'value', rosetta_resolve_attr(self, "performance")))
    transfer = set_rosetta_attr(rosetta_resolve_attr(self, 'transfer'), 'quantity->unit->currency', rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "interestRatePayout"), "priceQuantity"), "quantitySchedule"), "unit"), "currency"))
    transfer = set_rosetta_attr(rosetta_resolve_attr(self, 'transfer'), 'payerReceiver->payerPartyReference', if_cond_fn(all_elements(rosetta_resolve_attr(self, "performance"), ">=", 0), _then_fn0, _else_fn0))
    transfer = set_rosetta_attr(rosetta_resolve_attr(self, 'transfer'), 'payerReceiver->receiverPartyReference', if_cond_fn(all_elements(rosetta_resolve_attr(self, "performance"), ">=", 0), _then_fn1, _else_fn1))
    transfer = set_rosetta_attr(rosetta_resolve_attr(self, 'transfer'), 'settlementDate->adjustedDate', rosetta_resolve_attr(self, "transferDate"))
    
    
    return transfer

sys.modules[__name__].__class__ = create_module_attr_guardian(sys.modules[__name__].__class__)
