# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
import sys
import datetime
import inspect
from decimal import Decimal
from rosetta.runtime.utils import *
from rosetta.runtime.func_proxy import replaceable, create_module_attr_guardian
from cdm.base.math.FinancialUnitEnum import FinancialUnitEnum
from cdm.base.staticdata.party.functions.ExtractCounterpartyByRole import ExtractCounterpartyByRole
from cdm.event.common.TradeState import TradeState
from cdm.base.math.functions.FilterQuantityByFinancialUnit import FilterQuantityByFinancialUnit
from cdm.event.common.Transfer import Transfer
from cdm.observable.asset.functions.FilterPrice import FilterPrice
from cdm.base.math.Quantity import Quantity
from cdm.observable.asset.PriceTypeEnum import PriceTypeEnum
from cdm.base.staticdata.party.PayerReceiver import PayerReceiver

__all__ = ['SecurityFinanceCashSettlementAmount']


@replaceable
def SecurityFinanceCashSettlementAmount(tradeState: TradeState, date: datetime.date, quantity: Quantity | None, payerReceiver: PayerReceiver | None) -> Transfer:
    """
    
    Parameters 
    ----------
    tradeState : TradeState
    
    date : date
    
    quantity : Quantity
    Specifies quantity amount returned if not the full amount from the TradeState, e.g. partial return
    
    payerReceiver : PayerReceiver
    
    Returns
    -------
    cashSettlementAmount : Transfer
    
    """
    _pre_registry = {}
    self = inspect.currentframe()
    
    # conditions
    
    @rosetta_local_condition(_pre_registry)
    def condition_0_ShareUnitExists(self):
        def _then_fn0():
            return all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "quantity"), "unit"), "financialUnit"), "=", rosetta_resolve_attr(FinancialUnitEnum, "SHARE"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(self, "quantity")), _then_fn0, _else_fn0)
    
    @rosetta_local_condition(_pre_registry)
    def condition_1_IdentifiersMatch(self):
        return all_elements(rosetta_resolve_deep_attr(self, "identifier"), "=", rosetta_resolve_deep_attr(self, "identifier"))
    # Execute all registered conditions
    execute_local_conditions(_pre_registry, 'Pre-condition')
    
    def _then_fn0():
        return rosetta_resolve_attr(self, "quantity")
    
    def _else_fn0():
        return get_only_element(FilterQuantityByFinancialUnit(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "tradeState"), "trade"), "tradeLot"), "priceQuantity"), "quantity"), rosetta_resolve_attr(FinancialUnitEnum, "SHARE")))
    
    def _then_fn2():
        return rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(get_only_element(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "collateral"), "collateralProvisions"), "eligibleCollateral")), "treatment"), "valuationTreatment"), "marginPercentage")
    
    def _else_fn2():
        return 1.0
    
    def _then_fn1():
        return (1 / (1.0 - rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(get_only_element(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "collateral"), "collateralProvisions"), "eligibleCollateral")), "treatment"), "valuationTreatment"), "haircutPercentage")))
    
    def _else_fn1():
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(get_only_element(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "collateral"), "collateralProvisions"), "eligibleCollateral")), "treatment"), "valuationTreatment"), "marginPercentage")), _then_fn2, _else_fn2)
    
    def _then_fn3():
        return rosetta_resolve_attr(ExtractCounterpartyByRole(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "tradeState"), "trade"), "counterparty"), rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "assetPayout"), "payerReceiver"), "receiver")), "partyReference")
    
    def _else_fn3():
        return True
    
    def _then_fn2():
        return rosetta_resolve_attr(ExtractCounterpartyByRole(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "tradeState"), "trade"), "counterparty"), rosetta_resolve_attr(rosetta_resolve_attr(self, "payerReceiver"), "receiver")), "partyReference")
    
    def _else_fn2():
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "assetPayout"), "payerReceiver"), "receiver")), _then_fn3, _else_fn3)
    
    def _then_fn4():
        return rosetta_resolve_attr(ExtractCounterpartyByRole(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "tradeState"), "trade"), "counterparty"), rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "assetPayout"), "payerReceiver"), "payer")), "partyReference")
    
    def _else_fn4():
        return True
    
    def _then_fn3():
        return rosetta_resolve_attr(ExtractCounterpartyByRole(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "tradeState"), "trade"), "counterparty"), rosetta_resolve_attr(rosetta_resolve_attr(self, "payerReceiver"), "payer")), "partyReference")
    
    def _else_fn3():
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "assetPayout"), "payerReceiver"), "payer")), _then_fn4, _else_fn4)
    
    payout = (lambda item: get_only_element(item))(rosetta_filter(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "tradeState"), "trade"), "product"), "economicTerms"), "payout"), lambda item: rosetta_attr_exists(rosetta_resolve_attr(item, "AssetPayout"))))
    assetPayout = rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "AssetPayout")
    collateral = rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "tradeState"), "trade"), "product"), "economicTerms"), "collateral")
    securityQuantity = if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(self, "quantity")), _then_fn0, _else_fn0)
    securityPrice = FilterPrice(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "tradeState"), "trade"), "tradeLot"), "priceQuantity"), "price"), rosetta_resolve_attr(PriceTypeEnum, "ASSET_PRICE"), [], [])
    marginRatio = if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(get_only_element(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "collateral"), "collateralProvisions"), "eligibleCollateral")), "treatment"), "valuationTreatment"), "haircutPercentage")), _then_fn1, _else_fn1)
    cashSettlementAmount = _get_rosetta_object('Transfer', 'quantity', _get_rosetta_object('NonNegativeQuantity', 'value', ((rosetta_resolve_attr(rosetta_resolve_attr(self, "securityPrice"), "value") * rosetta_resolve_attr(rosetta_resolve_attr(self, "securityQuantity"), "value")) * rosetta_resolve_attr(self, "marginRatio"))))
    cashSettlementAmount = set_rosetta_attr(rosetta_resolve_attr(self, 'cashSettlementAmount'), 'quantity->unit->currency', rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "securityPrice"), "unit"), "currency"))
    cashSettlementAmount = set_rosetta_attr(rosetta_resolve_attr(self, 'cashSettlementAmount'), 'payerReceiver->payerPartyReference', if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(self, "payerReceiver")), _then_fn2, _else_fn2))
    cashSettlementAmount = set_rosetta_attr(rosetta_resolve_attr(self, 'cashSettlementAmount'), 'payerReceiver->receiverPartyReference', if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(self, "payerReceiver")), _then_fn3, _else_fn3))
    cashSettlementAmount = set_rosetta_attr(rosetta_resolve_attr(self, 'cashSettlementAmount'), 'settlementDate->adjustedDate', rosetta_resolve_attr(self, "date"))
    cashSettlementAmount = set_rosetta_attr(rosetta_resolve_attr(self, 'cashSettlementAmount'), 'settlementOrigin', {rosetta_resolve_attr(self, "payout"): True})
    
    
    return cashSettlementAmount

sys.modules[__name__].__class__ = create_module_attr_guardian(sys.modules[__name__].__class__)
