# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['AccessConditions']


class AccessConditions(BaseDataClass):
    """
    A class to specify each party's election with respect to the Termination Events that will be deemed an Access Condition (Initial Margin CSA) or a Specified Condition (Variation Margin CSA).
    """
    partyElection: List[cdm.legaldocumentation.csa.AccessConditionsElections.AccessConditionsElections] = Field([], description="The parties' Access Condition (Initial Margin CSA) or a Specified Condition (Variation Margin CSA) election.")
    """
    The parties' Access Condition (Initial Margin CSA) or a Specified Condition (Variation Margin CSA) election.
    """
    @rosetta_condition
    def cardinality_partyElection(self):
        return check_cardinality(self.partyElection, 2, None)
    
    additionalTerminationEvent: List[cdm.legaldocumentation.csa.AdditionalTerminationEvent.AdditionalTerminationEvent] = Field([], description="Additional Termination Events applicable to the agreement.")
    """
    Additional Termination Events applicable to the agreement.
    """

import cdm 
import cdm.legaldocumentation.csa.AccessConditionsElections
import cdm.legaldocumentation.csa.AdditionalTerminationEvent
