# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['AdditionalTerminationEvent']


class AdditionalTerminationEvent(BaseDataClass):
    """
    A class to specify an optional termination event, additional to the Termination Events that will be deemed an Access Condition (Initial Margin CSA) or a Specified Condition (Variation Margin CSA).
    """
    name: str = Field(..., description="The name of the additional termination event.")
    """
    The name of the additional termination event.
    """
    applicableParty: List[cdm.base.staticdata.party.CounterpartyRoleEnum.CounterpartyRoleEnum] = Field([], description="Whether the additional termination event is applicable for the relevant party.")
    """
    Whether the additional termination event is applicable for the relevant party.
    """
    @rosetta_condition
    def cardinality_applicableParty(self):
        return check_cardinality(self.applicableParty, 1, None)
    

import cdm 
import cdm.base.staticdata.party.CounterpartyRoleEnum
