# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['CreditSupportDocument']


class CreditSupportDocument(BaseDataClass):
    """
    Identification of party specific Credit Support Documents applicable to the document.
    """
    creditSupportDocumentElection: List[cdm.legaldocumentation.csa.CreditSupportDocumentElection.CreditSupportDocumentElection] = Field([], description="The party election of Credit Support Document(s), if any.")
    """
    The party election of Credit Support Document(s), if any.
    """
    @rosetta_condition
    def cardinality_creditSupportDocumentElection(self):
        return check_cardinality(self.creditSupportDocumentElection, 2, None)
    

import cdm 
import cdm.legaldocumentation.csa.CreditSupportDocumentElection
