# pylint: disable=missing-module-docstring, invalid-name, line-too-long
from enum import Enum

__all__ = ['ElectiveAmountEnum']

class ElectiveAmountEnum(Enum):
    """
    The enumerated values to specify an elective amount.
    """
    UNLIMITED = "Unlimited"
    """
    The elective amount has no upper limit.
    """
    ZERO = "Zero"
    """
    The elective amount is zero.
    """
