# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['PartyAgreementIdentifier']


class PartyAgreementIdentifier(BaseDataClass):
    """
    A class defining a legal agreement identifier issued by the indicated party.
    """
    partyReference: AttributeWithReference | cdm.base.staticdata.party.Party.Party = Field(..., description="Party that issued the document identifier.")
    """
    Party that issued the document identifier.
    """
    documentIdentifier: List[AttributeWithMeta[cdm.base.staticdata.identifier.Identifier.Identifier] | cdm.base.staticdata.identifier.Identifier.Identifier] = Field([], description="While FpML specifies the document identifier with a value and an associated scheme, the CDM makes use of the Identifier, which has an explicit issuer. The issuer of this identifier is not necessarily the same as the party reference.")
    """
    While FpML specifies the document identifier with a value and an associated scheme, the CDM makes use of the Identifier, which has an explicit issuer. The issuer of this identifier is not necessarily the same as the party reference.
    """
    @rosetta_condition
    def cardinality_documentIdentifier(self):
        return check_cardinality(self.documentIdentifier, 1, None)
    

import cdm 
import cdm.base.staticdata.party.Party
import cdm.base.staticdata.identifier.Identifier
