# pylint: disable=missing-module-docstring, invalid-name, line-too-long
from enum import Enum

__all__ = ['SecurityInterestObligeeEnum']

class SecurityInterestObligeeEnum(Enum):
    """
    The enumerated values applicable for Security Interest for Obligations Obligee.
    """
    OTHER = "Other"
    """
    Utilised where the clause data structure is not able to capture a material aspect of the clause.
    """
    PARTY_A = "PartyA"
    """
    Party A.
    """
    PARTY_A_OR_AFFILIATE = "Party A or any Affiliate of Party A"
    """
    Party A or any Affiliate of Party A.
    """
    PARTY_B = "PartyB"
    """
    Party B.
    """
    PARTY_B_OR_AFFILIATE = "Party B or any Affiliate of Party B"
    """
    Party B or any Affiliate of Party B.
    """
