# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['SecurityProviderRightsEvent']


class SecurityProviderRightsEvent(BaseDataClass):
    """
    A class to specify the Pledgor/Obligor/Chargor Rights Event election.
    """
    partyElection: List[cdm.legaldocumentation.csa.SecurityProviderRightsEventElection.SecurityProviderRightsEventElection] = Field([], description="")
    includeCoolingOffLanguage: bool = Field(..., description="The Pledgor/Obligor/Chargor Rights Event election includes cooling off language when the attribute is set of True.")
    """
    The Pledgor/Obligor/Chargor Rights Event election includes cooling off language when the attribute is set of True.
    """
    fullDischarge: Optional[bool] = Field(None, description="If specified as applicable here, a Pledgor/Obligor/Chargor Rights Event will not occur unless the Pledgor/Obligor/Chargor (A) has provided a statement to the Secured Party in respect of such Early Termination Date.")
    """
    If specified as applicable here, a Pledgor/Obligor/Chargor Rights Event will not occur unless the Pledgor/Obligor/Chargor (A) has provided a statement to the Secured Party in respect of such Early Termination Date.
    """
    automaticSetOff: Optional[bool] = Field(None, description="The Automatic Set-Off provision applies when the value is set to True.")
    """
    The Automatic Set-Off provision applies when the value is set to True.
    """
    customElection: Optional[str] = Field(None, description="A custom Pledgor/Obligor/Chargor Rights Event election might be specified by the parties.")
    """
    A custom Pledgor/Obligor/Chargor Rights Event election might be specified by the parties.
    """
    
    @rosetta_condition
    def condition_0_RightsEvent_includeCoolingOffLanguage(self):
        """
        A data rule to enforce that, when the Rights Event election includes cooling off language, no custom election should be specified.
        """
        item = self
        def _then_fn0():
            return (not rosetta_attr_exists(rosetta_resolve_attr(self, "customElection")))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "includeCoolingOffLanguage"), "=", True), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_1_RightsEvent_customElection(self):
        """
        A data rule to enforce that, when the Rights Event is specified through a custom election, no standard cooling off language should be specified.
        """
        item = self
        def _then_fn0():
            return all_elements(rosetta_resolve_attr(self, "includeCoolingOffLanguage"), "=", False)
        
        def _else_fn0():
            return True
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(self, "customElection")), _then_fn0, _else_fn0)

import cdm 
import cdm.legaldocumentation.csa.SecurityProviderRightsEventElection
