# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['TerminationCurrencyAmendment']


class TerminationCurrencyAmendment(BaseDataClass):
    """
    A class to specify the Amendment to Termination Currency elections by the parties to the agreement.
    """
    isApplicable: bool = Field(..., description="The qualification of whether the Amendment to Termination Currency is deemed applicable by the parties (True) or not (False).")
    """
    The qualification of whether the Amendment to Termination Currency is deemed applicable by the parties (True) or not (False).
    """
    effectiveDate: Optional[cdm.legaldocumentation.csa.AmendmentEffectiveDate.AmendmentEffectiveDate] = Field(None, description="The effective date of the Amendment to Termination Currency. This date can be specified as either an actual date, a specific date (e.g. the annex date) or as a custom provision.")
    """
    The effective date of the Amendment to Termination Currency. This date can be specified as either an actual date, a specific date (e.g. the annex date) or as a custom provision.
    """
    partyElection: List[cdm.legaldocumentation.csa.TerminationCurrencyElection.TerminationCurrencyElection] = Field([], description="The parties' Amendment Currency election.")
    """
    The parties' Amendment Currency election.
    """
    
    @rosetta_condition
    def condition_0_Applicability(self):
        """
        The Amendment to Termination Currency elections only apply when the Amendment to Termination Currency is deemed applicable by the parties.
        """
        item = self
        def _then_fn0():
            return ((not rosetta_attr_exists(rosetta_resolve_attr(self, "effectiveDate"))) and (not rosetta_attr_exists(rosetta_resolve_attr(self, "partyElection"))))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "isApplicable"), "=", False), _then_fn0, _else_fn0)

import cdm 
import cdm.legaldocumentation.csa.AmendmentEffectiveDate
import cdm.legaldocumentation.csa.TerminationCurrencyElection
