# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['ThresholdRatingsBased']


class ThresholdRatingsBased(BaseDataClass):
    """
    Defines that the Threshold is based on Ratings condition(s).
    """
    party: cdm.base.staticdata.party.CounterpartyRoleEnum.CounterpartyRoleEnum = Field(..., description="The party to which the threshold applies.")
    """
    The party to which the threshold applies.
    """
    currency: cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum.ISOCurrencyCodeEnum = Field(..., description="The threshold currency code.")
    """
    The threshold currency code.
    """
    ratingType: cdm.legaldocumentation.csa.RatingTypeEnum.RatingTypeEnum = Field(..., description="The relevant rating type.")
    """
    The relevant rating type.
    """
    variableSet: List[cdm.legaldocumentation.csa.CSAThresholdVariableSet.CSAThresholdVariableSet] = Field([], description="Defines a combination of Rating Agency, Rating Value, Threshold amount and Currency code.")
    """
    Defines a combination of Rating Agency, Rating Value, Threshold amount and Currency code.
    """
    ratedParty: Optional[cdm.legaldocumentation.csa.ThresholdRatedPartyEnum.ThresholdRatedPartyEnum] = Field(None, description="The party to which a rating applies.")
    """
    The party to which a rating applies.
    """
    namedEntity: Optional[str] = Field(None, description="Details the Named Entity where the Rated Party is Named Entity.")
    """
    Details the Named Entity where the Rated Party is Named Entity.
    """
    namedAffiliate: Optional[str] = Field(None, description="Details the Named Affiliate where the Rated Party is Named Affiliate.")
    """
    Details the Named Affiliate where the Rated Party is Named Affiliate.
    """
    compare: Optional[cdm.observable.asset.CreditNotationMismatchResolutionEnum.CreditNotationMismatchResolutionEnum] = Field(None, description="Where two ratings are specified whether the higher or lower rating prevails.")
    """
    Where two ratings are specified whether the higher or lower rating prevails.
    """
    noRating: bool = Field(..., description="What conditions apply where a party has no rating.")
    """
    What conditions apply where a party has no rating.
    """
    notRatedBy: Optional[cdm.legaldocumentation.csa.NotRatedByEnum.NotRatedByEnum] = Field(None, description="Defines where conditions apply if no Rating where ratings may not exist.")
    """
    Defines where conditions apply if no Rating where ratings may not exist.
    """
    numberOfRatingAgencies: Optional[cdm.legaldocumentation.csa.NumberOfRatingAgenciesEnum.NumberOfRatingAgenciesEnum] = Field(None, description="Defines the number of Rating Agencies that the Party must be rated by.")
    """
    Defines the number of Rating Agencies that the Party must be rated by.
    """
    zeroEvent: bool = Field(..., description="Whether a trigger applies for the threshold to fall to zero.")
    """
    Whether a trigger applies for the threshold to fall to zero.
    """
    event: List[cdm.legaldocumentation.csa.ThresholdZeroEventEnum.ThresholdZeroEventEnum] = Field([], description="The relevant trigger for the threshold to fall to zero.")
    """
    The relevant trigger for the threshold to fall to zero.
    """

import cdm 
import cdm.base.staticdata.party.CounterpartyRoleEnum
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum
import cdm.legaldocumentation.csa.RatingTypeEnum
import cdm.legaldocumentation.csa.CSAThresholdVariableSet
import cdm.legaldocumentation.csa.ThresholdRatedPartyEnum
import cdm.observable.asset.CreditNotationMismatchResolutionEnum
import cdm.legaldocumentation.csa.NotRatedByEnum
import cdm.legaldocumentation.csa.NumberOfRatingAgenciesEnum
import cdm.legaldocumentation.csa.ThresholdZeroEventEnum
