# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
import sys
import datetime
import inspect
from decimal import Decimal
from rosetta.runtime.utils import *
from rosetta.runtime.func_proxy import replaceable, create_module_attr_guardian
from cdm.observable.asset.Money import Money
from cdm.legaldocumentation.csa.functions.CreditSupportAmount import CreditSupportAmount
from cdm.base.math.functions.Max import Max
from cdm.legaldocumentation.csa.CollateralRounding import CollateralRounding
from cdm.base.math.functions.RoundToNearest import RoundToNearest
from cdm.legaldocumentation.csa.MarginApproachEnum import MarginApproachEnum
from cdm.legaldocumentation.csa.functions.UndisputedAdjustedPostedCreditSupportAmount import UndisputedAdjustedPostedCreditSupportAmount
from cdm.base.math.RoundingModeEnum import RoundingModeEnum
from cdm.legaldocumentation.csa.PostedCreditSupportItem import PostedCreditSupportItem

__all__ = ['DeliveryAmount']


@replaceable
def DeliveryAmount(postedCreditSupportItems: list[PostedCreditSupportItem] | None, priorDeliveryAmountAdjustment: Money, priorReturnAmountAdjustment: Money, disputedTransferredPostedCreditSupportAmount: Money, marginAmount: Money, threshold: Money, marginApproach: MarginApproachEnum, marginAmountIA: Money | None, minimumTransferAmount: Money, rounding: CollateralRounding, disputedDeliveryAmount: Money, baseCurrency: str) -> Money:
    """
    
    Parameters 
    ----------
    postedCreditSupportItems : PostedCreditSupportItem
    
    priorDeliveryAmountAdjustment : Money
    The adjustment value to include any prior Delivery Amount (IM).
    
    priorReturnAmountAdjustment : Money
    The adjustment value to exclude any prior Return Amount (IM).
    
    disputedTransferredPostedCreditSupportAmount : Money
    The disputed value of any Transfer of Eligible Credit Support.
    
    marginAmount : Money
    The Base Currency Equivalent of an amount equal to the sum of the initial margin amounts.
    
    threshold : Money
    With respect to a party, the Base Currency Equivalent of the amount specified for that party, if no amount is specified, zero.
    
    marginApproach : MarginApproachEnum
    
    marginAmountIA : Money
    The Base Currency Equivalent of an amount equal to the sum of the Independent Amounts.
    
    minimumTransferAmount : Money
    With respect to a party, the Base Currency Equivalent of the amount specified for that party, if no amount is specified, zero.
    
    rounding : CollateralRounding
    Rounding methodology applicable to the Delivery Amount and the Return Amount in terms of nearest integral multiple of Base Currency units.
    
    disputedDeliveryAmount : Money
    If a party (a 'Disputing Party') disputes the Calculation Agent (IM)s calculation of a Delivery Amount (IM).
    
    baseCurrency : string
    Base Currency means the currency specified as such in Paragraph 13.
    
    Returns
    -------
    result : Money
    
    """
    _pre_registry = {}
    self = inspect.currentframe()
    
    # conditions
    
    @rosetta_local_condition(_pre_registry)
    def condition_0_CurrencyMatches(self):
        return (all_elements(rosetta_resolve_attr(self, "baseCurrency"), "=", rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "minimumTransferAmount"), "unit"), "currency")) and all_elements(rosetta_resolve_attr(self, "baseCurrency"), "=", rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "disputedDeliveryAmount"), "unit"), "currency")))
    # Execute all registered conditions
    execute_local_conditions(_pre_registry, 'Pre-condition')
    
    def _then_fn0():
        return RoundToNearest(rosetta_resolve_attr(self, "undisputedDeliveryAmount"), rosetta_resolve_attr(rosetta_resolve_attr(self, "rounding"), "deliveryAmount"), rosetta_resolve_attr(RoundingModeEnum, "UP"))
    
    def _else_fn0():
        return 0.0
    
    undisputedAdjustedPostedCreditSupportAmount = UndisputedAdjustedPostedCreditSupportAmount(rosetta_resolve_attr(self, "postedCreditSupportItems"), rosetta_resolve_attr(self, "priorDeliveryAmountAdjustment"), rosetta_resolve_attr(self, "priorReturnAmountAdjustment"), rosetta_resolve_attr(self, "disputedTransferredPostedCreditSupportAmount"), rosetta_resolve_attr(self, "baseCurrency"))
    creditSupportAmount = CreditSupportAmount(rosetta_resolve_attr(self, "marginAmount"), rosetta_resolve_attr(self, "threshold"), rosetta_resolve_attr(self, "marginApproach"), rosetta_resolve_attr(self, "marginAmountIA"), rosetta_resolve_attr(self, "baseCurrency"))
    deliveryAmount = Max((rosetta_resolve_attr(rosetta_resolve_attr(self, "creditSupportAmount"), "value") - rosetta_resolve_attr(rosetta_resolve_attr(self, "undisputedAdjustedPostedCreditSupportAmount"), "value")), 0.0)
    undisputedDeliveryAmount = Max((rosetta_resolve_attr(self, "deliveryAmount") - rosetta_resolve_attr(rosetta_resolve_attr(self, "disputedDeliveryAmount"), "value")), 0.0)
    result = _get_rosetta_object('Money', 'value', if_cond_fn(all_elements(rosetta_resolve_attr(self, "undisputedDeliveryAmount"), ">=", rosetta_resolve_attr(rosetta_resolve_attr(self, "minimumTransferAmount"), "value")), _then_fn0, _else_fn0))
    result = set_rosetta_attr(rosetta_resolve_attr(self, 'result'), 'unit->currency', rosetta_resolve_attr(self, "baseCurrency"))
    
    
    return result

sys.modules[__name__].__class__ = create_module_attr_guardian(sys.modules[__name__].__class__)
