# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
import sys
import datetime
import inspect
from decimal import Decimal
from rosetta.runtime.utils import *
from rosetta.runtime.func_proxy import replaceable, create_module_attr_guardian
from cdm.observable.asset.Money import Money
from cdm.legaldocumentation.csa.functions.PostedCreditSupportItemAmount import PostedCreditSupportItemAmount
from cdm.legaldocumentation.csa.PostedCreditSupportItem import PostedCreditSupportItem

__all__ = ['UndisputedAdjustedPostedCreditSupportAmount']


@replaceable
def UndisputedAdjustedPostedCreditSupportAmount(postedCreditSupportItems: list[PostedCreditSupportItem] | None, priorDeliveryAmountAdjustment: Money, priorReturnAmountAdjustment: Money, disputedTransferredPostedCreditSupportAmount: Money, baseCurrency: str) -> Money:
    """
    Calculates the value for Undisputed Adjusted Posted Credit Support Item.
    
    Parameters 
    ----------
    postedCreditSupportItems : PostedCreditSupportItem
    Posted Credit Support Items.
    
    priorDeliveryAmountAdjustment : Money
    The adjustment value to include any prior Delivery Amount (IM).
    
    priorReturnAmountAdjustment : Money
    The adjustment value to exclude any prior Return Amount (IM).
    
    disputedTransferredPostedCreditSupportAmount : Money
    The disputed value of any Transfer of Eligible Credit Support.
    
    baseCurrency : string
    Base Currency means the currency specified as such in Paragraph 13.
    
    Returns
    -------
    result : Money
    
    """
    _pre_registry = {}
    self = inspect.currentframe()
    
    # conditions
    
    @rosetta_local_condition(_pre_registry)
    def condition_0_CurrencyMatches(self):
        return ((all_elements(rosetta_resolve_attr(self, "baseCurrency"), "=", rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "priorDeliveryAmountAdjustment"), "unit"), "currency")) and all_elements(rosetta_resolve_attr(self, "baseCurrency"), "=", rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "priorReturnAmountAdjustment"), "unit"), "currency"))) and all_elements(rosetta_resolve_attr(self, "baseCurrency"), "=", rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "disputedTransferredPostedCreditSupportAmount"), "unit"), "currency")))
    # Execute all registered conditions
    execute_local_conditions(_pre_registry, 'Pre-condition')
    
    totalPostedCreditSupportAmount = (lambda item: sum(item))(list(map(lambda item: rosetta_resolve_attr(PostedCreditSupportItemAmount(item, rosetta_resolve_attr(self, "baseCurrency")), "value"), rosetta_resolve_attr(self, "postedCreditSupportItems"))))
    adjustedPostedCreditSupportAmount = ((rosetta_resolve_attr(self, "totalPostedCreditSupportAmount") + rosetta_resolve_attr(rosetta_resolve_attr(self, "priorDeliveryAmountAdjustment"), "value")) - rosetta_resolve_attr(rosetta_resolve_attr(self, "priorReturnAmountAdjustment"), "value"))
    result = _get_rosetta_object('Money', 'value', (rosetta_resolve_attr(self, "adjustedPostedCreditSupportAmount") - rosetta_resolve_attr(rosetta_resolve_attr(self, "disputedTransferredPostedCreditSupportAmount"), "value")))
    result = set_rosetta_attr(rosetta_resolve_attr(self, 'result'), 'unit->currency', rosetta_resolve_attr(self, "baseCurrency"))
    
    
    return result

sys.modules[__name__].__class__ = create_module_attr_guardian(sys.modules[__name__].__class__)
