# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['AutomaticEarlyTermination']


class AutomaticEarlyTermination(BaseDataClass):
    """
    A class to specify the Automatic Early Termination provision applicable to a Master Agreement.
    """
    fallbackAET: bool = Field(..., description="Specifies whether automatic termination applies in the event of certain bankruptcy events.")
    """
    Specifies whether automatic termination applies in the event of certain bankruptcy events.
    """
    indemnity: bool = Field(..., description="Specifies whether indemnity applies in the event AET is applicable to one or both of the parties.")
    """
    Specifies whether indemnity applies in the event AET is applicable to one or both of the parties.
    """
    partyElection: List[cdm.legaldocumentation.master.isda.AutomaticEarlyTerminationElection.AutomaticEarlyTerminationElection] = Field([], description="The party election specific to the Automatic Early Termination Clause.")
    """
    The party election specific to the Automatic Early Termination Clause.
    """
    
    @rosetta_condition
    def condition_0_FallbackAET(self):
        """
        The fallback Automatic Early Termination provision can only be specified as applicable if the Automatic Early Termination Clause is not applicable to one of the parties.
        """
        item = self
        def _then_fn0():
            return all_elements(rosetta_resolve_attr(rosetta_resolve_attr(self, "partyElection"), "isApplicable"), "=", False)
        
        def _else_fn0():
            return True
        
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "fallbackAET"), "=", True), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_1_Indemnity(self):
        """
        If Automatic Early Termination can never apply then indemnity cannot apply.
        """
        item = self
        def _then_fn0():
            return all_elements(rosetta_resolve_attr(self, "indemnity"), "=", False)
        
        def _else_fn0():
            return True
        
        return if_cond_fn((all_elements(rosetta_resolve_attr(self, "fallbackAET"), "=", False) and all_elements(rosetta_resolve_attr(rosetta_resolve_attr(self, "partyElection"), "isApplicable"), "=", False)), _then_fn0, _else_fn0)

import cdm 
import cdm.legaldocumentation.master.isda.AutomaticEarlyTerminationElection
