# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['ExtraordinaryEvents']


class ExtraordinaryEvents(BaseDataClass):
    """
    Where the underlying is shares, defines market events affecting the issuer of those shares that may require the terms of the transaction to be adjusted.
    """
    additionalBespokeTerms: List[cdm.legaldocumentation.transaction.Clause.Clause] = Field([], description="Where parties may optionnaly describe any extra bespoke agreements, in regards of the standardized Extraordinary Events.")
    """
    Where parties may optionnaly describe any extra bespoke agreements, in regards of the standardized Extraordinary Events.
    """
    mergerEvents: Optional[cdm.legaldocumentation.transaction.additionalterms.EquityCorporateEvents.EquityCorporateEvents] = Field(None, description="")
    tenderOfferEvents: Optional[cdm.legaldocumentation.transaction.additionalterms.EquityCorporateEvents.EquityCorporateEvents] = Field(None, description="")
    compositionOfCombinedConsideration: Optional[bool] = Field(None, description="")
    indexAdjustmentEvents: Optional[cdm.legaldocumentation.transaction.additionalterms.IndexAdjustmentEvents.IndexAdjustmentEvents] = Field(None, description="")
    additionalDisruptionEvents: Optional[cdm.legaldocumentation.transaction.AdditionalDisruptionEvents.AdditionalDisruptionEvents] = Field(None, description="")
    failureToDeliver: Optional[bool] = Field(None, description="If true, failure to deliver is applicable.")
    """
    If true, failure to deliver is applicable.
    """
    representations: Optional[cdm.legaldocumentation.transaction.additionalterms.Representations.Representations] = Field(None, description="")
    nationalizationOrInsolvency: Optional[cdm.legaldocumentation.master.NationalizationOrInsolvencyOrDelistingEventEnum.NationalizationOrInsolvencyOrDelistingEventEnum] = Field(None, description="")
    delisting: Optional[cdm.legaldocumentation.master.NationalizationOrInsolvencyOrDelistingEventEnum.NationalizationOrInsolvencyOrDelistingEventEnum] = Field(None, description="")
    
    @rosetta_condition
    def condition_0_ExtraordinaryEventsChoice(self):
        """
        condition to represent an FpML choice construct.
        """
        item = self
        return rosetta_check_one_of(self, 'additionalDisruptionEvents', 'failureToDeliver', necessity=True)

import cdm 
import cdm.legaldocumentation.transaction.Clause
import cdm.legaldocumentation.transaction.additionalterms.EquityCorporateEvents
import cdm.legaldocumentation.transaction.additionalterms.IndexAdjustmentEvents
import cdm.legaldocumentation.transaction.AdditionalDisruptionEvents
import cdm.legaldocumentation.transaction.additionalterms.Representations
import cdm.legaldocumentation.master.NationalizationOrInsolvencyOrDelistingEventEnum
