# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
import sys
import datetime
import inspect
from decimal import Decimal
from rosetta.runtime.utils import *
from rosetta.runtime.func_proxy import replaceable, create_module_attr_guardian
from cdm.event.common.Trade import Trade
from cdm.margin.schedule.functions.AdjustableDateResolution import AdjustableDateResolution

__all__ = ['AuxiliarEffectiveDate']


@replaceable
def AuxiliarEffectiveDate(trade: Trade) -> datetime.date:
    """
    Extracts the effective date of specific products such as interest rate swaps and swaptions.
    
    Parameters 
    ----------
    trade : Trade
    
    Returns
    -------
    effectiveDate : date
    
    """
    self = inspect.currentframe()
    
    
    def _then_fn1():
        return (lambda item: min(item))(list(map(lambda item: AdjustableDateResolution(item), rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_deep_attr(self, "economicTerms"), "payout"), "InterestRatePayout"), "calculationPeriodDates"), "effectiveDate"), "adjustableDate"))))
    
    def _else_fn1():
        return True
    
    def _then_fn0():
        return (lambda item: min(item))(list(map(lambda item: AdjustableDateResolution(item), rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "InterestRatePayout"), "calculationPeriodDates"), "effectiveDate"), "adjustableDate"))))
    
    def _else_fn0():
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_deep_attr(self, "economicTerms"), "payout"), "InterestRatePayout"), "calculationPeriodDates"), "effectiveDate"), "adjustableDate")), _then_fn1, _else_fn1)
    
    product = rosetta_resolve_attr(rosetta_resolve_attr(self, "trade"), "product")
    economicTerms = rosetta_resolve_attr(rosetta_resolve_attr(self, "product"), "economicTerms")
    effectiveDate =  if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "InterestRatePayout"), "calculationPeriodDates"), "effectiveDate"), "adjustableDate")), _then_fn0, _else_fn0)
    
    
    return effectiveDate

sys.modules[__name__].__class__ = create_module_attr_guardian(sys.modules[__name__].__class__)
