# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
import sys
import datetime
import inspect
from decimal import Decimal
from rosetta.runtime.utils import *
from rosetta.runtime.func_proxy import replaceable, create_module_attr_guardian
from cdm.event.common.Trade import Trade
from cdm.margin.schedule.functions.AdjustableDatesResolution import AdjustableDatesResolution
from cdm.base.datetime.functions.ConvertToAdjustableOrAdjustedOrRelativeDate import ConvertToAdjustableOrAdjustedOrRelativeDate
from cdm.margin.schedule.functions.DateDifferenceYears import DateDifferenceYears
from cdm.product.template.OptionExerciseStyleEnum import OptionExerciseStyleEnum
from cdm.margin.schedule.functions.AdjustableOrAdjustedOrRelativeDateResolution import AdjustableOrAdjustedOrRelativeDateResolution
from cdm.margin.schedule.StandardizedScheduleProductClassEnum import StandardizedScheduleProductClassEnum
from cdm.margin.schedule.functions.AuxiliarEffectiveDate import AuxiliarEffectiveDate
from cdm.margin.schedule.functions.AuxiliarTerminationDate import AuxiliarTerminationDate
from cdm.margin.schedule.functions.UnderlierForProduct import UnderlierForProduct
from cdm.margin.schedule.StandardizedScheduleAssetClassEnum import StandardizedScheduleAssetClassEnum

__all__ = ['StandardizedScheduleDuration']


@replaceable
def StandardizedScheduleDuration(trade: Trade, assetClass: StandardizedScheduleAssetClassEnum, productClass: StandardizedScheduleProductClassEnum) -> Decimal:
    """
    Extracts the duration of a trade, according to the product class-depending extraction method defined in the ISDA industry survey.
    
    Parameters 
    ----------
    trade : Trade
    
    assetClass : StandardizedScheduleAssetClassEnum
    
    productClass : StandardizedScheduleProductClassEnum
    
    Returns
    -------
    durationInYears : number
    
    """
    _post_registry = {}
    self = inspect.currentframe()
    
    
    def _then_fn0():
        return DateDifferenceYears(rosetta_resolve_attr(self, "transactionEffectiveDate"), rosetta_resolve_attr(self, "transactionTerminationDate"))
    
    def _else_fn0():
        return True
    
    def _then_fn1():
        return DateDifferenceYears(rosetta_resolve_attr(self, "underlyingTransactionEffectiveDate"), rosetta_resolve_attr(self, "underlyingTransactionTerminationDate"))
    
    def _else_fn1():
        return True
    
    def _then_fn5():
        return list(map(lambda item: item, max(AdjustableDatesResolution(rosetta_resolve_attr(rosetta_resolve_attr(item, "exerciseDates"), "adjustableDates")))))
    
    def _else_fn5():
        return True
    
    def _then_fn4():
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(item, "exerciseDates"), "adjustableDates")), _then_fn5, _else_fn5)
    
    def _else_fn4():
        return True
    
    def _then_fn3():
        return list(map(lambda item: AdjustableOrAdjustedOrRelativeDateResolution(ConvertToAdjustableOrAdjustedOrRelativeDate(item)), max(rosetta_resolve_attr(item, "expirationDate"))))
    
    def _else_fn3():
        return if_cond_fn(all_elements(rosetta_resolve_attr(item, "style"), "=", rosetta_resolve_attr(OptionExerciseStyleEnum, "BERMUDA")), _then_fn4, _else_fn4)
    
    def _then_fn2():
        return AdjustableOrAdjustedOrRelativeDateResolution(ConvertToAdjustableOrAdjustedOrRelativeDate(get_only_element(rosetta_resolve_attr(item, "expirationDate"))))
    
    def _else_fn2():
        return if_cond_fn(all_elements(rosetta_resolve_attr(item, "style"), "=", rosetta_resolve_attr(OptionExerciseStyleEnum, "EUROPEAN")), _then_fn3, _else_fn3)
    
    def _then_fn3():
        return DateDifferenceYears(rosetta_resolve_attr(self, "transactionEffectiveDate"), rosetta_resolve_attr(self, "optionExpiry"))
    
    def _else_fn3():
        return True
    
    def _then_fn9():
        return rosetta_resolve_attr(self, "underlyingTransactionTenorInYears")
    
    def _else_fn9():
        return True
    
    def _then_fn8():
        return rosetta_resolve_attr(self, "timeToOptionExpiryInYears")
    
    def _else_fn8():
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(self, "underlyingTransactionTenorInYears")), _then_fn9, _else_fn9)
    
    def _then_fn7():
        return (rosetta_resolve_attr(self, "timeToOptionExpiryInYears") + rosetta_resolve_attr(self, "underlyingTransactionTenorInYears"))
    
    def _else_fn7():
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(self, "timeToOptionExpiryInYears")), _then_fn8, _else_fn8)
    
    def _then_fn7():
        return rosetta_resolve_attr(self, "timeToOptionExpiryInYears")
    
    def _else_fn7():
        return True
    
    def _then_fn6():
        return if_cond_fn((rosetta_attr_exists(rosetta_resolve_attr(self, "timeToOptionExpiryInYears")) and rosetta_attr_exists(rosetta_resolve_attr(self, "underlyingTransactionTenorInYears"))), _then_fn7, _else_fn7)
    
    def _else_fn6():
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "productClass"), "=", rosetta_resolve_attr(StandardizedScheduleProductClassEnum, "OPTION")), _then_fn7, _else_fn7)
    
    def _then_fn5():
        return rosetta_resolve_attr(self, "transactionTenorInYears")
    
    def _else_fn5():
        return if_cond_fn((all_elements(rosetta_resolve_attr(self, "productClass"), "=", rosetta_resolve_attr(StandardizedScheduleProductClassEnum, "SWAPTION")) or all_elements(rosetta_resolve_attr(self, "productClass"), "=", rosetta_resolve_attr(StandardizedScheduleProductClassEnum, "SWAPTION_STRADDLE"))), _then_fn6, _else_fn6)
    
    def _then_fn4():
        return if_cond_fn((((((((all_elements(rosetta_resolve_attr(self, "productClass"), "=", rosetta_resolve_attr(StandardizedScheduleProductClassEnum, "SWAP")) or all_elements(rosetta_resolve_attr(self, "productClass"), "=", rosetta_resolve_attr(StandardizedScheduleProductClassEnum, "SWAP_WITH_CALLABLE_BERMUDAN_RIGHT_TO_ENTER_EXIT_SWAPS"))) or all_elements(rosetta_resolve_attr(self, "productClass"), "=", rosetta_resolve_attr(StandardizedScheduleProductClassEnum, "CROSS_CURRENCY_SWAP"))) or all_elements(rosetta_resolve_attr(self, "productClass"), "=", rosetta_resolve_attr(StandardizedScheduleProductClassEnum, "FORWARD_RATE_AGREEMENT"))) or all_elements(rosetta_resolve_attr(self, "productClass"), "=", rosetta_resolve_attr(StandardizedScheduleProductClassEnum, "SINGLE_NAME_CREDIT_DEFAULT_SWAP"))) or all_elements(rosetta_resolve_attr(self, "productClass"), "=", rosetta_resolve_attr(StandardizedScheduleProductClassEnum, "INDEX_CDS"))) or all_elements(rosetta_resolve_attr(self, "productClass"), "=", rosetta_resolve_attr(StandardizedScheduleProductClassEnum, "INDEX_TRANCHE"))) or all_elements(rosetta_resolve_attr(self, "productClass"), "=", rosetta_resolve_attr(StandardizedScheduleProductClassEnum, "CREDIT_NTH_TO_DEFAULT"))), _then_fn5, _else_fn5)
    
    def _else_fn4():
        return True
    
    def _then_fn5():
        return rosetta_resolve_attr(self, "genericDurationInYears")
    
    def _else_fn5():
        return rosetta_resolve_attr(self, "auxiliarDurationInYears")
    
    product = rosetta_resolve_attr(rosetta_resolve_attr(self, "trade"), "product")
    economicTerms = rosetta_resolve_attr(rosetta_resolve_attr(self, "product"), "economicTerms")
    underlier = UnderlierForProduct(rosetta_resolve_attr(self, "product"))
    transactionEffectiveDate = AdjustableOrAdjustedOrRelativeDateResolution(ConvertToAdjustableOrAdjustedOrRelativeDate(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "effectiveDate")))
    transactionTerminationDate = AdjustableOrAdjustedOrRelativeDateResolution(ConvertToAdjustableOrAdjustedOrRelativeDate(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "terminationDate")))
    transactionTenorInYears = if_cond_fn((rosetta_attr_exists(rosetta_resolve_attr(self, "transactionEffectiveDate")) and rosetta_attr_exists(rosetta_resolve_attr(self, "transactionTerminationDate"))), _then_fn0, _else_fn0)
    underlyingTransactionEffectiveDate = AdjustableOrAdjustedOrRelativeDateResolution(ConvertToAdjustableOrAdjustedOrRelativeDate(rosetta_resolve_attr(rosetta_resolve_deep_attr(self, "economicTerms"), "effectiveDate")))
    underlyingTransactionTerminationDate = AdjustableOrAdjustedOrRelativeDateResolution(ConvertToAdjustableOrAdjustedOrRelativeDate(rosetta_resolve_attr(rosetta_resolve_deep_attr(self, "economicTerms"), "terminationDate")))
    underlyingTransactionTenorInYears = if_cond_fn((rosetta_attr_exists(rosetta_resolve_attr(self, "underlyingTransactionEffectiveDate")) and rosetta_attr_exists(rosetta_resolve_attr(self, "underlyingTransactionTerminationDate"))), _then_fn1, _else_fn1)
    optionExpiry = (lambda item: list(map(lambda item: if_cond_fn(all_elements(rosetta_resolve_attr(item, "style"), "=", rosetta_resolve_attr(OptionExerciseStyleEnum, "AMERICAN")), _then_fn2, _else_fn2), item)))(rosetta_resolve_attr(get_only_element(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "OptionPayout")), "exerciseTerms"))
    timeToOptionExpiryInYears = if_cond_fn((rosetta_attr_exists(rosetta_resolve_attr(self, "transactionEffectiveDate")) and rosetta_attr_exists(rosetta_resolve_attr(self, "optionExpiry"))), _then_fn3, _else_fn3)
    genericDurationInYears = if_cond_fn((all_elements(rosetta_resolve_attr(self, "assetClass"), "=", rosetta_resolve_attr(StandardizedScheduleAssetClassEnum, "INTEREST_RATES")) or all_elements(rosetta_resolve_attr(self, "assetClass"), "=", rosetta_resolve_attr(StandardizedScheduleAssetClassEnum, "CREDIT"))), _then_fn4, _else_fn4)
    auxiliarDurationInYears = DateDifferenceYears(AuxiliarEffectiveDate(rosetta_resolve_attr(self, "trade")), AuxiliarTerminationDate(rosetta_resolve_attr(self, "trade")))
    durationInYears =  if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(self, "genericDurationInYears")), _then_fn0, _else_fn0)
    
    # post-conditions
    
    @rosetta_local_condition(_post_registry)
    def condition_0_PositiveDuration(self):
        """
        Ensure duration is greater than 0.
        """
        return all_elements(rosetta_resolve_attr(self, "durationInYears"), ">", 0)
    # Execute all registered post-conditions
    execute_local_conditions(_post_registry, 'Post-condition')
    
    return durationInYears

sys.modules[__name__].__class__ = create_module_attr_guardian(sys.modules[__name__].__class__)
