# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
import sys
import datetime
import inspect
from decimal import Decimal
from rosetta.runtime.utils import *
from rosetta.runtime.func_proxy import replaceable, create_module_attr_guardian
from cdm.margin.schedule.functions.StandardizedScheduleFXVarianceNotionalAmount import StandardizedScheduleFXVarianceNotionalAmount
from cdm.margin.schedule.functions.StandardizedScheduleFXSwapNotional import StandardizedScheduleFXSwapNotional
from cdm.margin.schedule.functions.StandardizedScheduleVarianceSwapNotionalAmount import StandardizedScheduleVarianceSwapNotionalAmount
from cdm.margin.schedule.functions.StandardizedScheduleCommoditySwapFixedFloatNotionalAmount import StandardizedScheduleCommoditySwapFixedFloatNotionalAmount
from cdm.margin.schedule.functions.StandardizedScheduleMonetaryNotionalFromResolvablePQ import StandardizedScheduleMonetaryNotionalFromResolvablePQ
from cdm.margin.schedule.StandardizedScheduleAssetClassEnum import StandardizedScheduleAssetClassEnum
from cdm.margin.schedule.functions.FXFarLeg import FXFarLeg
from cdm.event.common.Trade import Trade
from cdm.margin.schedule.functions.StandardizedScheduleCommodityForwardNotionalAmount import StandardizedScheduleCommodityForwardNotionalAmount
from cdm.margin.schedule.functions.StandardizedScheduleOptionNotionalAmount import StandardizedScheduleOptionNotionalAmount
from cdm.margin.schedule.StandardizedScheduleProductClassEnum import StandardizedScheduleProductClassEnum
from cdm.margin.schedule.functions.StandardizedScheduleEquityForwardNotionalAmount import StandardizedScheduleEquityForwardNotionalAmount

__all__ = ['StandardizedScheduleNotional']


@replaceable
def StandardizedScheduleNotional(trade: Trade, assetClass: StandardizedScheduleAssetClassEnum, productClass: StandardizedScheduleProductClassEnum) -> Decimal:
    """
    Extracts the notional amount of a trade, according to the product class-depending extraction method defined in the ISDA industry survey.
    
    Parameters 
    ----------
    trade : Trade
    
    assetClass : StandardizedScheduleAssetClassEnum
    
    productClass : StandardizedScheduleProductClassEnum
    
    Returns
    -------
    notional : number
    
    """
    _post_registry = {}
    self = inspect.currentframe()
    
    
    def _then_fn5():
        return (lambda item: StandardizedScheduleMonetaryNotionalFromResolvablePQ(item))((lambda item: rosetta_resolve_attr(item, "priceQuantity"))((lambda item: get_only_element(item))(rosetta_filter(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "InterestRatePayout"), lambda item: rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(item, "rateSpecification"), "FixedRateSpecification"))))))
    
    def _else_fn5():
        return True
    
    def _then_fn4():
        return (lambda item: StandardizedScheduleMonetaryNotionalFromResolvablePQ(item))(rosetta_resolve_attr(get_only_element(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "InterestRatePayout")), "priceQuantity"))
    
    def _else_fn4():
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "productClass"), "=", rosetta_resolve_attr(StandardizedScheduleProductClassEnum, "FORWARD_RATE_AGREEMENT")), _then_fn5, _else_fn5)
    
    def _then_fn3():
        return (lambda item: StandardizedScheduleMonetaryNotionalFromResolvablePQ(item))((lambda item: rosetta_resolve_attr(item, "priceQuantity"))((lambda item: item[0])(rosetta_filter(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_deep_attr(self, "economicTerms"), "payout"), "InterestRatePayout"), lambda item: rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(item, "priceQuantity"), "quantitySchedule"))))))
    
    def _else_fn3():
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "productClass"), "=", rosetta_resolve_attr(StandardizedScheduleProductClassEnum, "OPTION")), _then_fn4, _else_fn4)
    
    def _then_fn2():
        return (lambda item: StandardizedScheduleMonetaryNotionalFromResolvablePQ(item))((lambda item: rosetta_resolve_attr(item, "priceQuantity"))((lambda item: item[0])(rosetta_filter(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "InterestRatePayout"), lambda item: True))))
    
    def _else_fn2():
        return if_cond_fn((all_elements(rosetta_resolve_attr(self, "productClass"), "=", rosetta_resolve_attr(StandardizedScheduleProductClassEnum, "SWAPTION")) or all_elements(rosetta_resolve_attr(self, "productClass"), "=", rosetta_resolve_attr(StandardizedScheduleProductClassEnum, "SWAPTION_STRADDLE"))), _then_fn3, _else_fn3)
    
    def _then_fn1():
        return (lambda item: StandardizedScheduleMonetaryNotionalFromResolvablePQ(item))((lambda item: rosetta_resolve_attr(item, "priceQuantity"))((lambda item: item[0])(rosetta_filter(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "InterestRatePayout"), lambda item: rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(item, "priceQuantity"), "quantitySchedule"))))))
    
    def _else_fn1():
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "productClass"), "=", rosetta_resolve_attr(StandardizedScheduleProductClassEnum, "CROSS_CURRENCY_SWAP")), _then_fn2, _else_fn2)
    
    def _then_fn3():
        return (lambda item: StandardizedScheduleMonetaryNotionalFromResolvablePQ(item))(rosetta_resolve_attr(get_only_element(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_deep_attr(self, "economicTerms"), "payout"), "CreditDefaultPayout")), "priceQuantity"))
    
    def _else_fn3():
        return True
    
    def _then_fn2():
        return (lambda item: StandardizedScheduleMonetaryNotionalFromResolvablePQ(item))(rosetta_resolve_attr(get_only_element(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "CreditDefaultPayout")), "priceQuantity"))
    
    def _else_fn2():
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "productClass"), "=", rosetta_resolve_attr(StandardizedScheduleProductClassEnum, "SWAPTION")), _then_fn3, _else_fn3)
    
    def _then_fn11():
        return 0.0
    
    def _else_fn11():
        return True
    
    def _then_fn10():
        return 0.0
    
    def _else_fn10():
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "productClass"), "=", rosetta_resolve_attr(StandardizedScheduleProductClassEnum, "CORRELATION_SWAP")), _then_fn11, _else_fn11)
    
    def _then_fn9():
        return StandardizedScheduleFXVarianceNotionalAmount(get_only_element(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "PerformancePayout")))
    
    def _else_fn9():
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "productClass"), "=", rosetta_resolve_attr(StandardizedScheduleProductClassEnum, "VOLATILITY_SWAP")), _then_fn10, _else_fn10)
    
    def _then_fn8():
        return rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(get_only_element(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "OptionPayout")), "priceQuantity"), "quantitySchedule"), "value")
    
    def _else_fn8():
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "productClass"), "=", rosetta_resolve_attr(StandardizedScheduleProductClassEnum, "VARIANCE_SWAP")), _then_fn9, _else_fn9)
    
    def _then_fn7():
        return rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(get_only_element(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "OptionPayout")), "priceQuantity"), "quantitySchedule"), "value")
    
    def _else_fn7():
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "productClass"), "=", rosetta_resolve_attr(StandardizedScheduleProductClassEnum, "NON_DELIVERABLE_OPTION")), _then_fn8, _else_fn8)
    
    def _then_fn6():
        return rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(get_only_element(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "SettlementPayout")), "priceQuantity"), "quantitySchedule"), "value")
    
    def _else_fn6():
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "productClass"), "=", rosetta_resolve_attr(StandardizedScheduleProductClassEnum, "DELIVERABLE_OPTION")), _then_fn7, _else_fn7)
    
    def _then_fn5():
        return rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(get_only_element(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "SettlementPayout")), "priceQuantity"), "quantitySchedule"), "value")
    
    def _else_fn5():
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "productClass"), "=", rosetta_resolve_attr(StandardizedScheduleProductClassEnum, "NON_DELIVERABLE_FORWARD")), _then_fn6, _else_fn6)
    
    def _then_fn4():
        return 0.0
    
    def _else_fn4():
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "productClass"), "=", rosetta_resolve_attr(StandardizedScheduleProductClassEnum, "DELIVERABLE_FORWARD")), _then_fn5, _else_fn5)
    
    def _then_fn3():
        return rosetta_resolve_attr(StandardizedScheduleFXSwapNotional(FXFarLeg(rosetta_resolve_attr(self, "product")), get_only_element(rosetta_resolve_attr(rosetta_resolve_attr(self, "trade"), "tradeLot"))), "value")
    
    def _else_fn3():
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "productClass"), "=", rosetta_resolve_attr(StandardizedScheduleProductClassEnum, "NON_DELIVERABLE_CROSS_CURRENCY_SWAP")), _then_fn4, _else_fn4)
    
    def _then_fn9():
        return 0.0
    
    def _else_fn9():
        return True
    
    def _then_fn8():
        return 0.0
    
    def _else_fn8():
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "productClass"), "=", rosetta_resolve_attr(StandardizedScheduleProductClassEnum, "SWAPS_AND_PORTFOLIO_SWAPS")), _then_fn9, _else_fn9)
    
    def _then_fn7():
        return StandardizedScheduleVarianceSwapNotionalAmount(get_only_element(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "PerformancePayout")))
    
    def _else_fn7():
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "productClass"), "=", rosetta_resolve_attr(StandardizedScheduleProductClassEnum, "VOLATILITY_SWAP")), _then_fn8, _else_fn8)
    
    def _then_fn6():
        return 0.0
    
    def _else_fn6():
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "productClass"), "=", rosetta_resolve_attr(StandardizedScheduleProductClassEnum, "VARIANCE_SWAP")), _then_fn7, _else_fn7)
    
    def _then_fn5():
        return StandardizedScheduleEquityForwardNotionalAmount(get_only_element(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "SettlementPayout")))
    
    def _else_fn5():
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "productClass"), "=", rosetta_resolve_attr(StandardizedScheduleProductClassEnum, "DIVIDEND_SWAP")), _then_fn6, _else_fn6)
    
    def _then_fn4():
        return StandardizedScheduleOptionNotionalAmount(get_only_element(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "OptionPayout")))
    
    def _else_fn4():
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "productClass"), "=", rosetta_resolve_attr(StandardizedScheduleProductClassEnum, "FORWARD")), _then_fn5, _else_fn5)
    
    def _then_fn9():
        return StandardizedScheduleCommoditySwapFixedFloatNotionalAmount(rosetta_resolve_deep_attr(self, "economicTerms"))
    
    def _else_fn9():
        return True
    
    def _then_fn8():
        return 0.0
    
    def _else_fn8():
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "productClass"), "=", rosetta_resolve_attr(StandardizedScheduleProductClassEnum, "SWAPTION")), _then_fn9, _else_fn9)
    
    def _then_fn7():
        return StandardizedScheduleCommoditySwapFixedFloatNotionalAmount(rosetta_resolve_attr(self, "economicTerms"))
    
    def _else_fn7():
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "productClass"), "=", rosetta_resolve_attr(StandardizedScheduleProductClassEnum, "BASIS_SWAP")), _then_fn8, _else_fn8)
    
    def _then_fn6():
        return StandardizedScheduleOptionNotionalAmount(get_only_element(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "OptionPayout")))
    
    def _else_fn6():
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "productClass"), "=", rosetta_resolve_attr(StandardizedScheduleProductClassEnum, "FIXED_FLOAT_SWAP")), _then_fn7, _else_fn7)
    
    def _then_fn5():
        return StandardizedScheduleCommodityForwardNotionalAmount(rosetta_resolve_attr(self, "economicTerms"))
    
    def _else_fn5():
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "productClass"), "=", rosetta_resolve_attr(StandardizedScheduleProductClassEnum, "OPTION")), _then_fn6, _else_fn6)
    
    def _then_fn4():
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "productClass"), "=", rosetta_resolve_attr(StandardizedScheduleProductClassEnum, "FORWARD")), _then_fn5, _else_fn5)
    
    def _else_fn4():
        return True
    
    def _then_fn3():
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "productClass"), "=", rosetta_resolve_attr(StandardizedScheduleProductClassEnum, "OPTION")), _then_fn4, _else_fn4)
    
    def _else_fn3():
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "assetClass"), "=", rosetta_resolve_attr(StandardizedScheduleAssetClassEnum, "COMMODITY")), _then_fn4, _else_fn4)
    
    def _then_fn2():
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "productClass"), "=", rosetta_resolve_attr(StandardizedScheduleProductClassEnum, "DELIVERABLE_SWAP")), _then_fn3, _else_fn3)
    
    def _else_fn2():
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "assetClass"), "=", rosetta_resolve_attr(StandardizedScheduleAssetClassEnum, "EQUITY")), _then_fn3, _else_fn3)
    
    def _then_fn1():
        return if_cond_fn((((all_elements(rosetta_resolve_attr(self, "productClass"), "=", rosetta_resolve_attr(StandardizedScheduleProductClassEnum, "SINGLE_NAME_CREDIT_DEFAULT_SWAP")) or all_elements(rosetta_resolve_attr(self, "productClass"), "=", rosetta_resolve_attr(StandardizedScheduleProductClassEnum, "INDEX_CDS"))) or all_elements(rosetta_resolve_attr(self, "productClass"), "=", rosetta_resolve_attr(StandardizedScheduleProductClassEnum, "INDEX_TRANCHE"))) or all_elements(rosetta_resolve_attr(self, "productClass"), "=", rosetta_resolve_attr(StandardizedScheduleProductClassEnum, "CREDIT_NTH_TO_DEFAULT"))), _then_fn2, _else_fn2)
    
    def _else_fn1():
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "assetClass"), "=", rosetta_resolve_attr(StandardizedScheduleAssetClassEnum, "FOREIGN_EXCHANGE")), _then_fn2, _else_fn2)
    
    def _then_fn0():
        return if_cond_fn((all_elements(rosetta_resolve_attr(self, "productClass"), "=", rosetta_resolve_attr(StandardizedScheduleProductClassEnum, "SWAP")) or all_elements(rosetta_resolve_attr(self, "productClass"), "=", rosetta_resolve_attr(StandardizedScheduleProductClassEnum, "SWAP_WITH_CALLABLE_BERMUDAN_RIGHT_TO_ENTER_EXIT_SWAPS"))), _then_fn1, _else_fn1)
    
    def _else_fn0():
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "assetClass"), "=", rosetta_resolve_attr(StandardizedScheduleAssetClassEnum, "CREDIT")), _then_fn1, _else_fn1)
    
    product = rosetta_resolve_attr(rosetta_resolve_attr(self, "trade"), "product")
    economicTerms = rosetta_resolve_attr(rosetta_resolve_attr(self, "product"), "economicTerms")
    notional =  if_cond_fn(all_elements(rosetta_resolve_attr(self, "assetClass"), "=", rosetta_resolve_attr(StandardizedScheduleAssetClassEnum, "INTEREST_RATES")), _then_fn0, _else_fn0)
    
    # post-conditions
    
    @rosetta_local_condition(_post_registry)
    def condition_0_PositiveNotional(self):
        """
        Ensure notional is greater than 0
        """
        return all_elements(rosetta_resolve_attr(self, "notional"), ">", 0)
    # Execute all registered post-conditions
    execute_local_conditions(_post_registry, 'Post-condition')
    
    return notional

sys.modules[__name__].__class__ = create_module_attr_guardian(sys.modules[__name__].__class__)
