# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
import sys
import datetime
import inspect
from decimal import Decimal
from rosetta.runtime.utils import *
from rosetta.runtime.func_proxy import replaceable, create_module_attr_guardian
from cdm.base.staticdata.asset.rates.FloatingRateIndexEnum import FloatingRateIndexEnum
from cdm.legaldocumentation.common.ContractualDefinitionsEnum import ContractualDefinitionsEnum
from cdm.observable.asset.fro.functions.FloatingRateIndexMetadata import FloatingRateIndexMetadata

__all__ = ['ValidateFloatingRateIndexName']


@replaceable
def ValidateFloatingRateIndexName(floatingRateIndexName: FloatingRateIndexEnum, contractualDefs: ContractualDefinitionsEnum | None) -> bool:
    """
    Return whether the supplied floating rate index name is valid for the supplied contractual definitions.
    
    Parameters 
    ----------
    floatingRateIndexName : FloatingRateIndexEnum
    The name of the floating rate index.
    
    contractualDefs : ContractualDefinitionsEnum
    The contractual definitions to validate against.
    
    Returns
    -------
    isValid : boolean
    
    """
    self = inspect.currentframe()
    
    
    def _then_fn0():
        return rosetta_resolve_attr(self, "defsOk")
    
    def _else_fn0():
        return rosetta_attr_exists(rosetta_resolve_attr(self, "defs"))
    
    defs = FloatingRateIndexMetadata(rosetta_resolve_attr(self, "floatingRateIndexName"))
    isPresent = rosetta_attr_exists(rosetta_resolve_attr(self, "defs"))
    defsOk = contains(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "defs"), "supportedDefinition"), "contractualDefinitionIdentifier"), "contractualDefinitionType"), rosetta_resolve_attr(self, "contractualDefs"))
    okDefs = if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(self, "contractualDefs")), _then_fn0, _else_fn0)
    isValid =  rosetta_resolve_attr(self, "okDefs")
    
    
    return isValid

sys.modules[__name__].__class__ = create_module_attr_guardian(sys.modules[__name__].__class__)
