# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
import sys
import datetime
import inspect
from decimal import Decimal
from rosetta.runtime.utils import *
from rosetta.runtime.func_proxy import replaceable, create_module_attr_guardian
from cdm.observable.asset.PriceQuantity import PriceQuantity
from cdm.observable.asset.PriceTypeEnum import PriceTypeEnum

__all__ = ['InterestRateObservableCondition']


@replaceable
def InterestRateObservableCondition(pq: PriceQuantity) -> bool:
    """
    Implementation for PriceQuantity.InterestRateObservable condition.
    
    Parameters 
    ----------
    pq : PriceQuantity
    
    Returns
    -------
    valid : boolean
    
    """
    self = inspect.currentframe()
    
    
    def _then_fn0():
        return all_elements(list(map(lambda item: (all_elements(rosetta_resolve_attr(item, "priceType"), "=", rosetta_resolve_attr(PriceTypeEnum, "INTEREST_RATE")) and rosetta_attr_exists(rosetta_resolve_attr(item, "arithmeticOperator"))), rosetta_resolve_attr(rosetta_resolve_attr(self, "pq"), "price"))), "=", True)
    
    def _else_fn0():
        return True
    
    valid =  if_cond_fn((rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "pq"), "observable"), "Index"), "InterestRateIndex")) and rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "pq"), "price"))), _then_fn0, _else_fn0)
    
    
    return valid

sys.modules[__name__].__class__ = create_module_attr_guardian(sys.modules[__name__].__class__)
