# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
import sys
import datetime
import inspect
from decimal import Decimal
from rosetta.runtime.utils import *
from rosetta.runtime.func_proxy import replaceable, create_module_attr_guardian
from cdm.observable.asset.Observable import Observable

__all__ = ['ObservableIsCommodity']


@replaceable
def ObservableIsCommodity(observable: Observable | None) -> bool:
    """
    Validates whether all of the constituents of an Observable are Commodities.
    
    Parameters 
    ----------
    observable : Observable
    
    Returns
    -------
    valid : boolean
    
    """
    self = inspect.currentframe()
    
    
    def _then_fn2():
        return all_elements(rosetta_resolve_deep_attr(self, "assetClass"), "=", Commodity)
    
    def _else_fn2():
        return False
    
    def _then_fn1():
        return all_elements(list(map(lambda item: rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(item, "Asset"), "Commodity")), rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "observable"), "Basket"), "basketConstituent"))), "=", True)
    
    def _else_fn1():
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "observable"), "Index")), _then_fn2, _else_fn2)
    
    def _then_fn0():
        return rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "observable"), "Asset"), "Commodity"))
    
    def _else_fn0():
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "observable"), "Basket")), _then_fn1, _else_fn1)
    
    valid =  if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "observable"), "Asset")), _then_fn0, _else_fn0)
    
    
    return valid

sys.modules[__name__].__class__ = create_module_attr_guardian(sys.modules[__name__].__class__)
