# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
import sys
import datetime
import inspect
from decimal import Decimal
from rosetta.runtime.utils import *
from rosetta.runtime.func_proxy import replaceable, create_module_attr_guardian
from cdm.event.common.TradeState import TradeState
from cdm.observable.event.functions.Create_AssetReset import Create_AssetReset
from cdm.event.common.BillingRecordInstruction import BillingRecordInstruction

__all__ = ['Create_AssetPayoutTradeStateWithObservations']


@replaceable
def Create_AssetPayoutTradeStateWithObservations(billingInstruction: BillingRecordInstruction) -> TradeState:
    """
    Attaches a set of Observations to a Security Finance Transaction.
    
    Parameters 
    ----------
    billingInstruction : BillingRecordInstruction
    
    Returns
    -------
    tradeState : TradeState
    
    """
    self = inspect.currentframe()
    
    
    assetPayout = get_only_element(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_deep_attr(self, "economicTerms"), "payout"), "AssetPayout"))
    date = rosetta_resolve_attr(rosetta_resolve_attr(self, "billingInstruction"), "recordEndDate")
    tradeState =  rosetta_resolve_attr(rosetta_resolve_attr(self, "billingInstruction"), "tradeState")
    tradeState.add_rosetta_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, tradeState), 'resetHistory'), Create_AssetReset(rosetta_resolve_attr(self, "assetPayout"), rosetta_resolve_attr(rosetta_resolve_attr(self, "billingInstruction"), "observation"), rosetta_resolve_attr(self, "date")))
    
    
    return tradeState

sys.modules[__name__].__class__ = create_module_attr_guardian(sys.modules[__name__].__class__)
