# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['EligibleCollateralSpecification']


class EligibleCollateralSpecification(BaseDataClass):
    """
    Represents a set of criteria used to specify eligible collateral.
    """
    identifier: List[cdm.base.staticdata.identifier.Identifier.Identifier] = Field([], description="Specifies the identifier(s) to uniquely identify eligible collateral or a set of eligible collateral, such as a schedule or equivalant for an identity issuer.")
    """
    Specifies the identifier(s) to uniquely identify eligible collateral or a set of eligible collateral, such as a schedule or equivalant for an identity issuer.
    """
    party: List[cdm.base.staticdata.party.Party.Party] = Field([], description="The parties associated with the specification.")
    """
    The parties associated with the specification.
    """
    counterparty: List[cdm.base.staticdata.party.Counterparty.Counterparty] = Field([], description="Specification of the roles of the counterparties to the specification.")
    """
    Specification of the roles of the counterparties to the specification.
    """
    criteria: List[cdm.product.collateral.EligibleCollateralCriteria.EligibleCollateralCriteria] = Field([], description="Represents a set of criteria used to specify eligible collateral.")
    """
    Represents a set of criteria used to specify eligible collateral.
    """
    @rosetta_condition
    def cardinality_criteria(self):
        return check_cardinality(self.criteria, 1, None)
    
    partyRole: List[cdm.base.staticdata.party.PartyRole.PartyRole] = Field([], description="Specifies the role(s) that each of the party(s) is playing in the context of the specification, eg Payor or Receiver.")
    """
    Specifies the role(s) that each of the party(s) is playing in the context of the specification, eg Payor or Receiver.
    """

import cdm 
import cdm.base.staticdata.identifier.Identifier
import cdm.base.staticdata.party.Party
import cdm.base.staticdata.party.Counterparty
import cdm.product.collateral.EligibleCollateralCriteria
import cdm.base.staticdata.party.PartyRole
