# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
import sys
import datetime
import inspect
from decimal import Decimal
from rosetta.runtime.utils import *
from rosetta.runtime.func_proxy import replaceable, create_module_attr_guardian
from cdm.base.staticdata.asset.common.InstrumentTypeEnum import InstrumentTypeEnum
from cdm.base.staticdata.asset.common.AssetClassEnum import AssetClassEnum
from cdm.observable.asset.Observable import Observable

__all__ = ['ObservableQualification']


@replaceable
def ObservableQualification(observable: Observable | None, securityType: InstrumentTypeEnum | None, assetClass: AssetClassEnum | None) -> bool:
    """
    Identifies whether the observable(s) have either the specified securityType or assetClass.
    
    Parameters 
    ----------
    observable : Observable
    An Observable is an Asset, Basket or Index.
    
    securityType : InstrumentTypeEnum
    
    assetClass : AssetClassEnum
    
    Returns
    -------
    qualifies : boolean
    
    """
    self = inspect.currentframe()
    
    
    def _then_fn0():
        return all_elements(list(map(lambda item: ObservableQualification(item, rosetta_resolve_attr(self, "securityType"), rosetta_resolve_attr(self, "assetClass")), rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "observable"), "Basket"), "basketConstituent"))), "=", True)
    
    def _else_fn0():
        return False
    
    qualifies =  ((all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "observable"), "Asset"), "Instrument"), "Security"), "instrumentType"), "=", rosetta_resolve_attr(self, "securityType")) or all_elements(rosetta_resolve_deep_attr(self, "assetClass"), "=", rosetta_resolve_attr(self, "assetClass"))) or if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "observable"), "Basket")), _then_fn0, _else_fn0))
    
    
    return qualifies

sys.modules[__name__].__class__ = create_module_attr_guardian(sys.modules[__name__].__class__)
