# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
import sys
import datetime
import inspect
from decimal import Decimal
from rosetta.runtime.utils import *
from rosetta.runtime.func_proxy import replaceable, create_module_attr_guardian
from cdm.product.template.EconomicTerms import EconomicTerms
from cdm.product.qualification.functions.Qualify_Commodity_Swap_Basis import Qualify_Commodity_Swap_Basis
from cdm.product.qualification.functions.Qualify_Commodity_Swap_FixedFloat import Qualify_Commodity_Swap_FixedFloat

__all__ = ['Qualify_Commodity_Swaption']


@replaceable
def Qualify_Commodity_Swaption(economicTerms: EconomicTerms) -> bool:
    """
    Qualifies a product as a Swaption that can be exercised into a Commodity Swap, which could be any type of interest rate product with two legs based on the economic terms.
    
    Parameters 
    ----------
    economicTerms : EconomicTerms
    
    Returns
    -------
    is_product : boolean
    
    """
    self = inspect.currentframe()
    
    
    is_product =  (rosetta_attr_exists(rosetta_resolve_attr(get_only_element(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout")), "OptionPayout")) and (all_elements(Qualify_Commodity_Swap_Basis(rosetta_resolve_deep_attr(self, "economicTerms")), "=", True) or all_elements(Qualify_Commodity_Swap_FixedFloat(rosetta_resolve_deep_attr(self, "economicTerms")), "=", True)))
    
    
    return is_product

sys.modules[__name__].__class__ = create_module_attr_guardian(sys.modules[__name__].__class__)
