# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['EconomicTerms']


class EconomicTerms(BaseDataClass):
    """
     This class represents the full set of price-forming features associated with a contractual product: the payout component, the notional/quantity, the effective and termination date and the date adjustment provisions when applying uniformily across the payout components. This class also includes the legal provisions which have valuation implications: cancelable provision, extendible provision, early termination provision and extraordinary events specification.
    """
    effectiveDate: Optional[cdm.base.datetime.AdjustableOrRelativeDate.AdjustableOrRelativeDate] = Field(None, description="The first day of the terms of the trade. This day may be subject to adjustment in accordance with a business day convention.")
    """
    The first day of the terms of the trade. This day may be subject to adjustment in accordance with a business day convention.
    """
    terminationDate: Optional[cdm.base.datetime.AdjustableOrRelativeDate.AdjustableOrRelativeDate] = Field(None, description="The last day of the terms of the trade. This date may be subject to adjustments in accordance with the business day convention. It can also be specified in relation to another scheduled date (e.g. the last payment date).")
    """
    The last day of the terms of the trade. This date may be subject to adjustments in accordance with the business day convention. It can also be specified in relation to another scheduled date (e.g. the last payment date).
    """
    dateAdjustments: Optional[cdm.base.datetime.BusinessDayAdjustments.BusinessDayAdjustments] = Field(None, description="The business day adjustment convention when it applies across all the payout components. This specification of the business day convention and financial business centers is used for adjusting any calculation period date if it would otherwise fall on a day that is not a business day in the specified business center.")
    """
    The business day adjustment convention when it applies across all the payout components. This specification of the business day convention and financial business centers is used for adjusting any calculation period date if it would otherwise fall on a day that is not a business day in the specified business center.
    """
    payout: List[cdm.product.template.Payout.Payout] = Field([], description="The payout specifies the future cashflow computation methodology which characterizes a financial product.")
    """
    The payout specifies the future cashflow computation methodology which characterizes a financial product.
    """
    @rosetta_condition
    def cardinality_payout(self):
        return check_cardinality(self.payout, 1, None)
    
    terminationProvision: Optional[cdm.product.template.TerminationProvision.TerminationProvision] = Field(None, description="Contains optional provisions pertaining to the termination characteristics of a contract.")
    """
    Contains optional provisions pertaining to the termination characteristics of a contract.
    """
    calculationAgent: Optional[cdm.observable.asset.CalculationAgent.CalculationAgent] = Field(None, description="The ISDA calculation agent responsible for performing duties as defined in the applicable product definitions.")
    """
    The ISDA calculation agent responsible for performing duties as defined in the applicable product definitions.
    """
    nonStandardisedTerms: Optional[bool] = Field(None, description="Specifies, when boolean value is True, that additional economic terms exist that have not been included in the product representation.")
    """
    Specifies, when boolean value is True, that additional economic terms exist that have not been included in the product representation.
    """
    collateral: Optional[cdm.product.collateral.Collateral.Collateral] = Field(None, description="Represents the collateral obligations of a party.")
    """
    Represents the collateral obligations of a party.
    """
    
    @rosetta_condition
    def condition_0_ReturnType_Total_Requires_Dividends(self):
        """
        A total return implies both a price and a dividend return
        """
        item = self
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "PerformancePayout"), "returnTerms"), "dividendReturnTerms"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "PerformancePayout"), "returnTerms"), "priceReturnTerms"), "returnType"), "=", rosetta_resolve_attr(ReturnTypeEnum, "TOTAL")), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_1_LastRegularPaymentDate(self):
        """
        FpML specifies that lastRegularPaymentDate must only be included if there is a final stub. As part of the CDM, this data rule has been adjusted to specify that it only applies to interest rate swaps, as the credit derivatives products can have a specified lastRegularPaymentDate while the stub is typically not applicable to those.
        """
        item = self
        def _then_fn0():
            return all_elements(rosetta_count(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "InterestRatePayout")), "=", 2)
        
        def _else_fn0():
            return True
        
        return if_cond_fn((rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "InterestRatePayout"), "paymentDates"), "lastRegularPaymentDate")) and rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "InterestRatePayout"), "stubPeriod"), "finalStub"))), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_2_PayRelativeTo(self):
        """
        FpML specifies a required payRelativeTo element as part of the PaymentDates. As standardized CDS don't have such payRelativeTo provision, the cardinality has been relaxed as part of the CDM. This data rule specifies that if the product has two interest rate streams, this provision must exist.
        """
        item = self
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "InterestRatePayout"), "paymentDates"), "payRelativeTo"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn((all_elements(rosetta_count(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "InterestRatePayout")), "=", 2) and rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "InterestRatePayout"), "paymentDates"))), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_3_PaymentDatesAdjustments(self):
        """
        FpML specifies a required paymentDatesAdjustments element as part of the PaymentDates. As standardized CDS don't have such paymentDatesAdjustments provision, the cardinality has been relaxed as part of the CDM. This data rule specifies that if the product has two interest rate streams, this provision must exist.
        """
        item = self
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "InterestRatePayout"), "paymentDates"), "paymentDatesAdjustments"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn((all_elements(rosetta_count(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "InterestRatePayout")), "=", 2) and rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "InterestRatePayout"), "paymentDates"))), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_4_PaymentFrequency(self):
        """
        FpML specifies a required paymentFrequency element as part of the PaymentDates. As standardized CDS may not have such paymentFrequency provision, the cardinality has been relaxed as part of the CDM. This data rule specifies that if the product has two interest rate streams, this provision must exist.
        """
        item = self
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "InterestRatePayout"), "paymentDates"), "paymentFrequency"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn((all_elements(rosetta_count(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "InterestRatePayout")), "=", 2) and rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "InterestRatePayout"), "paymentDates"))), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_5_Quantity(self):
        """
        When there is an OptionPayout the quantity can be expressed as part of the payoutQuantity, or as part of the underlier in the case of a Swaption.  For all other payouts that extend PayoutBase the payoutQuantity is a mandatory attribute.
        """
        item = self
        def _then_fn0():
            return (rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "OptionPayout"), "priceQuantity")) or all_elements(rosetta_count(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_deep_attr(self, "economicTerms"), "payout"), "InterestRatePayout")), "=", 2))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "OptionPayout")), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_6_DayCountFraction(self):
        """
        FpML specifies a required dayCountFraction element as part of the swapStream/calculationPeriodAmount/calculation. As standardized CDS don't have such specified day count fraction, the cardinality has been relaxed as part of the CDM. This data rule specifies that if the product has two interest rate streams, this provision must exist.
        """
        item = self
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "InterestRatePayout"), "dayCountFraction"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(all_elements(rosetta_count(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "InterestRatePayout")), "=", 2), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_7_PaymentDates(self):
        """
        FpML specifies a required paymentDates element as part of the swapStream. As standardized CDS may not have specified payment dates, the cardinality has been relaxed as part of the CDM. This data rule specifies that if the product has two interest rate streams, this provision must exist.
        """
        item = self
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "InterestRatePayout"), "dayCountFraction"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(all_elements(rosetta_count(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "InterestRatePayout")), "=", 2), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_8_MarketPrice(self):
        """
        FpML specifies that marketFixedRate and marketPrice only have meaning in a credit index trade
        """
        item = self
        def _then_fn0():
            return ((not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "CreditDefaultPayout"), "transactedPrice"), "marketFixedRate"))) and (not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "CreditDefaultPayout"), "transactedPrice"), "marketPrice"))))
        
        def _else_fn0():
            return True
        
        return if_cond_fn((not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "CreditDefaultPayout"), "generalTerms"), "indexReferenceInformation"))), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_9_NotionalResetOnPerformancePayout(self):
        """
        Notional reset only applies to return swaps, and therefore can only exist on an performancePayout or interestRatePayouts that are associated with it.
        """
        item = self
        return ((((((not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "CreditDefaultPayout"), "priceQuantity"), "reset"))) and (not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "AssetPayout"), "priceQuantity"), "reset")))) and (not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "CommodityPayout"), "priceQuantity"), "reset")))) and (not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "FixedPricePayout"), "priceQuantity"), "reset")))) and (not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "SettlementPayout"), "priceQuantity"), "reset")))) and (not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "OptionPayout"), "priceQuantity"), "reset"))))
    
    @rosetta_condition
    def condition_10_NotionalResetInterestRatePayoutExists(self):
        """
        As the performancePayout->payoutQuantity->reset attribute applies to return swaps, the interestRatePayout needs to be present alongside it.
        """
        item = self
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "InterestRatePayout"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(contains(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "PerformancePayout"), "priceQuantity"), "reset"), True), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_11_FpML_cd_26_28(self):
        """
        FpML validation rule cd-26 - If feeLeg/singlePayment/adjustablePaymentDate exists, then feeLeg/singlePayment/adjustablePaymentDate must be after generalTerms/effectiveDate/unadjustedDate. FpML validation rule cd-28 - If feeLeg/periodicPayment/firstPaymentDate exists, then feeLeg/periodicPayment/firstPaymentDate must be after generalTerms/effectiveDate/unadjustedDate. This data rule tackles those two FpML validation rules at once, as the singlePayment and the firstPayment have been represented through the same Payout/cashflow attribute.
        """
        item = self
        return True
    
    @rosetta_condition
    def condition_12_FpML_cd_27(self):
        """
        FpML validation rule cd-27 - If feeLeg/singlePayment/adjustablePaymentDate exists, and if generalTerms/scheduledTerminationDate exists, then feeLeg/singlePayment/adjustablePaymentDate must be before generalTerms/scheduledTerminationDate/unadjustedDate.
        """
        item = self
        return True
    
    @rosetta_condition
    def condition_13_FpML_cd_30(self):
        """
        FpML validation rule cd-30 - If feeLeg/periodicPayment/lastRegularPaymentDate exists, and if generalTerms/scheduledTerminationDate exists, then feeLeg/periodicPayment/lastRegularPaymentDate must be before generalTerms/scheduledTerminationDate/unadjustedDate.
        """
        item = self
        def _then_fn0():
            return (all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "InterestRatePayout"), "paymentDates"), "lastRegularPaymentDate"), "<", rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "terminationDate"), "adjustableDate"), "unadjustedDate")) or all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "InterestRatePayout"), "paymentDates"), "lastRegularPaymentDate"), "<", rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "terminationDate"), "adjustableDate"), "adjustedDate")))
        
        def _else_fn0():
            return True
        
        return if_cond_fn((rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "InterestRatePayout"), "paymentDates"), "lastRegularPaymentDate")) and rosetta_attr_exists(rosetta_resolve_attr(self, "terminationDate"))), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_14_IndependentCalculationAgent(self):
        item = self
        def _then_fn0():
            return all_elements(rosetta_resolve_attr(rosetta_resolve_attr(self, "calculationAgent"), "calculationAgentParty"), "=", rosetta_resolve_attr(AncillaryRoleEnum, "CALCULATION_AGENT_INDEPENDENT"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "calculationAgent"), "calculationAgentParty")), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_15_AssetPayoutDividendTermsValidation(self):
        """
        Validates that if the transaction has Dividend Terms specified then it should be a Term trade.
        """
        item = self
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(self, "terminationDate"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "AssetPayout"), "dividendTerms")), _then_fn0, _else_fn0)

import cdm 
import cdm.base.datetime.AdjustableOrRelativeDate
import cdm.base.datetime.BusinessDayAdjustments
import cdm.product.template.Payout
import cdm.product.template.TerminationProvision
import cdm.observable.asset.CalculationAgent
import cdm.product.collateral.Collateral
from cdm.product.asset.ReturnTypeEnum import ReturnTypeEnum
from cdm.base.staticdata.party.AncillaryRoleEnum import AncillaryRoleEnum
