# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['ExtendibleProvision']

from cdm.base.staticdata.party.BuyerSeller import BuyerSeller

class ExtendibleProvision(BuyerSeller):
    """
    A data defining:  an option to extend an existing swap transaction on the specified exercise dates for a term ending on the specified new termination date. As a difference from FpML, it extends the BuyerSeller class, which represents the BuyerSeller.model.
    """
    exerciseNotice: Optional[cdm.product.template.ExerciseNotice.ExerciseNotice] = Field(None, description="Definition of the party to whom notice of exercise should be given.")
    """
    Definition of the party to whom notice of exercise should be given.
    """
    followUpConfirmation: Optional[bool] = Field(None, description="A flag to indicate whether follow-up confirmation of exercise (written or electronic) is required following telephonic notice by the buyer to the seller or seller's agent.")
    """
    A flag to indicate whether follow-up confirmation of exercise (written or electronic) is required following telephonic notice by the buyer to the seller or seller's agent.
    """
    extendibleProvisionAdjustedDates: Optional[cdm.product.template.ExtendibleProvisionAdjustedDates.ExtendibleProvisionAdjustedDates] = Field(None, description="The adjusted dates associated with an extendible provision. These dates have been adjusted for any applicable business day convention.")
    """
    The adjusted dates associated with an extendible provision. These dates have been adjusted for any applicable business day convention.
    """
    callingParty: Optional[cdm.product.template.CallingPartyEnum.CallingPartyEnum] = Field(None, description="")
    singlePartyOption: Optional[cdm.base.staticdata.party.PartyRole.PartyRole] = Field(None, description="If the ability to extend the contract is not available to both parties then this component specifies the buyer and seller of the option.")
    """
    If the ability to extend the contract is not available to both parties then this component specifies the buyer and seller of the option.
    """
    noticeDeadlinePeriod: Optional[cdm.base.datetime.RelativeDateOffset.RelativeDateOffset] = Field(None, description="Defines the minimum period before a contract is scheduled to terminate that notice can be given that it will terminate beyond the scheduled termination date.")
    """
    Defines the minimum period before a contract is scheduled to terminate that notice can be given that it will terminate beyond the scheduled termination date.
    """
    noticeDeadlineDateTime: Optional[datetime.datetime] = Field(None, description="A specific date and time for the notice deadline")
    """
    A specific date and time for the notice deadline
    """
    extensionTerm: Optional[cdm.base.datetime.RelativeDateOffset.RelativeDateOffset] = Field(None, description="The length of each extension period relative to the effective date of the preceding contract.")
    """
    The length of each extension period relative to the effective date of the preceding contract.
    """
    extensionPeriod: Optional[cdm.base.datetime.AdjustableRelativeOrPeriodicDates.AdjustableRelativeOrPeriodicDates] = Field(None, description="The period within which notice can be given that the contract will be extended.")
    """
    The period within which notice can be given that the contract will be extended.
    """
    exerciseTerms: cdm.product.template.ExerciseTerms.ExerciseTerms = Field(..., description="The exercise terms associated with the extendible provision, including details such as exercise style, exercise fees, and any other relevant conditions or terms governing the extension of the swap transaction.")
    """
    The exercise terms associated with the extendible provision, including details such as exercise style, exercise fees, and any other relevant conditions or terms governing the extension of the swap transaction.
    """
    
    @rosetta_condition
    def condition_0_ExtendibleProvisionExerciseNoticeReceiverParty(self):
        item = self
        def _then_fn0():
            return all_elements(rosetta_resolve_attr(rosetta_resolve_attr(self, "exerciseNotice"), "exerciseNoticeReceiver"), "=", rosetta_resolve_attr(AncillaryRoleEnum, "EXERCISE_NOTICE_RECEIVER_PARTY_EXTENDIBLE_PROVISION"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "exerciseNotice"), "exerciseNoticeReceiver")), _then_fn0, _else_fn0)

import cdm 
import cdm.product.template.ExerciseNotice
import cdm.product.template.ExtendibleProvisionAdjustedDates
import cdm.product.template.CallingPartyEnum
import cdm.base.staticdata.party.PartyRole
import cdm.base.datetime.RelativeDateOffset
import cdm.base.datetime.AdjustableRelativeOrPeriodicDates
import cdm.product.template.ExerciseTerms
from cdm.base.staticdata.party.AncillaryRoleEnum import AncillaryRoleEnum
