# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['Underlier']


class Underlier(BaseDataClass):
    """
    The underlying financial product that will be physically or cash settled, which can be of any type, eg an asset such as cash or a security, a product, or the cash settlement of an index rate.  Conditions are usually applied when used in a data type, such as a payout, to ensure this aligns with the use case.
    """
    Observable: Optional[AttributeWithAddress[cdm.observable.asset.Observable.Observable] | cdm.observable.asset.Observable.Observable] = Field(None, description="Specifies the object to be observed for a price, it could be an asset or a reference.")
    """
    Specifies the object to be observed for a price, it could be an asset or a reference.
    """
    Product: Optional[cdm.product.template.Product.Product] = Field(None, description="Enables either a TransferableProduct or a NonTransferableProduct to be used in an underlier.")
    """
    Enables either a TransferableProduct or a NonTransferableProduct to be used in an underlier.
    """
    
    @rosetta_condition
    def condition_0_Choice(self):
        item = self
        return rosetta_check_one_of(self, 'Observable', 'Product', necessity=True)

import cdm 
import cdm.observable.asset.Observable
import cdm.product.template.Product
