# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
import sys
import datetime
import inspect
from decimal import Decimal
from rosetta.runtime.utils import *
from rosetta.runtime.func_proxy import replaceable, create_module_attr_guardian
from cdm.base.math.NonNegativeQuantity import NonNegativeQuantity
from cdm.base.staticdata.asset.common.Asset import Asset
from cdm.product.template.SettlementPayout import SettlementPayout
from cdm.product.common.settlement.Cashflow import Cashflow
from cdm.product.common.settlement.CashflowType import CashflowType
from cdm.base.staticdata.asset.common.AssetIdentifier import AssetIdentifier
from cdm.base.staticdata.asset.common.Cash import Cash
from cdm.base.staticdata.party.PayerReceiver import PayerReceiver
from cdm.base.math.UnitType import UnitType

__all__ = ['Create_CashflowFromSettlementPayout']


@replaceable
def Create_CashflowFromSettlementPayout(payout: SettlementPayout) -> Cashflow:
    """
    Generates two opposite cashflows that correspond to a settlement payout. One leg is the asset leg, that settles the asset according to the quantity, direction and date defined in the settlement payout. The other is the price leg, that settles the price as a currency amount going in the opposite direction. The function's applicability is limited on purpose to a single asset with a single price and quantity specified.
    
    Parameters 
    ----------
    payout : SettlementPayout
    The settlement payout from which the cashflows are generated.
    
    Returns
    -------
    cashflows : Cashflow
    
    """
    _pre_registry = {}
    self = inspect.currentframe()
    
    # conditions
    
    @rosetta_local_condition(_pre_registry)
    def condition_0_Asset(self):
        """
        Restricts the function's applicability to a single asset for the underlier.
        """
        return rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "underlier"), "Observable"), "Asset"))
    
    @rosetta_local_condition(_pre_registry)
    def condition_1_SettlementDate(self):
        """
        Restricts the function's applicability to the adjustable or relative date for the settlement date.
        """
        return rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "settlementTerms"), "settlementDate"), "adjustableOrRelativeDate"))
    
    @rosetta_local_condition(_pre_registry)
    def condition_2_SinglePriceAndQuantity(self):
        """
        Restricts the function's applicability to a single quantity and price.
        """
        return (rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "priceQuantity"), "quantitySchedule"), "value")) and rosetta_attr_exists(rosetta_resolve_attr(get_only_element(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "priceQuantity"), "priceSchedule")), "value")))
    # Execute all registered conditions
    execute_local_conditions(_pre_registry, 'Pre-condition')
    
    assetLeg = Cashflow(quantity=NonNegativeQuantity(value=rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "priceQuantity"), "quantitySchedule"), "value"), unit=rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "priceQuantity"), "quantitySchedule"), "unit")), asset=rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "underlier"), "Observable"), "Asset"), settlementDate=rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "settlementTerms"), "settlementDate"), "adjustableOrRelativeDate"), payerReceiver=rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "payerReceiver"), cashflowType=CashflowType(cashflowType=PrincipalPayment))
    priceLegAmount = (rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "priceQuantity"), "quantitySchedule"), "value") * rosetta_resolve_attr(get_only_element(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "priceQuantity"), "priceSchedule")), "value"))
    priceLegCurrency = rosetta_resolve_attr(rosetta_resolve_attr(get_only_element(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "priceQuantity"), "priceSchedule")), "unit"), "currency")
    priceLegPayerReceiver = PayerReceiver(payer=rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "payerReceiver"), "receiver"), receiver=rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "payerReceiver"), "payer"))
    priceLeg = Cashflow(quantity=NonNegativeQuantity(value=rosetta_resolve_attr(self, "priceLegAmount"), unit=UnitType(currency=rosetta_resolve_attr(self, "priceLegCurrency"))), asset=Asset(Cash=Cash(identifier=AssetIdentifier(identifier=rosetta_resolve_attr(self, "priceLegCurrency"), identifierType=CurrencyCode))), settlementDate=rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "settlementTerms"), "settlementDate"), "adjustableOrRelativeDate"), payerReceiver=rosetta_resolve_attr(self, "priceLegPayerReceiver"), cashflowType=CashflowType(cashflowType=PrincipalPayment))
    cashflows =  [rosetta_resolve_attr(self, "assetLeg"), rosetta_resolve_attr(self, "priceLeg")]
    
    
    return cashflows

sys.modules[__name__].__class__ = create_module_attr_guardian(sys.modules[__name__].__class__)
