/*
 * Decompiled with CFR 0.152.
 */
package com.symphony.bdk.ext.group;

import com.symphony.bdk.core.auth.AuthSession;
import com.symphony.bdk.core.client.ApiClientFactory;
import com.symphony.bdk.core.retry.RetryWithRecovery;
import com.symphony.bdk.core.retry.RetryWithRecoveryBuilder;
import com.symphony.bdk.core.retry.function.SupplierWithApiException;
import com.symphony.bdk.core.service.pagination.CursorBasedPaginatedApi;
import com.symphony.bdk.core.service.pagination.CursorBasedPaginatedService;
import com.symphony.bdk.core.service.pagination.model.CursorPaginatedPayload;
import com.symphony.bdk.core.util.UserIdUtil;
import com.symphony.bdk.ext.group.auth.OAuth;
import com.symphony.bdk.ext.group.auth.OAuthSession;
import com.symphony.bdk.ext.group.gen.api.GroupApi;
import com.symphony.bdk.ext.group.gen.api.model.AddMember;
import com.symphony.bdk.ext.group.gen.api.model.CreateGroup;
import com.symphony.bdk.ext.group.gen.api.model.GroupList;
import com.symphony.bdk.ext.group.gen.api.model.Member;
import com.symphony.bdk.ext.group.gen.api.model.ReadGroup;
import com.symphony.bdk.ext.group.gen.api.model.SortOrder;
import com.symphony.bdk.ext.group.gen.api.model.Status;
import com.symphony.bdk.ext.group.gen.api.model.UpdateGroup;
import com.symphony.bdk.ext.group.gen.api.model.UploadAvatar;
import com.symphony.bdk.extension.BdkExtensionService;
import com.symphony.bdk.http.api.ApiClient;
import com.symphony.bdk.http.api.ApiException;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(status=API.Status.EXPERIMENTAL, since="20.13")
public class SymphonyGroupService
implements BdkExtensionService {
    private final RetryWithRecoveryBuilder<?> retryBuilder;
    private final GroupApi groupApi;

    public SymphonyGroupService(RetryWithRecoveryBuilder<?> retryBuilder, ApiClientFactory apiClientFactory, AuthSession session) {
        OAuthSession oAuthSession = new OAuthSession(apiClientFactory.getLoginClient(), session, retryBuilder);
        oAuthSession.refresh();
        this.retryBuilder = RetryWithRecoveryBuilder.copyWithoutRecoveryStrategies(retryBuilder).recoveryStrategy(ApiException::isUnauthorized, oAuthSession::refresh);
        ApiClient client = apiClientFactory.getPodClient("/profile-manager");
        OAuth auth = new OAuth(oAuthSession::getBearerToken);
        client.getAuthentications().put("bearerAuth", auth);
        this.groupApi = new GroupApi(client);
    }

    public ReadGroup insertGroup(@Nonnull CreateGroup group) {
        return (ReadGroup)this.executeAndRetry("groupExt.insertGroup", () -> this.groupApi.insertGroup("", group));
    }

    public ReadGroup updateGroup(@Nonnull String ifMatch, @Nonnull String groupId, @Nonnull UpdateGroup updateGroup) {
        return (ReadGroup)this.executeAndRetry("groupExt.updateGroup", () -> this.groupApi.updateGroup("", ifMatch, groupId, updateGroup));
    }

    public ReadGroup updateAvatar(@Nonnull String groupId, @Nonnull byte[] image) {
        return (ReadGroup)this.executeAndRetry("groupExt.updateAvatar", () -> this.groupApi.updateAvatar("", groupId, new UploadAvatar().image(image)));
    }

    public ReadGroup getGroup(@Nonnull String groupId) {
        return (ReadGroup)this.executeAndRetry("groupExt.getGroup", () -> this.groupApi.getGroup("", groupId));
    }

    public GroupList listGroups(@Nullable Status status, @Nullable String before, @Nullable String after, @Nullable Integer limit, @Nullable SortOrder sortOrder) {
        return (GroupList)this.executeAndRetry("groupExt.listGroups", () -> this.groupApi.listGroups("", "SDL", status, before, after, limit, sortOrder));
    }

    @API(status=API.Status.EXPERIMENTAL)
    public Stream<ReadGroup> listAllGroups(@Nullable Status status, @Nullable SortOrder sortOrder, @Nullable Integer chunkSize, @Nullable Integer maxItems) {
        CursorBasedPaginatedApi paginatedApi = (after, limit) -> new PayloadAdapter(this.listGroups(status, null, after, limit, sortOrder));
        return new CursorBasedPaginatedService(paginatedApi, chunkSize, maxItems).stream();
    }

    public ReadGroup addMemberToGroup(@Nonnull String groupId, @Nonnull Long userId) {
        return (ReadGroup)this.executeAndRetry("groupExt.addMemberToGroup", () -> this.groupApi.addMemberToGroup("", groupId, new AddMember().member(new Member().memberId(userId).memberTenant(UserIdUtil.extractTenantId((long)userId)))));
    }

    private <T> T executeAndRetry(String name, SupplierWithApiException<T> supplier) {
        return (T)RetryWithRecovery.executeAndRetry(this.retryBuilder, (String)name, (String)this.groupApi.getApiClient().getBasePath(), supplier);
    }

    private static class PayloadAdapter
    implements CursorPaginatedPayload<ReadGroup> {
        private GroupList payload;

        public PayloadAdapter(GroupList payload) {
            this.payload = payload;
        }

        public String getNext() {
            if (this.payload.getPagination() != null && this.payload.getPagination().getCursors() != null) {
                return this.payload.getPagination().getCursors().getAfter();
            }
            return null;
        }

        public List<ReadGroup> getData() {
            return this.payload.getData();
        }
    }
}

