/*
 * Decompiled with CFR 0.152.
 */
package com.symphony.bdk.ext.group.auth;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.symphony.bdk.core.auth.AuthSession;
import com.symphony.bdk.core.retry.RetryWithRecovery;
import com.symphony.bdk.core.retry.RetryWithRecoveryBuilder;
import com.symphony.bdk.http.api.ApiClient;
import com.symphony.bdk.http.api.ApiException;
import com.symphony.bdk.http.api.ApiResponse;
import com.symphony.bdk.http.api.Pair;
import com.symphony.bdk.http.api.util.TypeReference;
import java.util.Collections;
import javax.annotation.Nonnull;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public class OAuthSession {
    private final ApiClient loginClient;
    private final AuthSession session;
    private final RetryWithRecoveryBuilder<?> retryBuilder;
    private String bearerToken;

    public OAuthSession(@Nonnull ApiClient loginClient, @Nonnull AuthSession session, @Nonnull RetryWithRecoveryBuilder<?> retryBuilder) {
        this.loginClient = loginClient;
        this.session = session;
        this.retryBuilder = RetryWithRecoveryBuilder.copyWithoutRecoveryStrategies(retryBuilder).recoveryStrategy(ApiException::isUnauthorized, () -> ((AuthSession)session).refresh());
    }

    public void refresh() {
        this.bearerToken = (String)RetryWithRecovery.executeAndRetry(this.retryBuilder, (String)"groupExt.auth", (String)this.loginClient.getBasePath(), this::doRefresh);
    }

    private String doRefresh() throws ApiException {
        ApiResponse response = this.loginClient.invokeAPI("/idm/tokens", "POST", Collections.singletonList(Pair.pair((String)"scope", (String)"profile-manager")), null, Collections.singletonMap("sessionToken", this.session.getSessionToken()), null, null, "application/json", "application/json", null, (TypeReference)new TypeReference<TokenResponse>(){});
        return ((TokenResponse)response.getData()).getToken();
    }

    public String getBearerToken() {
        return this.bearerToken;
    }

    @API(status=API.Status.INTERNAL)
    public static class TokenResponse {
        @JsonProperty(value="access_token")
        private String token;

        public String getToken() {
            return this.token;
        }

        @JsonProperty(value="access_token")
        public void setToken(String token) {
            this.token = token;
        }
    }
}

